/* Header file for .EXE file validation system. To use the .EXE file */
/* Validation system within your program, #include "exevalid.h", and */
/* add exevalid.c to your program's makefile / project file.         */

/* Other required headers. */
#include <stdio.h>

/* Boolean definitions. */
#ifndef BOOL
typedef int BOOL;
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

/* Macro definitions */
#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define MAX(x, y) ((x) > (y) ? (x) : (y))

/* Size of buffer to use for reading file. */
#define FILE_BUFFER_SIZE 16000

/* Hash code type definition. */
typedef unsigned long tHash;

/* EXE validation result codes. */
typedef enum
{
   kValid,
   kInvalid,
   kGeneralFailure
} eEXEValidResult;

/* Function prototypes. */
BOOL GetFileHash(FILE *pFile, long lnBytes, tHash *pnHash);
void UpdateHash(tHash *pnHash, char *pBuffer, long lnBytes);
eEXEValidResult ValidateEXE(char *pszEXEFileName);


