/*******
*
* (c) 1992-94 Manu Roibal
*
* This program has been created using
*
* FAST.lib 3.12
* FAST.GT  1.20
*
*/

#include "inkey.ch"
#include "fastgt.ch"

static gtHandle
static aOptions


Function Main()
Local aMsg1
Local aMsg2
Local aMsg3
Local aMsg4
Local lExit   := .T.
Local nKey    := 0
Local nCursor := SetCursor( 0 )
Local nX
Local nY
Local cFile
Local lFile
    SET SCOREBOARD OFF
    SET CONFIRM    ON
    SET BELL       OFF
    SetCancel( .F. )
    gtHandle := gtInit( 4 )
    aOptions := IniLoad( "install.ini", "INSTALL" )
    Cls
    gtWinBox( 1, 2, 28, 77, "W+/B", IniSearch( aOptions, "MAINWINTIT", "" ) )
    nX    := Val( IniSearch( aOptions, "LOGOX", "0" ) )
    nY    := Val( IniSearch( aOptions, "LOGOY", "0" ) )
    cFile := IniSearch( aOptions, "LOGOFILE", "" )
    lFile := File( cFile )
    If lFile
      pcxShow( cFile, .F., nX, nY )
      VESABox(  nY - 4, nX - 4, nY + pcxY2( cFile ) + 4, nX + pcxX2( cFile ) + 4,  7 )
      VESABox(  nY - 3, nX - 3, nY + pcxY2( cFile ) + 3, nX + pcxX2( cFile ) + 3, 15 )
      VESABox(  nY - 2, nX - 2, nY + pcxY2( cFile ) + 2, nX + pcxX2( cFile ) + 2, 15 )
      VESABox(  nY - 1, nX - 1, nY + pcxY2( cFile ) + 1, nX + pcxX2( cFile ) + 1,  7 )
      VESABox(  nY,     nX,     nY + pcxY2( cFile ),     nX + pcxX2( cFile ),      0 )
    EndIf
    MouseCursor( MOUSE_ON )
    aMsg1 := DrawButtom(  5,  5, PadR( IniSearch( aOptions, "MENUABOUT",  "" ), 30 ), .T. )
    aMsg2 := DrawButtom(  7,  5, PadR( IniSearch( aOptions, "MENUSYSTEM", "" ), 30 ), .T. )
    aMsg3 := DrawButtom(  9,  5, PadR( IniSearch( aOptions, "MENUBEGIN",  "" ), 30 ), .T. )
    aMsg4 := DrawButtom( 11,  5, PadR( IniSearch( aOptions, "MENUEXIT",   "" ), 30 ), .T. )
    While lExit
      nKey := Inkey( 0 )
      If nKey == K_MOUSE_LEFT
        If BtnMouse( aMsg2 )
          PushButtom( aMsg2 )
          Requeriments()
        ElseIf BtnMouse( aMsg3 )
          PushButtom( aMsg3 )
          If Begin() .AND. Inquire( IniSearch( aOptions, "MSGEXITINST", "" ) )
            lExit := .F.
          EndIf
        ElseIf BtnMouse( aMsg4 )
          PushButtom( aMsg4 )
          If Inquire( IniSearch( aOptions, "MSGEXIT", "" ) )
            lExit := .F.
          EndIf
        ElseIf BtnMouse( aMsg1 )
          PushButtom( aMsg1 )
          MsgInit()
        ElseIf lFile .And. MouseArea( nY, nX, nY + pcxY2( cFile ), nX + pcxX2( cFile ) )
          MyCompany()
        EndIf
      ElseIf nKey == K_ESC .OR. UPPER( CHR( nKey ) ) == SubStr( IniSearch( aOptions, "MENUEXIT", "" ), 1, 1 )
        PushButtom( aMsg4 )
        If Inquire( IniSearch( aOptions, "MSGEXIT", "" ) )
          lExit := .F.
        EndIf
      ElseIf UPPER( CHR( nKey ) ) == SubStr( IniSearch( aOptions, "MENUBEGIN", "" ), 1, 1 )
        PushButtom( aMsg3 )
        If Begin() .AND. Inquire( IniSearch( aOptions, "MSGEXITINST", "" ) )
          lExit := .F.
        EndIf
      ElseIf UPPER( CHR( nKey ) ) == SubStr( IniSearch( aOptions, "MENUSYSTEM", "" ), 1, 1 )
        PushButtom( aMsg2 )
        Requeriments()
      ElseIf UPPER( CHR( nKey ) ) == SubStr( IniSearch( aOptions, "MENUABOUT", "" ), 1, 1 )
        PushButtom( aMsg1 )
        MsgInit()
      ElseIf nKey == K_SPACE
        MyCompany()
      EndIf
    End
Return( Nil )



static function DrawButtom( nY, nX, cMessage, lStatus )
Local nPy  := nY * 16
Local nPx  := nX * 8
Local nLen := Len( cMessage ) + 2
Local lMouse    := MouseCursor( MOUSE_OFF )
    lStatus := If( lStatus == Nil, .T., lStatus )
    VESABox( nPy, nPx, nPy + 15, nPx + nLen * 8 + 7,  0 )
    VESASetArea( nPy + 1, nPx + 1, nPy + 14, nPx + nLen * 8 + 6, 15 )
    If lStatus
      VESASetArea( nPy + 13, nPx + 2, nPy + 13, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy + 14, nPx + 1, nPy + 14, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy +  2, nPx + nLen * 8 + 5, nPy + 13, nPx + nLen * 8 + 5, 7 )
      VESASetArea( nPy +  1, nPx + nLen * 8 + 6, nPy + 14, nPx + nLen * 8 + 6, 7 )
      VESAWriteAt( nPy + 4, nPx + 10, cMessage, 0, 15, FONT_SMALL )
      VESALine( nPy + 12, nPx + 10, nPy + 12, nPx + 16, 4 )
    Else
      VESASetArea( nPy + 1, nPx + 1, nPy +  1, nPx + nLen * 8 + 6, 7 )
      VESASetArea( nPy + 1, nPx + 1, nPy + 14, nPx + 1,            7 )
      VESAWriteAt( nPy + 6, nPx + 12, cMessage, 0, 15, FONT_SMALL )
      VESALine( nPy + 14, nPx + 12, nPy + 14, nPx + 18, 4 )
    EndIf
    MouseCursor( lMouse )
Return( { nY, nX, cMessage } )



static function PushButtom( hButtom )
    DrawButtom( hButtom[ 1 ], hButtom[ 2 ], hButtom[ 3 ], .F. )
    Inkey( 0.4 )
    DrawButtom( hButtom[ 1 ], hButtom[ 2 ], hButtom[ 3 ], .T. )
Return( Nil )



static function GTBox( nTop, nLeft, nBottom, nRight, cColor )
Local cOldColor := SetColor( cColor )
Local lMouse    := MouseCursor( MOUSE_OFF )
    Scroll( nTop, nLeft, nBottom, nRight )
    SetColor( cOldColor )
    nBottom++                           // convert to graphic coordinates
    nRight++
    nLeft   := nLeft   *  8 + 4
    nRight  := nRight  *  8 - 5
    nTop    := nTop    * 16 + 4
    nBottom := nBottom * 16 - 5
    VESABox(  nTop - 4, nLeft - 4, nBottom + 4, nRight + 4,  7 )
    VESABox(  nTop - 3, nLeft - 3, nBottom + 3, nRight + 3, 15 )
    VESABox(  nTop - 2, nLeft - 2, nBottom + 2, nRight + 2, 15 )
    VESABox(  nTop - 1, nLeft - 1, nBottom + 1, nRight + 1,  7 )
    VESABox(  nTop,     nLeft,     nBottom,     nRight,      0 )
    MouseCursor( lMouse )
Return( Nil )



static function GTWinBox( nY1, nX1, nY2, nX2, cColor, cTittle )
Local nPy1, nPx1, nPy2, nPx2, nCentre
Local lMouse    := MouseCursor( MOUSE_OFF )
    GTBox( nY1, nX1, nY2, nX2, cColor )
    nPy1 := nY1 * 16 + 5        // convert to graphic coordinates
    nPy2 := ( nY1 + 1 ) * 16
    nPx1 := nX1 * 8  + 5
    nPx2 := nX2 * 8  + 2
    VESASetArea( nPy1, nPx1, nPy2, nPx2, 1 )
    VESALine( nPy2, nPx1, nPy2, nPx2, 0 )
    VESALine( nPy1 - 1, nPx1, nPy1 - 1, nPx2, 3 )
    nCentre = ( nX1 + ( nX2 - nX1 ) / 2 - Len( cTittle ) / 2 ) * 8
    VESAWriteAt( nPy1 + 2, nCentre, cTittle, 15, 1, FONT_SMALL )
    MouseCursor( lMouse )
Return( Nil )



static function DrawIcon( hIcon, lMode )
Local nInc   := If( lMode == Nil .Or. lMode,  0,  1 )
Local nRow   := hIcon[ 1 ]
Local nCol   := hIcon[ 2 ]
Local nColor := If( lMode == Nil .Or. lMode,  8,  7 )
Local lMouse := MouseCursor( MOUSE_OFF )
    VESASetArea( nRow -  2, nCol - 2,  nRow -  1, nCol + 33, 7 )
    VESALine( nRow -  1, nCol + 32, nRow + 33, nCol + 32, nColor )
    VESALine( nRow -  2, nCol + 33, nRow + 33, nCol + 33, 8 )
    VESASetArea( nRow -  2, nCol - 2,  nRow + 33, nCol -  1, 7 )
    VESALine( nRow + 32, nCol -  1, nRow + 32, nCol + 32, nColor )
    VESALine( nRow + 33, nCol -  2, nRow + 33, nCol + 33, 8 )
    VESAShowIcon( nRow + nInc, nCol + nInc, hIcon[ 3 ] )
    MouseCursor( lMouse )
Return( Nil )



static Function BtnMouse( aMsg )
Local nY1   := aMsg[ 1 ] * 16
Local nX1   := aMsg[ 2 ] *  8
Local nY2   := ( aMsg[ 1 ] +  1 ) * 16
Local nX2   := ( aMsg[ 2 ] + Len( aMsg[ 3 ] ) + 2 ) * 8
Return( MouseArea( nY1, nX1, nY2, nX2 ) )



static Function Inquire( cMessage )
Local nLen     := Int( Len( cMessage ) / 2 )
Local cScreen  := SaveScreen( 12, 37 - nLen, 17, 40 + nLen )
Local cColor   := SetColor( "N/W" )
Local cOption1 := IniSearch( aOptions, "BTNOK",     "Yes" )
Local cOption2 := IniSearch( aOptions, "BTNCANCEL", "No"  )
Local cLetter
Local nAux
Local nKey
Local lQuery
Local lFlag
Local aBtn1
Local aBtn2
Local nCursor := SetCursor( 0 )
    nAux := Max( Len( cOption1 ), Len( cOption2 ) )
    cOption1 := PadR( cOption1, nAux )
    cOption2 := PadR( cOption2, nAux )
    cLetter  := SubStr( cOption1, 1, 1 ) + SubStr( cOption2, 1, 1 )
    gtWinBox( 12, 37 - nLen, 17, 40 + nLen, "W+/W", IniSearch( aOptions, "EXITWINTIT", "" ) )
    aBtn1 := DrawButtom( 16, 39 - 11, cOption1, .T. )
    aBtn2 := DrawButtom( 16, 39 +  5, cOption2, .T. )
    @ 14, 39 - nLen Say cMessage
    lFlag := .T.
    While lFlag
      nKey := Inkey( 0 )
      If nKey == K_MOUSE_LEFT
        If BtnMouse( aBtn1 )
          PushButtom( aBtn1 )
          lQuery := .T.
          lFlag  := .F.
        ElseIf BtnMouse( aBtn2 )
          PushButtom( aBtn2 )
          lQuery := .F.
          lFlag  := .F.
        EndIf
      ElseIf Upper( Chr( nKey ) ) $ cLetter
        lQuery := Upper( Chr( nKey ) ) == SubStr( cLetter, 1, 1 )
        lFlag  := .F.
      EndIf
    EndDo
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 12, 37 - nLen, 17, 40 + nLen, cScreen )
Return( lQuery )



static Function Requeriments()
Local cScreen  := SaveScreen( 8, 10, 19, 69 )
Local cColor   := SetColor( "N/W" )
Local nKey
Local lFlag
Local aBtn
Local nCursor  := SetCursor( 0 )
Local cOption  := IniSearch( aOptions, "BTNCONTINUE", "Continue" )
    gtWinBox( 8, 10, 19, 69, "W+/W", IniSearch( aOptions, "REQWINTIT", "" ) )
    aBtn := DrawButtom( 18, 39 - 5, cOption, .T. )
    @ 10, 12 Say PadC( IniSearch( aOptions, "REQUIREDISK",  "" ), 55 )
    @ 12, 12 Say PadC( IniSearch( aOptions, "REQUIREMEM",   "" ), 55 )
    @ 14, 12 Say PadC( IniSearch( aOptions, "REQUIREGRAPH", "" ), 55 )
    @ 16, 12 Say PadC( IniSearch( aOptions, "REQUIREOTHER", "" ), 55 )
    lFlag := .T.
    While lFlag
      nKey := Inkey( 0 )
      If nKey == K_MOUSE_LEFT
        If BtnMouse( aBtn )
          PushButtom( aBtn )
          lFlag  := .F.
        EndIf
      ElseIf UPPER( CHR( nKey ) ) == SubStr( cOption, 1, 1 )
        PushButtom( aBtn )
        lFlag  := .F.
      EndIf
    EndDo
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 8, 10, 19, 69, cScreen )
Return( Nil )



static Function MyCompany()
Local cScreen  := SaveScreen( 8, 10, 19, 69 )
Local cColor   := SetColor( "N/W" )
Local nKey
Local lFlag
Local aBtn
Local nCursor  := SetCursor( 0 )
Local cOption  := IniSearch( aOptions, "BTNCONTINUE", "Continue" )
    gtWinBox( 8, 10, 19, 69, "W+/W", IniSearch( aOptions, "COMPWINTIT", "" ) )
    aBtn := DrawButtom( 18, 39 - 5, cOption, .T. )
    @ 10, 12 Say PadC( IniSearch( aOptions, "COMPANY1", "" ), 55 )
    @ 11, 12 Say PadC( IniSearch( aOptions, "COMPANY2", "" ), 55 )
    @ 12, 12 Say PadC( IniSearch( aOptions, "COMPANY3", "" ), 55 )
    @ 13, 12 Say PadC( IniSearch( aOptions, "COMPANY4", "" ), 55 )
    @ 14, 12 Say PadC( IniSearch( aOptions, "COMPANY5", "" ), 55 )
    @ 15, 12 Say PadC( IniSearch( aOptions, "COMPANY6", "" ), 55 )
    @ 16, 12 Say PadC( IniSearch( aOptions, "COMPANY7", "" ), 55 )
    lFlag := .T.
    While lFlag
      nKey := Inkey( 0 )
      If nKey == K_MOUSE_LEFT
        If BtnMouse( aBtn )
          PushButtom( aBtn )
          lFlag  := .F.
        EndIf
      ElseIf UPPER( CHR( nKey ) ) == SubStr( cOption, 1, 1 )
        PushButtom( aBtn )
        lFlag  := .F.
      EndIf
    EndDo
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 8, 10, 19, 69, cScreen )
Return( Nil )



static function Begin()
Local cScreen  := SaveScreen( 14, 4, 27, 75 )
Local cPath    := IniSearch( aOptions, "INITIALPATH", "C:\" )
Local aPath
Local cOrgUnit := IniSearch( aOptions, "ORIGINUNIT",  "A:\" )
Local cZIPUnit := IniSearch( aOptions, "ZIPUNIT",     "C:\DOS\" )
Local cDisk
Local aComp
Local nDisk
Local nCursor  := SetCursor( 1 )
Local cColor   := SetColor( "N/W, B/W" )
Local nInd
Local lExit    := .F.
Local nOld     := AT( SubStr( fUnit( cArgV( 0 ) ), 1, 1 ), "ABCDEFGHIJKLMNOPQRSTUVWXYZ" ) - 1
Local cMask
Local cFile1
Local cFile2
Local cAux
Local nDiscos  := 0
Local lBandera
Local bBlock  := { || fErase( cPath + AllTrim( IniSearch( aOptions, "COMPRESSOR",   "" ) ) ), ;
                      fErase( cPath + AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) ) ), ;
                      fDefUnit( nOld ), ;
                      Tone( 100, 9 ), ;
                      Inkey( 30 ), ;
                      RestScreen( 14, 4, 27, 75, cScreen ) }
    If UPPER( IniSearch( aOptions, "CHANGEPATH", "YES" ) ) == "YES"
      GetDiskPath( @cPath, IniSearch( aOptions, "DSPTARGET", "" ) )
    EndIf
    SetColor( cColor )
    SetCursor( nCursor )
    If LastKey() != K_ESC
      cDisk := UPPER( fUnit( cPath ) )
      If Empty( cDisk )
        cDisk := "C"
        cPath := cDisk + ":\" + cPath
      ElseIf cDisk == "A" .OR. cDisk == "B"
        cDisk := "C"
        cPath := "C" + SubStr( cPath, 2, Len( cPath ) - 1 )
      EndIf
      gtBox( 14, 4, 27, 75, "W/W" )
      nDisk := AT( SubStr( cDisk, 1, 1 ), "ABCDEFGHIJKLMNOPQRSTUVWXYZ" )
      If nDisk > 0
        nDisk--
        WinWrite( IniSearch( aOptions, "DSPCHANGING", "" ) + " " + cDisk + ":" )
        fDefUnit( nDisk )
        If ! File( cDisk + ":\NUL" )
          WinWrite( IniSearch( aOptions, "DSPUNITNOT", "" ) )
          Eval( bBlock )
          Return( lExit )
        EndIf
      EndIf
      cAux := IniSearch( aOptions, "DSPDISKSIZE", "" )
      cAux := StrTran( cAux, "<Size>", AllTrim( TransForm( DiskSize() / 1024, "9,999,999" ) ) )
      cAux := StrTran( cAux, "<Free>", AllTrim( TransForm( DiskFree() / 1024, "9,999,999" ) ) )
      WinWrite( cAux )
      If ( DiskFree() / 1024 ) < Val( IniSearch( aOptions, "REQUIREKB", "0" ) )
        cAux := IniSearch( aOptions, "DSPNOTSPACE", "" )
        cAux := StrTran( cAux, "<KB>", AllTrim( TransForm( Val( IniSearch( aOptions, "REQUIREKB", "0" ) ), "9,999,999" ) ) )
        WinWrite( cAux )
        Eval( bBlock )
        Return( lExit )
      EndIf
      DirChange( "\" )
      aPath := aCar2Arr( cPath, "\" )
      If ! DirExist( cPath )
        WinWrite( IniSearch( aOptions, "DSPNOTEXIST", "" ) )
        For nInd := 1 To Len( aPath )
          DirCreate( aPath[ nInd ] )
          DirChange( aPath[ nInd ] )
        Next
      Else
        WinWrite( IniSearch( aOptions, "DSPCHANGING", "" ) + " " + cPath )
        For nInd := 1 To Len( aPath )
          DirChange( aPath[ nInd ] )
        Next
      EndIf
      lBandera := .T.
      While lBandera
        If ! GetDiskPath( @cZIPUnit, IniSearch( aOptions, "INQUIRECOMPR", "" ) )
          WinWrite( IniSearch( aOptions, "DSPCANCELUSER", "" ) )
          Eval( bBlock )
          Return( lExit )
        EndIf
        cFile1 := cZIPUnit + AllTrim( IniSearch( aOptions, "COMPRESSOR",   "" ) )
        cFile2 := cPath    + AllTrim( IniSearch( aOptions, "COMPRESSOR",   "" ) )
        If File( cFile1 )
          WinWrite( IniSearch( aOptions, "DSPCOPYING", "" ) )
          lBandera := .F.
          __copyfile( cFile1, cFile2 )
        Else
          WinWrite( StrTran( IniSearch( aOptions, "DSPFILENOT", "" ), "<F>", cFile1 ) )
        EndIf
      EndDo
      For nDiscos := 1 To Val( IniSearch( aOptions, "NUMBEROFDISKS", "1" ) )
        DirChange( "\" )
        For nInd := 1 To Len( aPath )
          DirChange( aPath[ nInd ] )
        Next
        lBandera := .T.
        While lBandera
          If ! GetDiskPath( @cOrgUnit, IniSearch( aOptions, "DISKNAME" + AllTrim( Str( nDiscos ) ), "" ) )
            WinWrite( IniSearch( aOptions, "DSPCANCELUSER", "" ) )
            Eval( bBlock )
            Return( lExit )
          EndIf
          cFile1 := cOrgUnit + AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) )
          cFile2 := cPath    + AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) )
          If File( cFile1 )
            WinWrite( IniSearch( aOptions, "DSPCOPYING", "" ) )
            lBandera := .F.
            __copyfile( cFile1, cFile2 )
          Else
            WinWrite( StrTran( IniSearch( aOptions, "DSPFILENOT", "" ), "<F>", cFile1 ) )
          EndIf
        EndDo
        aComp := ZIPFile( AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) ) )
        For nInd := 1 To Len( aComp )
          aComp[ nInd, 2 ] := StrTran( aComp[ nInd, 2 ], "/", "\" )
          cMask := IniSearch( aOptions, "DSPDECOMPRESS", "" )
          cMask := StrTran( cMask, "<F>",        aComp[ nInd, 2 ] )
          cMask := StrTran( cMask, "<CompSize>", AllTrim( Str( aComp[ nInd, 6 ] ) ) )
          cMask := StrTran( cMask, "<RealSize>", AllTrim( Str( aComp[ nInd, 5 ] ) ) )
          WinWrite( cMask )
          run ( AllTrim( IniSearch( aOptions, "COMPRESSOR", "PKUNZIP" ) ) + ;
                " -d " + ;
                AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) ) + ;
                " " + aComp[ nInd, 2 ] + " > NUL" )
        Next
        fErase( cPath + AllTrim( IniSearch( aOptions, "DISKFILE" + AllTrim( Str( nDiscos ) ), "" ) ) )
      Next
      fErase( cPath + AllTrim( IniSearch( aOptions, "COMPRESSOR",   "" ) ) )
      lExit := .T.
    EndIf
    fDefUnit( nOld )
    RestScreen( 14, 4, 27, 75, cScreen )
Return( lExit )



static function WinWrite( cMsg )
Local cColor := SetColor( "B/W" )
    Scroll( 15, 5, 26, 74, 1, 0 )
    @ 26, 5 SAY PadR( cMsg, 70 )
    SetColor( cColor )
Return( Nil )



static function MsgInit()
Local cScreen := SaveScreen( 8, 6, 20, 74 )
Local cColor  := SetColor( "N/BG" )
Local nCursor := SetCursor( 0 )
Local aBtn
Local lFlag
Local nKey
Local cOption  := IniSearch( aOptions, "BTNCONTINUE", "Continue" )
    gtWinBox( 8, 6, 20, 74, "N/BG", "Welcome to FAST.* Software" )
    @ 11, 9 SAY PadC( "Installation Program FAST.IP V1.00", 63 )
    @ 13, 9 SAY PadC( "This is a 100% Clipper software developed by Manu Roibal", 63 )
    @ 15, 9 SAY PadC( "FAST.IP uses FAST.* Software Technology as FAST.lib and FAST.GT", 63 )
    @ 17, 9 SAY PadC( "(C) 1992-94 Manu Roibal. All rights reserved", 63 )
    aBtn := DrawButtom( 19, 39 - 5, cOption, .T. )
    lFlag := .T.
    While lFlag
      nKey := Inkey( 0 )
      If nKey == K_MOUSE_LEFT
        If BtnMouse( aBtn )
          PushButtom( aBtn )
          lFlag  := .F.
        EndIf
      ElseIf UPPER( CHR( nKey ) ) == SubStr( cOption, 1, 1 )
        PushButtom( aBtn )
        lFlag  := .F.
      EndIf
    EndDo
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 8, 6, 20, 74, cScreen )
Return( Nil )



static function GetDiskPath( cPath, cMessage )
Local nLen
Local cScreen
Local cColor   := SetColor( "N/W" )
Local cOption1 := IniSearch( aOptions, "BTNOK",     "Yes" )
Local cOption2 := IniSearch( aOptions, "BTNCANCEL", "No"  )
Local nAux
Local lRet
Local aBtn1
Local aBtn2
Local nCursor  := SetCursor( 1 )
Local bKey
Local GetList  := {}
    cMessage := PadR( cMessage, 64 )
    nLen     := Int( Len( cMessage ) / 2 )
    cScreen  := SaveScreen( 10, 38 - nLen, 17, 41 + nLen )
    nAux     := Max( Len( cOption1 ), Len( cOption2 ) )
    cOption1 := PadR( cOption1, nAux )
    cOption2 := PadR( cOption2, nAux )
    gtWinBox( 10, 38 - nLen, 17, 41 + nLen, "W+/W", IniSearch( aOptions, "QUERYWINTIT", "" ) )
    aBtn1 := DrawButtom( 16, 40 - 11, cOption1, .T. )
    aBtn2 := DrawButtom( 16, 40 +  5, cOption2, .T. )
    BoxDraw( 14, 40 - nLen )
    cPath := PadR( cPath, 64 )
    bKey  := SetKey( K_MOUSE_LEFT, { || MouseFunc( aBtn1, aBtn2 ) } )
    @ 12, 40 - nLen SAY cMessage
    @ 14, 40 - nLen GET cPath COLOR "GR+/B"
    READ
    cPath := AllTrim( StrTran( AllTrim( cPath ) + "\", "\\", "\" ) )
    lRet := ( LastKey() != K_ESC )
    SetKey( K_MOUSE_LEFT, bKey )
    SetCursor( nCursor )
    SetColor( cColor )
    RestScreen( 10, 38 - nLen, 17, 41 + nLen, cScreen )
Return( lRet )



static function BoxDraw( nY, nX1 )
Local nX2    := nX1 + 64
Local nInd
Local lMouse := MouseCursor( MOUSE_OFF )
    nY  := nY  * 16 - 4
    nX1 := nX1 *  8 - 3
    nX2 := nX2 *  8 + 3
    For nInd := nY To nY + 20
      VesaLine( nInd, nX1, nInd, nX2, 1 )
    Next
    VesaLine( nY + 20, nX1, nY + 20, nX2,  0 )
    VesaLine( nY,      nX1, nY,      nX2, 15 )
    VesaLine( nY,      nX2, nY + 20, nX2, 15 )
    VesaLine( nY,      nX1, nY + 20, nX1,  0 )
    MouseCursor( lMouse )
Return( Nil )



function MouseFunc( aBtn1, aBtn2 )
    If BtnMouse( aBtn1 )
      PushButtom( aBtn1 )
      KEYBOARD CHR( K_RETURN )
    ElseIf BtnMouse( aBtn2 )
      PushButtom( aBtn2 )
      KEYBOARD CHR( K_ESC )
    EndIf
Return( NIL )



EXIT PROCEDURE MyExit()
    gtClose( gtHandle )
RETURN
