/*Ŀ
 ݳ Program Name: DEMO.PRG          Copyright: Gallagher Computing       
 ݳ     Language: Clipper 5.0            Cost: FreeWare                  
 ݳ       Author: Kevin S Gallagher                                      
 Ĵ
 ݳ Notes:                                                               
 ݳ This demo utility uses Dr.Switch-ASE library to create a Clipper TSR 
 ݳ that show ASE routines in FiveO syntax rather than xBASE as in the   
 ݳ samples provided with the ASE library. I use GRUMPFISH library for   
 ݳ several routines. If you do not own GRUMPFISH, try the other demo i  
 ݳ included which only needs NANFOR.LIB (less features).                
 ݳ                                                                      
 ݳ For those of you who are familar with my "Clipper Commander" i have  
 ݳ created a TSR version of it with ASE, and have figured out how to    
 ݳ have it terminate in a new drive\directory, rather than the startup  
 ݳ location (refer to ASE manual).                                      
 Ĵ
 ݳ About the author: Clipper FiveO programmer looking to get out of     
 ݳ contract jobs and into a full time position programming or teaching  
 ݳ Clipper.                                                             
 ݳ CIS: 70034,2313 or Voice (215)947-3504                               
 
   */

#include "ase.h"

static sHotKey, cTextFile

#define HELP_UM         // enable simple help

#define DBF_VIEWER aUtils_[1]
#define ALL_VIEWER aUtils_[2]
#define TSR_EDITOR aUtils_[3]
#define WATCH_PORT aUtils_[4]

function main
    local option  := 0
    local cScrn   := ""
    local cDbfName:= ""
    local aUtils_

    sHotKey := "{ALT}{F10}"

    // get information from configuration diskfile
    aUtils_ := GetTsrDict()

    DrPhone( WATCH_PORT, .T. )

    IsOnLine()
    LoadExe()

    // hotkey for card game -- also press ALT-C for a calculator
    setkey(K_ALT_B, {|| bj() } )

    while .t.
        //
        // APICK is from grumpfish library, and if you do not have it
        // try using nanforum's A_CHOICE() to emulate APICK.
        //
        APICK option ARRAY AOPTS_ TITLE ACTIVE_MODE
        if option == EXIT_OPTION
            if !dractive()
                exit
            endif
        endif

        do case
            case option == 1
                //
                // attempt to execute external database viewer
                //
                ShellToDos( DBF_VIEWER )
            case option == 2
                //
                // Pop on down to DOS or to a suspended application
                //
                LoadExe()
            case option == 3
                //
                // copy text from under the TSR
                //
                SnapShot()
            case option == 4
                SetGrabFile()
            case option == 5
                //
                // attempt to execute external file manager
                //
                ShellToDos( ALL_VIEWER )
            case option == 6
                //
                // attempt to edit clipboard (meaning is it under 64k)
                //
                EditClipBoard()
            case option == 7
                //
                // This option displays a ruler for various uses. Press
                // the spacebar for extended info (dec/hex values) Use
                // function key F1 for simple help
                //
                xhair()
            case option == 8
                //
                // Bring up your programmers editor (Bried/Qedit/MultiEdit)
                // One idea is to popup on a application in developmental
                // stages to make changes and notes in the source code files
                // w/o the need to terminate the program, and have to 
                // remember were you where doing the time you need to make
                // notes or changes.
                //
                ShellToDos( TSR_EDITOR )
        endcase
    enddo
    waiton("Unloaded Successfully...",.f.,"w+/n",3,0)
return nil

*****************************************************************************
* Standard routines *
*****************************************************************************
/*
*    Author: Kevin S Gallagher
*          :
* Procedure: IsOnLine()
*          :
*   Purpose: Checks to see if we are active already or not
*          :
* Arguments: Void
*          :
*  Comments: Void
*          : 
*/
procedure IsOnLine()
    local nHow
    if isactive()
        //
        // Only allow the TSR to be loaded once and no more!
        //
        ?"Already active with "+sHotKey+"   "
        quit
    endif

    /*
    *
    * Still playing with this.
    *
    * nHow := hotkey()
    * 
    * if nHow == 255
    *     alert(" ;Phone call triggered me up; Time of popup;"+ time() )
    * elseif nHow == 254
    *     alert("Timer triggered me")
    * elseif nHow == 254
    *     alert("Timer triggered me")
    * endif
    */
return

/*
*   Routine: LoadExe()
*          :
*   Purpose: Main routine for going resident
*          :
* Arguments: Void
*          :
*  Comments: Once loaded a info box is shown with the hotkey
*          : used to active the utility. Seealso: misc.prg for
*          : the function KeyProper(), which is used to convert 
*          : the ASE hot-key to a format suitable for displaying
*          : it on the screen.
*/
static procedure LoadExe()
    local nErr
    local nRow := row()
    local nCol := col()

    if DrActive()
        //
        // We are already loaded!
        //
        DrSwap()
    else
        //
        // Not loaded yet, so do it now!
        //
        setkey( K_ALT_F10,{ || LoadExe() } )
        dispbox(1,0,12,33,B_DOUBLE + " ","w+/b")
        @ 2, 4 say " Clipper SideKick utility "  color "w+/b"
        @ 2,13 say "S"                           color "rb+/b"
        @ 2,17 say "K"                           color "rb+/b"
        @ 3, 4 say ""  color "w+/b"
        @ 5, 4 say " Gallagher Computing Inc. "  color "w+/b"
        @ 6, 4 say "   Tel. (215) 947-3504    "  color "w+/b"
        @ 7, 4 say ""  color "w+/b"
        @ 8, 4 say "       Version 1.00a      "  color "w+/b"
        @ 9, 4 say ""  color "w+/b"
        @10, 4 say "      Default Hot Key     "  color "gr+/b"
        @11, 4 say padc(KeyProper(sHotKey),26)   color "r+/b"

        //
        // Some computers will lose the hardware cursor, or have it appear
        // like C>- 
        // which we fix by doing ------------+
        //                                   |
        //                                   |
        //                                   V
        // BLINKER EXECUTABLE CLIPPER E:0;CGACURS
        //
        // which remedies the cursor problem, but now Clipper is lost to
        // cursor position after displaying the above screen, so i tell
        // Clipper were we should be by issuing the two functions below.
        // Once this is done, Clipper is back in the saddle again!
        //
        // Try commenting out CGACURS, and the next two line to see if 
        // you need them, or live with it
        //
        setcursor(1)
        setpos(15,0)
        
        if ( nErr := DrLoad("","C:\",640,sHotKey,.T.,.T.,.T.) ) <> 0
            //
            // See error codes in ASE manual. I have never had a problem
            // loading. I have tested this with limited memory under 
            // MS-DOS 3.3, and on systems with MS-DOS 5.nn with mucho RAM.
            //
            ?"Unable to load program"
            ?"Error code " + ltrim( str(nErr) )
            quit
        endif
    endif
return

/*
*   Routine: ShellToDos()
*          :
*   Purpose: Allows access to command prompt or
*          : external program.
*          :
* Arguments: Void
*          :
*  Comments: If this was just for me, i'd remove error-checking
*          : for checking if program to execute was in the PATH
*          :
*/
static procedure ShellToDos( cCommand )
    local cScrn, xx

    cScrn := savescreen(0,0,maxrow(),maxcol())
    //
    // Review DO CASE statement in the main menu for what cCommand is!
    //
    if valtype(cCommand) == "C"
        //
        // psychopath() is a call from grump.lib that looks for
        // a file in the OS PATH. 
        //
        if !empty( psychopath( cCommand ) )
            drshell( cCommand )
        else
            err_msg("Could not find "+ cCommand)
        endif
    else
        DrShell()
    endif
    restscreen(0,0,maxrow(),maxcol(),cScrn)
return

*****************************************************************************
* ClipBoard routines *
*****************************************************************************
/*
*   Routine: SnapShot()
*          :
*   Purpose: Used to capture screens while resident
*          :
* Arguments: Void
*          :
*  Comments: This is used in place of ASE's own cut routine
*          : when using ASENOVID library, which disables the
*          : (auto) saving/restoring of screens.
*          :
*/
function SnapShot()
    local nCursor := setcursor(3)
    local nHandle := 0
    local nRow    := row()
    local nCol    := col()
    local cString
    local cBuff

    //
    // CutNPaste is from Grumpfish library, and i do not remember if it
    // is actually documented otherthan in the source code for Greg's
    // NotePad routine that copies text from under the notepad. If you
    // do not own grumpfish then you can purchase grump.lib, code your
    // own routine, or simply do a copy of the entire screen as in my
    // nanforum demo. BTW CutNPaste uses a tad bit of assembly code to
    // show what is intended to be copied.
    //

    if !empty( cString := CutNPaste(@cBuff) )
        if empty(cTextFile)
            SetGrabFile()
        endif
    else
        setpos(nRow,nCol)
        return nil
    endif
    setcursor(0)
    if !file(cTextFile)
        if ( nHandle := fcreate( cTextFile, FC_NORMAL) ) == F_ERROR
            alert("Error creating file;'" + cTextFile + "'")
        endif
    else
        if ( nHandle := fopen(cTextFile,FO_READWRITE+FO_SHARED)) == F_ERROR
            alert("Error opening file;'" + cTextFile + "'")
        endif
        fseek(nHandle,FS_SET,FS_END)
    endif

    fwrite(nHandle,cString)

    if !fclose(nHandle)
        alert("Error closing file;'" + cTextFile + "'")
    endif
    setpos(nRow,nCol)
    setcursor(nCursor)
return nil

/*
*   Routine: SetGrabFile()
*          :
*   Purpose: Sets the globle name for cut/pasting
*          :
* Arguments: Void
*          :
*  Comments: Rather than having a hard coded filename
*          : it is better to be able to change the name
*          : for different operations.
*          :
*          : C:\DRCLIP.BRD
*/
procedure SetGrabFile()
    cTextFile := if( empty(cTextFile),                              ;
                     padr("C:\DRCLIP.BRD",50), padr(cTextFile,50)   ;
    )

    //
    // boxget is a UDC that displays a get in a box
    //
    boxget cTextFile prompt "Enter filename:"                       ;
        boxcolor "w+/rb" color "w/n" picture "@K"                   ;
    title "File for Cut/Paste operations"

    cTextFile := if( empty(cTextFile),"C:\DRCLIP.BRD",              ;
                     upper(alltrim(cTextFile))                      ;
    )

    //
    // If we do not imform the ASE library, then ASE will use
    // C:\DRCLIP.BRD no matter what we change the name to.
    //
    AFFIX(cTextFile,"{ALT}{INS}")
return

/*
*    Author: Kevin S Gallagher
*          :
*  Function: EditClipBoard()
*          :
*   Purpose: Edit/View diskfile for cut/paste operations
*          :
* Arguments: Void
*          :
*  Comments: Uses a modified version of MEMEDIT(), but the
*          : unmodified version works fine.
*/
procedure EditClipBoard()
    local cString, nCursor := setcursor(1)
    local nRow := row()
    local nCol := col()
    local bSaveKey := setkey( K_ALT_F10, NIL )
    local nHandle

    if empty(cTextFile)
        SetGrabFile()
    endif
    if !file(cTextFile)
        if (nHandle := fcreate(cTextFile)) > 4
            fclose(nHandle)
        endif
    endif
    //
    // PE() is a modified version of the one that is in your Clipper
    // sample directory. It remembers your row/column position until
    // you terminate the TSR.
    //
    PE(cTextFile)
    setcursor(nCursor)
    setpos(nRow,nCol)
    setkey(K_ALT_F10, bSaveKey)
return

*****************************************************************************
* Misc. routines *
*****************************************************************************


#ifdef HELP_UM
#include "shadowb.ch"                                             
procedure help
    local xx
    local cColor := setcolor("w+/rb")

    shadowbox buffer xx                                             ;
        top 5 left 11 bottom 13 right 68                            ;
        title "HELP"                                                ;
        footer "Press any key to leave help"                        ;
    color 'w/rb'

    @ 6,13 say "All options are in the main menu except that you can"
    @ 7,13 say "use Grump calculator by pressing ALT-C, and to play a"
    @ 8,13 say "game of BlackJack, press its hotkey ALT-B."
    @ 9,13 say "Note: Whenever there is a title above the main menu"
    @10,13 say "it means that you are popup over another program and"
    @11,13 say "can not terminate this TSR. Use [return to program]"
    @12,13 say "then quit it, and then popup again and terminate."

    // Do not want any wait states for setkey!
    inkey(0)

    byebyebox(xx)                                                     
    setcolor(cColor)
return
#endif

#define K_ALTC   302
//
// No ESC with ALT-C, but popup a calculator instead
// If we were to alt-c without using QUIT, then any memory
// the ASE library was using is lost until you reboot the
// system that was running the Clipper TSR. If you are using
// a version of Clipper Five prior to 5.2, then make 
// INIT Procedure  -- INIT Function and return Nil
//
init procedure StartIt
    set(_SET_WRAP,.T.)
    setcancel(.f.)
    set scoreboard off
    //
    // Invoke GRUMPFISH calculator when ALT-C is depressed
    //
    SET KEY K_ALTC TO popcalc()
return

