   // Function HiliteLine( oBrowse, aColors)
   //
   // Syntax
   //    HiliteLine( <oBrowse>, [aColors]) -> NIL
   //
   // Arguments
   //    <oBrowse> is a TBrowse object.
   //
   //    [aColors] is an array of two numbers. The numbers are used as indexes
   //    into the color table for the browse. For more information see description
   //    of :colorRect( ) in your favorite book on Clipper 5.xx.
   //
   // Returns
   //    NIL
   //
   // Description
   //    Directly alters the color of the data row where the browse cursor is
   //    currently located.
   //
   // Examples
   //
   //    This example will hilite the current line only after full
   //    stabilization.
   //
   //      Function incStablize(oBr)
   //
   //         While !oBr:stabilize()
   //            If NextKey() # 0
   //               Return NIL
   //            EndIf
   //         End
   //
   //      // oBr:forceStable( )
   //
   //         HiliteLine( oBr, {2, 2})
   //
   //      Return( NIL)
   //
   // Author: Alexander Avilov
   //
   // Notes
   //    I created this function to replace
   //
   //          object:colorRect({object:rowPos, 1, object:rowPos,;
   //                            object:colCount}, { x, y})
   //    in my tbrowse, but ... ( see IMPORTANT NOTES!!!!!!! below)
   //
   //    If you have questions you can find me at CompuServe.
   //    75103,2032
   //
   // Have fun                               06-27-94 03:39pm



   // IMPORTANT NOTES!!!!!!!
   // I am tired tiping this code and decide to stop checking everithing
   // This code will work fine ONLY with TBrowse that has one line per header
   // and header separator, like this one
   // Ŀ
   //  Header1   Header2   Header3 ........ 
   // Ĵ
   //  xxxxxxx  xxxxxxx  xxxxxxx ........ 
   //  xxxxxxx  xxxxxxx  xxxxxxx ........ 
   //  xxxxxxx  xxxxxxx  xxxxxxx ........ 
   //                                       
   //
   // You are FREE to change any line of this function and use it whenever you
   // want. And BTW I can't guarantee you anything. You are using this
   // function on your own risk.
   //
   // If you want to have universal function you probably should check if
   // tbrowse has !Empty( :headSep) and if it's empty you probably will check
   // colSep for each column, and after that it will be good idea to find
   // number of data rows in each header ( count ";" in column:heading) and
   // it could be good idea to store this info in static variable and check
   // if function works with the same TBrowse. Somewhat like this
   //
   // Static oObj := WhateverButConstant
   // if oObj == oBrowse
   //    use saved info
   // else
   //    oObj := oBrowse
   //    calculate everything again
   // endIf
   //
   // also you can change this function a little to have full replacement
   // of :colorRect( ). Also you probably would want deHiliteLine( ) and .....
   // So many possible ways to modify this function, you have to stop somewhere.
   //
   // Have more fun.
   //
   // Sanya.                  06-27-94 02:47pm
   //
   // BTW I'll appreciate if you send me modified copy of this function.
   //
   // P.S. If you live in DC area and like this function and good beer,
   //      we can arrange smth. ( No bud lite please)


Static Function HiliteLine( oBrowse, aColor)

   Local nTop := oBrowse:nTop + oBrowse:rowPos +1
   Local nLeft := oBrowse:nLeft
   Local nBott := oBrowse:nTop + oBrowse:rowPos +1
   Local nRight := oBrowse:nRight

   Local nTmp
   Local cColor
   Local aTmp := {}

   oBrowse:autoLite := .F.
   cColor := AllTrim( oBrowse:colorSpec)
   nTmp   := At(  ",", cColor)

   While ( .T.)
      If ( (nTmp := At(  ",", cColor)) > 0)
         aAdd( aTmp, Trim( Substr( cColor, 1, nTmp-1)))
         cColor := lTrim( SubStr( cColor, ++nTmp))
      Else
         If ( Len( allTrim( cColor)) > 0)
            aAdd( aTmp, Alltrim( Substr( cColor, 1, nTmp-1)))
         Endif
         Exit
      EndIf
   End

   If ( Len( aTmp) < 2)
      aAdd( aTmp, "n/w")                        // Standard TBrowse behavior
   Endif

   If ( ValType( aColor) == "A")
      If ( Len( aColor) == 1)
         aAdd( aColor, 2)
      EndIf
   Else
      aColor := { 1, 2}
   Endif

   If ( aColor[1] > Len( aTmp))                 // Standard TBrowse behavior
      aColor[1] := 1
   EndIf

   If ( aColor[2] > Len( aTmp))                 // Standard TBrowse behavior
      aColor[1] := 2
   EndIf


   RestScreen(nTop, nLeft, nBott, nRight,;
   Transform(SaveScreen(nTop, nLeft, nBott, nRight),;
   Replicate("X"+ColorToChr( aTmp[aColor[1]]), nRight - nLeft + 1 ) ) )

   If ( aColor[1] <> aColor[2])
      nLeft := Col()
      nRight := nLeft + oBrowse:colWidth( oBrowse:colPos)-1

      RestScreen(nTop, nLeft, nBott, nRight,;
      Transform(SaveScreen(nTop, nLeft, nBott, nRight),;
      Replicate("X"+ColorToChr( aTmp[aColor[2]]), nRight - nLeft + 1 ) ) )
   Endif

Return( NIL)


Static Function ColorToChr( cColor)
   Local nTmp := At( "/", cColor)
   Local cRetVal

   If ( nTmp == 0)
      If ( allTrim( Len( cColor)))
         cRetVal := Chr( 7)
      Else
         cRetVal := Chr( GetNumColor( allTrim( SubStr( cColor, 1))))
      Endif
   Else
      cRetVal := Chr( GetNumColor( allTrim( SubStr( cColor, 1, nTmp-1))) +;
                      GetNumColor( allTrim( SubStr( cColor, nTmp+1)))*16)
   Endif

Return( cRetVal)


Static Function GetNumColor( cColor)
   Local nRetVal := 0


   cColor := Lower( cColor)

   If (     cColor = "bg")                      // I use "=" intentionally
      nRetVal := 3                              // see below
   ElseIf ( cColor = "rb")
      nRetVal := 5
   ElseIf ( cColor = "gr")
      nRetVal := 6
   ElseIf ( cColor = "n")
      nRetVal := 0
   ElseIf ( cColor = "b")
      nRetVal := 1
   ElseIf ( cColor = "g")
      nRetVal := 2
   ElseIf ( cColor = "r")
      nRetVal := 4
   ElseIf ( cColor = "w")
      nRetVal := 7
   Endif


   If ( "+" $ cColor .OR. "*" $ cColor)
      nRetVal += 8
   Endif

Return( nRetVal)



