#include "inkey.ch"

/*Ŀ
  Function Browser()                                                       
  Purpose  Example browse                                                  
  */
FUNCTION Browser(nTop, nLeft, nBottom, nRight)

   LOCAL oBrowse, aArray, nElement := 1, oColumn, nKey, oWindow
   LOCAL cScreen

   oWindow := Window():New(nTop, nLeft,  nBottom - nTop-3, nRight-nLeft-1, "Tbrowse Window"):Display()

   aArray := {{"Press",     "Alt-D",   "here"},;
              {"and",       "then",    "in"},;
              {"MrDebug",   "press",   "Alt-L"},;
              {"to",        "toggle",  "local"},;
              {"variables", "on.",     "Then"},;
              {"press",     "Alt-3",   "to"},;
              {"get",       "to",      "the"},;
              {"Variable",  "window.", "Select"},;
              {"the",       "oBrowse", "variable,"},;
              {"to",        "see",     "it's"},;
              {"contents.", "",        ""}}

   oBrowse := tBrowseNew(nTop+3, nLeft+2, nBottom-1, nRight-2)

   oBrowse:ColorSpec := "W+/N,N/W,N/B,G/B,R/B,RB/B,GR/B,W/B,N+/B,B+/B,G+/B,BG+/B,RB+/B,GR+/B"

   oBrowse:SkipBlock     := {|nToMove| ArraySkip(nToMove, @nElement, aArray) }
   oBrowse:GoTopBlock    := {|| nElement := 1 }
   oBrowse:GoBottomBlock := {|| nElement := Len(aArray) }

   oColumn := tbColumnNew("One",   {|| aArray[nElement][1] })
   oColumn:ColorBlock := {|| ColourFunc(nElement, 1) }
   oColumn:Width := 10
   oBrowse:AddColumn(oColumn)

   oColumn := tbColumnNew("Two",   {|| aArray[nElement][2] })
   oColumn:ColorBlock := {|| ColourFunc(nElement, 2) }
   oColumn:Width := 10
   oBrowse:AddColumn(oColumn)

   oColumn := tbColumnNew("Three",   {|| aArray[nElement][3] })
   oColumn:ColorBlock := {|| ColourFunc(nElement, 3) }
   oColumn:Width := 10
   oBrowse:AddColumn(oColumn)

   DO WHILE .T.
      oBrowse:ForceStable()

      nKey := Inkey(0)

      DO CASE
         CASE nKey == K_UP
            oBrowse:Up()

         CASE nKey == K_DOWN
            oBrowse:Down()

         CASE nKey == K_LEFT
            oBrowse:Left()

         CASE nKey == K_RIGHT
            oBrowse:Right()

         CASE nKey == K_HOME
            oBrowse:Home()

         CASE nKey == K_END
            oBrowse:End()

         CASE nKey == K_PGUP
            oBrowse:PageUp()

         CASE nKey == K_PGDN
            oBrowse:PageDown()

         CASE nKey == K_CTRL_PGUP
            oBrowse:GoTop()

         CASE nKey == K_CTRL_PGDN
            oBrowse:GoBottom()

         CASE nKey == K_ESC
            EXIT

      ENDCASE
   ENDDO

   oWindow:Close()

RETURN (NIL)

/*Ŀ
  Function ColourFunc                                                      
  Purpose  Guess at which colour would look really nasty here              
  */
STATIC FUNCTION ColourFunc(nElement, nColumn)
RETURN ({nElement * nColumn % 12 + 3, 2})

/*Ŀ
  Function ArraySkip()                                                     
  Purpose  Array skipper for example browse                                
  */
FUNCTION ArraySkip(nToMove, nElement, aArray)

   LOCAL nLen

   IF nToMove < 0
      IF nElement + nToMove < 1
         nToMove := -(nElement - 1)
         nElement := 1
      ELSE
         nElement += nToMove
      ENDIF
   ELSE
      nLen := Len(aArray)

      IF nElement + nToMove > nLen
         nToMove := nLen - nElement
         nElement := nLen
      ELSE
         nElement += nToMove
      ENDIF
   ENDIF

RETURN (nToMove)
