#include "d:\gui\gui.h"
#include "workshop.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>

//*********************************************************************
//		PROTOTYPES
//*********************************************************************

void initialize();
void SetupToolBox();
void design();
void deinitialize();
void showmem();
void redraw_screen();
int check_toolbox();
int check_panels();
int panel_hit();
int panel_sizerhit();
int check_bevels();
int bevel_hit();
int bevel_sizerhit();
int check_checkboxes();
int checkbox_hit();
int check_radios();
int radio_hit();
int check_icons();
int icon_hit();
int check_strings();
int string_hit();
int check_buttons();
int button_hit();
int check_lines();
int line_hit();
int check_texts();
int text_hit();

//ACTIONS.CPP
extern void set_screen_color();
extern void place_panel();
extern void place_bevel();
extern void place_checkbox();
extern void place_radio();
extern void place_icon();
extern void place_string();
extern void place_button();
extern void place_line();
extern void place_text();

//MODIFY.CPP
extern int modify_panel(panelrec *);
extern modify_bevel(bevelrec *);
extern modify_checkbox(checkboxrec *);
extern modify_radio(radiorec *);
extern modify_icon(iconrec *);
extern modify_string(stringrec *);
extern modify_button(buttonrec *);
extern modify_text(textrec *);

//FILEIO.CPP
extern save_all_info();
extern read_new_info();
extern clear_all_info(int);

//*********************************************************************
//		GLOBAL VARIABLES
//*********************************************************************

panelrec *panelroot=(panelrec *)NULL;
panelrec *currentpanel=(panelrec *)NULL;
int numpanels=0;

bevelrec *bevelroot=(bevelrec *)NULL;
bevelrec *currentbevel=(bevelrec *)NULL;
int numbevels=0;

checkboxrec *checkboxroot=(checkboxrec *)NULL;
checkboxrec *currentcheckbox=(checkboxrec *)NULL;
int numcheckboxes=0;

radiorec *radioroot=NULL;
radiorec *currentradio=NULL;
int numradios=0;

iconrec *iconroot=NULL;
iconrec *currenticon=NULL;
int numicons=0;

stringrec *stringroot=NULL;
stringrec *currentstring=NULL;
int numstrings=0;

buttonrec *buttonroot=NULL;
buttonrec *currentbutton=NULL;
int numbuttons=0;

Line line_info[100];
int numlines=0;

textrec *textroot=NULL;
textrec *currenttext=NULL;
int numtexts=0;

int done=0;

Screen screen;
extern Mcursor the_mouse;
Buttonbox toolbox;
int screencolor=0;
int mem_indicator=1;
int pos_indicator=1;
int toolbox_indicator=1;
int mem_turned_on=1;
int pos_turned_on=1;
int toolbox_turned_on=1;
int ready_to_place=0;
int mouse_forced=0;

//*********************************************************************
//		MAIN
//*********************************************************************

void main()
{
	clrscr();
	initialize();
	SetupToolBox();
	the_mouse.arm();
	design();
	deinitialize();
}

//*********************************************************************
//		INITIALIZE
//*********************************************************************

void initialize()
{
	screen.VGA_480_16();
	if(!the_mouse.init()) {
		closegraph();
		puts("This program requires a mouse!");
		exit(0);
		}
}

//*********************************************************************
//		DEINITIALIZE
//*********************************************************************

void deinitialize()
{
	closegraph();
}

//*********************************************************************
//		SETUPTOOLBOX
//*********************************************************************

void SetupToolBox()
{
	toolbox.init(10,10,14);
	toolbox.setbutton(0,"lines");
	toolbox.setbutton(1,"button");
	toolbox.setbutton(2,"panel");
	toolbox.setbutton(3,"bevel");
	toolbox.setbutton(4,"icon");
	toolbox.setbutton(5,"gstring");
	toolbox.setbutton(6,"radio");
	toolbox.setbutton(7,"check");
	toolbox.setbutton(8,"fromdisk");
	toolbox.setbutton(9,"todisk");
	toolbox.setbutton(10,"screen");
	toolbox.setbutton(11,"text");
	toolbox.setbutton(12,"poof");
	toolbox.setbutton(13,"exit");

	toolbox.show();
}

//*********************************************************************
//		DESIGN
//*********************************************************************

void design()
{
	int mx,my,deltax,deltay;
	char ch;
	int i;

	while(!done) {//1
		showmem();

//*****   CHECK FOR MOUSE POSITION AND CURRENT SHAPE   *****
		if((panel_sizerhit() || bevel_sizerhit() || line_hit()) &&
		   (!toolbox.moverhit() && !toolbox.hit())) {
			the_mouse.changeto(POINT);
			mouse_forced=1;
			}
		else
		if((panel_hit() || bevel_hit() || checkbox_hit() ||
			radio_hit() || icon_hit() || string_hit() || button_hit()
						|| text_hit())
			&& (!toolbox.moverhit() && !toolbox.hit())) {
			the_mouse.changeto(HAND);
			mouse_forced=1;
			}
		else
			mouse_forced=0;

		if(!mouse_forced) {
			if(toolbox.moverhit())
				the_mouse.changeto(FINGER);
			else
				the_mouse.changeto(ARROW);
			}


//*****   CHECK FOR RIGHT MOUSE BUTTON  (REDRAW SCREEN)
		if(the_mouse.RBP()) {
			redraw_screen();
			while(the_mouse.RBP());
			continue;
			}

//*****   CHECK FOR ALT KEY COMBINATIONS   *****

		if(kbhit()) {//2
			if(altkey()) {//3
				ch=getch();
				ch=getch();
				switch(ch) {//4
					case ALTM:	if(mem_indicator)mem_indicator=0;
								else {//5
									mem_indicator=1;
									mem_turned_on=1;
									}//5
								if(mem_indicator==0) {//5
									setfillstyle(SOLID_FILL,screencolor);
									bar(0,getmaxy()-10,100,getmaxy());
									}//5
								continue;
					case ALTT:	if(toolbox_indicator)toolbox_indicator=0;
								else {
									toolbox_indicator=1;
									toolbox_turned_on=0;
									}
								if(toolbox_indicator==0)
									toolbox.hide();
								else
									toolbox.show();
								continue;
					}//4
				}//3
			flushkeys();
			}//2		END ALT KEY COMBINATION CHECK

//*****   CHECK THE GRAPHIC OBJECTS   *****

		check_toolbox();
		check_texts();
		check_lines();
		check_buttons();
		check_strings();
		check_icons();
		check_radios();
		check_checkboxes();
		check_panels();
		check_bevels();

	}//1		END WHILE NOT DONE
}

//*********************************************************************
//		SHOWMEM
//*********************************************************************

void showmem()
{
	static long memwas;
	long mem;

	if(!mem_indicator)
		return;
	mem=farcoreleft();
	if(mem!=memwas || mem_turned_on) {
		setfillstyle(SOLID_FILL,0);
		bar(0,getmaxy()-10,70,getmaxy());
		setcolor(15);
		settextjustify(LEFT_TEXT,TOP_TEXT);
		settextstyle(0,0,1);
		gprintxy(5,getmaxy()-8,"%ld",mem);
		memwas=mem;
		mem_turned_on=0;
		}
}

//*********************************************************************
//		REDRAW_SCREEN
//*********************************************************************

void redraw_screen()
{
	int i;

	if(toolbox.isshown())
		toolbox.hide();

	screen.fill(screencolor);

	currentbevel=bevelroot;
	while(currentbevel!=(bevelrec *)NULL) {
		if(currentbevel->bevel!=(Bevel *)NULL)
			currentbevel->bevel->show();
		currentbevel=currentbevel->next;
		}

	currentpanel=panelroot;
	while(currentpanel!=(panelrec *)NULL) {
		if(currentpanel->panel!=(Panel *)NULL)
			currentpanel->panel->show();
		currentpanel=currentpanel->next;
		}

	currentcheckbox=checkboxroot;
	while(currentcheckbox!=(checkboxrec *)NULL) {
		if(currentcheckbox->checkbox!=(Gcheckbox *)NULL)
			currentcheckbox->checkbox->show();
		currentcheckbox=currentcheckbox->next;
		}

	currentradio=radioroot;
	while(currentradio!=(radiorec *)NULL) {
		if(currentradio->radio!=(Gradio *)NULL)
			currentradio->radio->show();
		currentradio=currentradio->next;
		}

	currenticon=iconroot;
	while(currenticon!=(iconrec *)NULL) {
		if(currenticon->icon!=(Icon *)NULL)
			currenticon->icon->show();
		currenticon=currenticon->next;
		}

	currentstring=stringroot;
	while(currentstring!=(stringrec *)NULL) {
		if(currentstring->string!=(Gstring *)NULL)
			currentstring->string->show();
		currentstring=currentstring->next;
		}

	currentbutton=buttonroot;
	while(currentbutton!=NULL) {
		if(currentbutton->button!=NULL)
			currentbutton->button->show();
		currentbutton=currentbutton->next;
		}

	currenttext=textroot;
	while(currenttext!=NULL) {
		if(currenttext->text!=NULL)
			currenttext->text->show();
		currenttext=currenttext->next;
		}

	for(i=0;i<numlines;i++)
		line_info[i].show();

	if(toolbox_indicator)
		toolbox.show();
	mem_turned_on=1;
	showmem();
}

//*********************************************************************
//		CHECK_TOOLBOX
//*********************************************************************

int check_toolbox()
{
	int mx,my,deltax,deltay;
	int i;

	if(!toolbox_indicator)
		return 0;
		if(toolbox.moverhit()) {//2
			if(the_mouse.LBP()) {//3
				mx=the_mouse.mx();
				my=the_mouse.my();
				toolbox.hide();
				toolbox.outline(15);
				while(the_mouse.LBP()) {//4
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//5
						deltax=mx-toolbox.Getx();
						deltay=my-toolbox.Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						toolbox.move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//5
					}//4
				toolbox.outline(15);
				toolbox.show();
				}//3
			return 1;
			}//2

		//CHECK TOOLBOX BUTTONS
		if(the_mouse.LBP()) {//3
			for(i=0;i<toolbox.buttoncount();i++) {//3
				mx=the_mouse.mx();
				my=the_mouse.my();
				if(toolbox.buttonhit(i)) {//4
					toolbox.buttonpress(i);
					while(the_mouse.LBP() && toolbox.buttonhit(i));
					toolbox.buttonshow(i);
					if(toolbox.buttonhit(i)) {//5
						switch(i) {//6
							case TODISK:save_all_info();
										while(the_mouse.LBP());
										return 1;
							case FROMDISK:read_new_info();
										while(the_mouse.LBP());
										return 1;
							case BEVEL:	place_bevel();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case PANEL: place_panel();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case CHECK: place_checkbox();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case RADIO: place_radio();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case GSTRING:place_string();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case GTEXT:	place_text();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case ICON:	place_icon();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case BUTTON:place_button();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case LINES:	if(numlines<100)
											place_line();
										the_mouse.changeto(ARROW);
										while(the_mouse.LBP());
										return 1;
							case SCREEN:set_screen_color();
										return 1;
							case POOF:	clear_all_info(TRUE);
										while(the_mouse.LBP());
										return 1;
							case EXIT:	done=1;
										return 1;
							}//6
					}//5
				}//4
			}//3
//		continue;
		}//2		END TOOLBOX CHECK
	return 0;
}

//*********************************************************************
//		CHECK_PANELS
//*********************************************************************

int check_panels()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_checkboxes())
		return 1;

	if(panelroot==(panelrec *)NULL)
		return 0;
	currentpanel=panelroot;
	//Find last panel
	while(currentpanel->next!=(panelrec *)NULL)
		currentpanel=currentpanel->next;
	//Work backwards through panels to see if any have been hit
	while(currentpanel!=(panelrec *)NULL) {
		if(currentpanel->panel->hit() || currentpanel->panel->sizerhit()) {
			if(the_mouse.LBP()) {
			if(shiftkey()) {
				modify_panel(currentpanel);
				return 1;
				}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentpanel->panel->hide();
				currentpanel->panel->outline(15);
				if(currentpanel->panel->sizerhit()) {
					while(the_mouse.LBP()) {//6
						if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//7
							if(altkey())
								the_mouse.position(mx,the_mouse.my());
							if(ctrlkey())
								the_mouse.position(the_mouse.mx(),my);
							mx=the_mouse.mx();
							my=the_mouse.my();
							currentpanel->panel->resize((mx-currentpanel->panel->Getx()),
													   (my-currentpanel->panel->Gety()),
														SAVEBGD);
							mx=the_mouse.mx();
							my=the_mouse.my();
							}//7
						}//6
					}//5
				else {
					while(the_mouse.LBP()) {//6
						if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//7
							if(altkey())
								the_mouse.position(mx,the_mouse.my());
							if(ctrlkey())
								the_mouse.position(the_mouse.mx(),my);
							deltax=mx-currentpanel->panel->Getx();
							deltay=my-currentpanel->panel->Gety();
							mx=the_mouse.mx();
							my=the_mouse.my();
							currentpanel->panel->move(mx-deltax,my-deltay);
							mx=the_mouse.mx();
							my=the_mouse.my();
							}//7
						}//6
					}//5
				currentpanel->panel->outline(15);
				currentpanel->panel->show();
				return 1;
				}//4
			}
			currentpanel=currentpanel->previous;
			}//3
	return 0;
}

//*********************************************************************
//		PANEL_HIT
//*********************************************************************

int panel_hit()
{
	int i;

	if(panelroot==(panelrec *)NULL)
		return 0;
	currentpanel=panelroot;
	while(currentpanel!=NULL) {
		if(currentpanel->panel->hit())
			return 1;
		currentpanel=currentpanel->next;
		}
	return 0;
}

//*********************************************************************
//		PANEL_SIZERHIT
//*********************************************************************

int panel_sizerhit()
{
	int i;

	if(panelroot==(panelrec *)NULL)
		return 0;
	currentpanel=panelroot;
	while(currentpanel!=(panelrec *)NULL) {
		if(currentpanel->panel->sizerhit())
			return 1;
		currentpanel=currentpanel->next;
		}
	return 0;
}

//*********************************************************************
//		CHECK_BEVELS
//*********************************************************************

int check_bevels()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_panels())
		return 1;

	if(bevelroot==(bevelrec *)NULL)
		return 0;
	currentbevel=bevelroot;
	//Find last bevel
	while(currentbevel->next!=(bevelrec *)NULL)
		currentbevel=currentbevel->next;
	//Work backwards through bevels to see if any have been hit
	while(currentbevel!=(bevelrec *)NULL) {
		if(currentbevel->bevel->hit() || currentbevel->bevel->sizerhit()) {
			if(the_mouse.LBP()) {
			if(shiftkey()) {
				modify_bevel(currentbevel);
				return 1;
				}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentbevel->bevel->hide();
				currentbevel->bevel->outline(15);
				if(currentbevel->bevel->sizerhit()) {
					while(the_mouse.LBP()) {//6
						if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//7
							if(altkey())
								the_mouse.position(mx,the_mouse.my());
							if(ctrlkey())
								the_mouse.position(the_mouse.mx(),my);
							mx=the_mouse.mx();
							my=the_mouse.my();
							currentbevel->bevel->resize((mx-currentbevel->bevel->Getx()),
													   (my-currentbevel->bevel->Gety()),
														SAVEBGD);
							mx=the_mouse.mx();
							my=the_mouse.my();
							}//7
						}//6
					}//5
				else {
					while(the_mouse.LBP()) {//6
						if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//7
							if(altkey())
								the_mouse.position(mx,the_mouse.my());
							if(ctrlkey())
								the_mouse.position(the_mouse.mx(),my);
							deltax=mx-currentbevel->bevel->Getx();
							deltay=my-currentbevel->bevel->Gety();
							mx=the_mouse.mx();
							my=the_mouse.my();
							currentbevel->bevel->move(mx-deltax,my-deltay);
							mx=the_mouse.mx();
							my=the_mouse.my();
							}//7
						}//6
					}//5
				currentbevel->bevel->outline(15);
				currentbevel->bevel->show();
				return 1;
				}//4
			}
			currentbevel=currentbevel->previous;
			}//3
	return 0;
}

//*********************************************************************
//		BEVEL_HIT
//*********************************************************************

int bevel_hit()
{
	int i;

	if(bevelroot==(bevelrec *)NULL)
		return 0;
	currentbevel=bevelroot;
	while(currentbevel!=NULL) {
		if(currentbevel->bevel->hit())
			return 1;
		currentbevel=currentbevel->next;
		}
	return 0;
}

//*********************************************************************
//		BEVEL_SIZERHIT
//*********************************************************************

int bevel_sizerhit()
{
	int i;

	if(bevelroot==(bevelrec *)NULL)
		return 0;
	currentbevel=bevelroot;
	while(currentbevel!=(bevelrec *)NULL) {
		if(currentbevel->bevel->sizerhit())
			return 1;
		currentbevel=currentbevel->next;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_CHECKBOXES
//*********************************************************************

int check_checkboxes()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_radios())
		return 1;

	if(checkboxroot==(checkboxrec *)NULL)
		return 0;
	currentcheckbox=checkboxroot;
	//find the last in list
	while(currentcheckbox->next!=NULL)
		currentcheckbox=currentcheckbox->next;
	//search backwards through list;
	while(currentcheckbox!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currentcheckbox->checkbox->hit()) {//4
				if(shiftkey()) {
					modify_checkbox(currentcheckbox);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentcheckbox->checkbox->hide();
				currentcheckbox->checkbox->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currentcheckbox->checkbox->Getx();
						deltay=my-currentcheckbox->checkbox->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currentcheckbox->checkbox->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currentcheckbox->checkbox->outline(15);
				currentcheckbox->checkbox->show();
				return 1;
				}//4
			}//3
		currentcheckbox=currentcheckbox->previous;
		}//2
	return 0;
}

//*********************************************************************
//		CHECKBOX_HIT
//*********************************************************************

int checkbox_hit()
{
	if(checkboxroot==NULL)
		return 0;
	currentcheckbox=checkboxroot;
	while(currentcheckbox!=NULL) {
		if(currentcheckbox->checkbox->hit())
			return 1;
		currentcheckbox=currentcheckbox->next;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_RADIOS
//*********************************************************************

int check_radios()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_icons())
		return 1;
	if(radioroot==NULL)
		return 0;
	currentradio=radioroot;
	while(currentradio!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currentradio->radio->hit()) {//4
				if(shiftkey()) {
					modify_radio(currentradio);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentradio->radio->hide();
				currentradio->radio->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currentradio->radio->Getx();
						deltay=my-currentradio->radio->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currentradio->radio->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currentradio->radio->outline(15);
				currentradio->radio->show();
				return 1;
				}//4
			}//3
		currentradio=currentradio->next;
		}//2
	return 0;
}

//*********************************************************************
//		RADIO_HIT
//*********************************************************************

int radio_hit()
{
	if(radioroot==NULL)
		return 0;
	currentradio=radioroot;
	while(currentradio!=NULL) {
		if(currentradio->radio->hit())
			return 1;
		currentradio=currentradio->next;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_ICONS
//*********************************************************************

int check_icons()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_strings())
		return 1;
	if(iconroot==NULL)
		return 0;
	currenticon=iconroot;
	while(currenticon!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currenticon->icon->hit()) {//4
				if(shiftkey()) {
					modify_icon(currenticon);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currenticon->icon->hide();
				currenticon->icon->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currenticon->icon->Getx();
						deltay=my-currenticon->icon->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currenticon->icon->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currenticon->icon->outline(15);
				currenticon->icon->show();
				return 1;
				}//4
			}//3
		currenticon=currenticon->next;
		}//2
	return 0;
}

//*********************************************************************
//		ICON_HIT
//*********************************************************************

int icon_hit()
{
	if(iconroot==NULL)
		return 0;
	currenticon=iconroot;
	while(currenticon!=NULL) {
		if(currenticon->icon->hit())
			return 1;
		currenticon=currenticon->next;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_STRINGS
//*********************************************************************

int check_strings()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_buttons())
		return 1;
	if(stringroot==NULL)
		return 0;
	currentstring=stringroot;
	while(currentstring!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currentstring->string->hit()) {//4
				if(shiftkey()) {
					modify_string(currentstring);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentstring->string->hide();
				currentstring->string->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currentstring->string->Getx();
						deltay=my-currentstring->string->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currentstring->string->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currentstring->string->outline(15);
				currentstring->string->show();
				return 1;
				}//4
			}//3
		currentstring=currentstring->next;
		}//2
	return 0;
}

//*********************************************************************
//		STRING_HIT
//*********************************************************************

int string_hit()
{
	if(stringroot==NULL)
		return 0;
	currentstring=stringroot;
	while(currentstring!=NULL) {
		if(currentstring->string->hit())
			return 1;
		currentstring=currentstring->next;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_BUTTONS
//*********************************************************************

int check_buttons()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_lines())
		return 1;
	if(buttonroot==NULL)
		return 0;
	currentbutton=buttonroot;
	while(currentbutton!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currentbutton->button->hit()) {//4
				if(shiftkey()) {
					modify_button(currentbutton);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currentbutton->button->hide();
				currentbutton->button->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currentbutton->button->Getx();
						deltay=my-currentbutton->button->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currentbutton->button->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currentbutton->button->outline(15);
				currentbutton->button->show();
				return 1;
				}//4
			}//3
		currentbutton=currentbutton->next;
		}//2
	return 0;
}

//*********************************************************************
//		BUTTON_HIT
//*********************************************************************

int button_hit()
{
	if(buttonroot==NULL)
		return 0;
	currentbutton=buttonroot;
	while(currentbutton!=NULL) {
		if(currentbutton->button->hit())
			return 1;
		currentbutton=currentbutton->next;
		}
	return 0;
}

//*********************************************************************
//		CHECK_LINES
//*********************************************************************

int check_lines()
{
	int i;
	int mx,my,lastx,lasty;

	if(check_texts())
		return 1;
	for(i=0;i<numlines;i++) {
		if(the_mouse.LBP()) {
			if(line_info[i].starthit() || line_info[i].endhit()) {
				if(line_info[i].starthit())
					line_info[i].swap_ends();
				the_mouse.position(line_info[i].Getx2(),line_info[i].Gety2());
				mx=lastx=the_mouse.mx();
				my=lastx=the_mouse.my();
				setcolor(15);
				setlinestyle(1,0,line_info[i].Getstyle());
				setwritemode(XOR_PUT);
				the_mouse.hide();
				line(line_info[i].Getx(),line_info[i].Gety(),line_info[i].Getx2(),
					 line_info[i].Gety2());
				the_mouse.show();
				while(the_mouse.LBP()) {
					if(the_mouse.mx()!=mx || the_mouse.my()!=my) {
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						lastx=the_mouse.mx();
						lasty=the_mouse.my();
						the_mouse.hide();
						line(line_info[i].Getx(),line_info[i].Gety(),mx,my);
						line(line_info[i].Getx(),line_info[i].Gety(),
							 lastx,lasty);
						mx=lastx=the_mouse.mx();
						my=lastx=the_mouse.my();
						the_mouse.show();
						}
					}
				setwritemode(COPY_PUT);
				line_info[i].new_end(mx,my);
				redraw_screen();
				return 1;
				}
			}
		}
	return 0;
}


//*********************************************************************
//		LINE_HIT
//*********************************************************************

int line_hit()
{
	int i;

	for(i=0;i<numlines;i++) {
		if((line_info[i].starthit()) || (line_info[i].endhit()))
		   return 1;
		}
	return 0;
}

//*********************************************************************
//		   CHECK_TEXTS
//*********************************************************************

int check_texts()
{
	int mx,my,deltax,deltay;
	int i;

	if(check_toolbox())
		return 1;
	if(textroot==NULL)
		return 0;
	currenttext=textroot;
	while(currenttext!=NULL) {
		if(the_mouse.LBP()) {//3
			if(currenttext->text->hit()) {//4
				if(shiftkey()) {
					modify_text(currenttext);
					return 1;
					}
				mx=the_mouse.mx();
				my=the_mouse.my();
				currenttext->text->hide();
				currenttext->text->outline(15);
				while(the_mouse.LBP()) {//5
					if(mx!=the_mouse.mx() || my!=the_mouse.my()) {//6
						if(altkey())
							the_mouse.position(mx,the_mouse.my());
						if(ctrlkey())
							the_mouse.position(the_mouse.mx(),my);
						deltax=mx-currenttext->text->Getx();
						deltay=my-currenttext->text->Gety();
						mx=the_mouse.mx();
						my=the_mouse.my();
						currenttext->text->move(mx-deltax,my-deltay);
						mx=the_mouse.mx();
						my=the_mouse.my();
						}//6
					}//5
				currenttext->text->outline(15);
				currenttext->text->show();
				return 1;
				}//4
			}//3
		currenttext=currenttext->next;
		}//2
	return 0;
}

//*********************************************************************
//		TEXT_HIT
//*********************************************************************

int text_hit()
{
	if(textroot==NULL)
		return 0;
	currenttext=textroot;
	while(currenttext!=NULL) {
		if(currenttext->text->hit())
			return 1;
		currenttext=currenttext->next;
		}
	return 0;
}
