;
;                          MEMBLOCK Memory Core Left
;
; Borland C++ 4.0 for WIN32 prototype:
; DWORD __pascal mbcoreleft (MEMBLOCK *mb);
;
; Returns: OK   - Largest free memory block (can be 0)
;          Fail - NULL
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBCORELEFT


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 0                ; -> MEMBLOCK

MBCORELEFT:     push ebx
pct = (4)+(1*4)
                ;-- Load MEMBLOCK info
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [eax+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  edx, [eax+MEMBLOCK.size]
                add  edx, ebx                   ; -> end of MEMBLOCK + 1

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  CL_CorruptMB
                add  ebx, MBSigSize             ; -> first node
EndIf
                ;-- Set greatest MemArea
                xor  ecx, ecx

;---------------

CL_SearchLoop:
; ebx -> MemNode to check
; ecx - Largest MemArea (so far)
; edx -> final byte of MEMBLOCK + 1

                ;-- Get node data
                mov  eax, [ebx+MemNode.size]

If DebugMode    ;-- Check Node Integrity
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  CL_CorruptMB
                xor  eax, NodeSigKey
EndIf
                ;-- Node Free?
                test eax, 80000000h
                jnz  CL_NextNode

                ;-- Size found > largest so far?
                cmp  ecx, eax
                ja   CL_NextNode
                mov  ecx, eax                   ; Store >

CL_NextNode:    ;-- Point to next MemNode
                and  eax, 7fffffffh
                add  ebx, size MemNode
                add  ebx, eax

                cmp  ebx, edx
                jb   CL_SearchLoop
                ja   CL_CorruptMB

;---------------

CL_Exit:
; ecx - Largest MemArea
                mov  eax, ecx
                pop  ebx
                ret  4                          ; 1 arg

;---------------

CL_CorruptMB:   xor  ecx, ecx                   ; return null on error
                jmp  short CL_Exit


;
EndS            _TEXT
End
