;
;                             MEMBLOCK Free Memory
;
;
; Borland C++ 4.0 for WIN32 prototype:
; void  __pascal mbfree (MEMBLOCK *mb, PTR ptr);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBFREE


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 4                ; -> MEMBLOCK
arg2 = 0                ; -> Mem Area

MBFREE:         push ebx esi edi ebp
pct = (4)+(4*4)         ; # bytes pushed on stack after last argument

                ;-- Get ptr to MemNode (NULL PTR?)
                mov  edx, [esp+pct+arg2]        ; -> Mem Area
                or   edx, edx
                jz   FR_Exit                    ; Null ptr?
                sub  edx, size MemNode          ; -> MemNode

                ;-- Load MEMBLOCK info
                mov  esi, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [esi+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  ebp, [esi+MEMBLOCK.size]   ; size of memblock
                add  ebp, ebx                   ; -> final byte + 1

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  FR_Exit                    ; Invalid MBSig?
                add  ebx, MBSigSize             ; -> first node
EndIf

                ;-- nullify ptr to previous MemNode
                xor  edi, edi

;---------------

FR_FindNode:
; ebx -> current MemNode
; edx -> MemNode to free
; edi -> previous MemNode
; ebp -> final byte of MEMBLOCK + 1

If DebugMode    ;-- Is current MemNode valid?
                mov  eax, [ebx+MemNode.size]
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  FR_CorruptMB               ; invalid MemNode?
EndIf

                ;-- Is MemNode the one to free?
                cmp  edx, ebx
                je   FR_FoundNodeToFree

                ;-- Update previous MemNode ptr
                mov  edi, ebx                   ; -> previous node

                ;-- Point to next node
                mov  eax, [ebx+MemNode.size]
                and  eax, 7fffffffh             ; kill 'used' flag
                add  ebx, size MemNode          ; skip MemNode
                add  ebx, eax                   ; skip mem area

                ;-- Any more nodes to check?
                cmp  ebx, ebp
                jb   FR_FindNode
                ja   FR_CorruptMB
                jmp  short FR_Exit


;---------------

FR_FoundNodeToFree:
; ebx -> node to free
; edi -> previous node (null = no last node)
; ebp -> final byte of MEMBLOCK + 1

                ;-- MemNode already free?
                mov  eax, [ebx+MemNode.size]
                test eax, 80000000h
                jz   FR_Exit

                ;-- Mark node as free
                and  eax, 7fffffffh
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf

                ;-- Is next node free?
                add  eax, size MemNode
                add  eax, ebx                   ; -> next MemNode
                cmp  eax, ebp
                ja   FR_CorruptMB
                je   FR_NextNotFree
                mov  ecx, [eax+MemNode.size]
                test ecx, 80000000h
                jnz  FR_NextNotFree

                ;-- Join next node and freed node
                mov  [eax+MemNode.size], 0      ; destroy next node
                mov  eax, [ebx+MemNode.size]    ; newly freed node's size
                                                ; high bit is 0
                add  eax, size MemNode          ; next node size
                add  eax, ecx                   ; mem area of next node
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
EndIf

FR_NextNotFree:
; ebx -> freed node
; edi -> previous node (null = no last node)

                ;-- Last MemNode NULL?
                or   edi, edi
                jz   FR_Exit

                ;-- Is last node free?
                mov  eax, [edi+MemNode.size]
                test eax, 80000000h
                jnz  FR_Exit

                ;-- Join last node and freed node
                add  eax, size MemNode          ; size of freed node
                add  eax, [ebx+MemNode.size]    ; high bit is 0
                mov  [ebx+MemNode.size], 0      ; destroy freed node
                mov  [edi+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [edi+MemNode.sig], eax
EndIf

;---------------

FR_Exit:        pop  ebp edi esi ebx
                ret  8                          ; 2 args

;---------------

FR_CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ebx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ebx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  [dword ebx], MBSigInvl
EndIf
                jmp  short FR_Exit


;
EndS            _TEXT
End
