/*

    SCROLLER.PRG   (Demo of scrolling GETs)    Steve Kolterman: 76320,37
    =====================================================================

    Compile:   clipper scroller /n/w/m
               clipper getsyssk /n/w/m

    Link:      rtlink/blinker fi scroller,getsyssk

*/

#include "inkey.ch"
#include "getexit.ch"
#include "setcurs.ch"

#define ORDPOS   cargo[1]
#define GE_JUMP  10

function test
local getlist:= {},nX
local aArr[300]
local cScrn

Setcolor( "+w/b" ) ; Scroll()
cScrn:= SaveScreen(0,0,maxrow(),maxcol())
Setkey( K_F10,{|| GetActive():exitstate:= GE_DOWN} )
Setkey( K_F9,{|| GetActive():exitstate:= GE_UP} )

for nX:= 0 TO 299

    aArr[nX+1]:= nX+1
    @ nX,20 get aArr[nX+1] send reader:= {|g| scrollget(g,getlist,cScrn)} ;
                           send cargo:= {nX+1}

next

readmodal( getlist,15 )

return nil

proc scrollget( oGet,getlist,cScrn )
local nkey

   // Read the GET if the WHEN condition is satisfied
   IF ( GetPreValidate( oGet ) )

      // Activate the GET for reading
      oGet:setFocus()

      WHILE ( oGet:exitState == GE_NOEXIT )

         // Check for initial typeout (no editable positions)
         IF ( oGet:typeOut )
            oGet:exitState := GE_ENTER
         ENDIF

         // Apply keystrokes until exit
         WHILE ( oGet:exitState == GE_NOEXIT )

            SetCursor( IIF(ReadInsert(),SC_INSERT,SC_NORMAL) )
            nKey:= Inkey(0)
            SetCursor(SC_NONE)

            IF nKey==K_UP .or. nKey==K_DOWN .or. ;
               nKey==K_PGUP .or. nKey==K_PGDN .or. ;
               nKey==K_CTRL_PGUP .or. nKey==K_CTRL_PGDN

               doScroll( oGet, getlist, nKey, cScrn )

            ELSE

               GetApplyKey( oGet, nKey )

            ENDIF

         ENDDO

         // Disallow exit if the VALID condition is not satisfied
         IF ( !GetPostValidate( oGet ) )
            oGet:exitState := GE_NOEXIT
         ENDIF
      ENDDO

      // De-activate the GET
      oGet:killFocus()

   ENDIF

   RETURN


function doScroll( oGet,getlist,nKey,cScrn )
local nInc,nPos,nLenGets,lOk

nPos:= oGet:ORDPOS
nLenGets:= Len(getlist)

DO CASE
CASE nKey==K_UP
   lOk:= (nPos > 1)
   nInc:= IIF( nPos==1,0,1 )
   nPos--
CASE nKey==K_DOWN
   lOk:= (nPos < nLenGets)
   nInc:= IIF( nPos==nLenGets,0, -1)
   nPos++
CASE nKey==K_PGUP
   nInc:= MIN( maxrow(),oGet:ORDPOS-1 )
   lOk:=  (nPos > 1)
   nPos-= maxrow()
CASE nKey==K_PGDN
   nInc:= -(MIN( maxrow(),nLenGets-oGet:ORDPOS ))
   lOk:=  (nPos < nLenGets)
   nPos+= maxrow()
CASE nKey==K_CTRL_PGUP
   nInc:= oGet:ORDPOS-1
   lOk:= (nPos > 1)
   nPos:= 1
CASE nKey==K_CTRL_PGDN
   nInc:= -(MIN( nLenGets,nLenGets-oGet:ORDPOS ))
   lOk:=  (nPos < nLenGets)
   nPos:= nLenGets
ENDCASE

IF nPos < 1 .or. nPos > nLenGets
   nPos:= IIF( nPos < 1,1,nLenGets )
ENDIF

IF lOk
   DispBegin()
   RestScreen(0,0,maxrow(),maxcol(),cScrn)
   Aeval( getlist,{|g| g:row+= nInc, g:display()} )
   Dispend()
   oGet:exitstate:= GE_JUMP
   ReadPos( nPos )
ENDIF

RETURN NIL
