// FREE function with the code.
//
// Allows scrolling dbf field(s) in the get variable(s). Also allows to
// associate several get variables with the prime one to scroll them together.
//
// Syntax
// @ <row>, <col> GET <var>                                                ;
//                         ...                                             ;
//                         SCROLL <cxFieldName>                            ;
//                         [IN <cxAlias>]                                  ;
//                         [ORDERED [BY] <cxOrder>]                        ;
//                         ...                                             ;
//
// Arguments
//         SCROLL <cxFieldName> specifies the field name in the dbf file, 
//                 that will be scrolled in the get variable.
//         IN     <cxAlias> specifies the name of the database file where
//                <cxFieldName> is. (default - current work area)
//         ORDERED [BY] <cxOrder> defines the order name that will be used 
//                 for scrolling (default - current order, if any)
//
//
// Syntax
// @ <row>, <col> GET <var>                                               ;
//                        ...                                             ;
//                        REFRESH [FROM] <cxFieldName>                     ;
//                        [IN <cxAlias>]                                   ;
//                        [WITH <cxScrollField>]                           ;
//                        ...                                             ;
//
// Arguments
//         REFRESH [FROM] <cxFieldName> associates the get variable with the 
//                         database field in <cxAlias>. This field willd be scrolled
//                         together with <cxScrollField> if it defined, or with
//                         all variables that have SCROLL clause in the @ GET 
//                         command.
//         IN      <cxAlias> specifies the name of the database file where
//                 <cxFieldName> is. (default - current work area)
//         WITH <cxScrollField> defines the SCROLL variable with witch this
//              get variable will be scrolled. If ommited this get variable
//              will be scrolled with all get variables that have SCROLL 
//              clause in the @ GET command. 
//
//
// Author: Alexander Avilov
// Created: 09/17/92				Last Modification: 07/18/94
//
// Questions? You can find me at 75103,2032
//
// You can use this function free of charge. It's FREE. Also I can't garantee
// you anything. So you are going to use this function on you own risk.
//
// NOTE!!!! I assume that you do NOT use :cargo
// If you do use :cargo, you have the code that you can modify at any time and
// in any way.
//
// enjoy.
//
// Sanya



#include "GetExit.ch"
#include "inkey.ch"


#define DO_REFRESH               // if DO_REFRESH is defined you can scroll in
                                 // several fields that defined with
                                 // REFRESH FROM .. WITH. If you want to scroll
                                 // only one field comment this #define.


#define DEC_KEY 1
#define INC_KEY 2

#define FIELD  oGet:cargo[1]
#define ALIAS  oGet:cargo[2]
#define ORDER  oGet:cargo[3]

Static lIndexed   := .F.         // You have a choice: to use or not to use
                                 // the dbSeek. It hard to make decission. I know.
                                 // Maybe the following will help you.
                                 //
                                 // If you use dbSeek (Set SEEK ON)
                                 // the position in the database is preserved
                                 // and before READ and after is the same
                                 // (if you do NOT change the current record
                                 // in you own valid clause). This feature is
                                 // good if you do want to stay on the same place
                                 // in the database all the time (ex. you have
                                 // Set Key ... Func() and this function
                                 // depends on current position in dbfdbSeek)
                                 // Notes: the field that you want to scrool
                                 // should be indexed and it's very desirable
                                 // that this index is unique. ( if you have
                                 // two or more keys with the same value in
                                 // the dbf file this program will never scroll
                                 // thru it. see code )
                                 //
                                 // In case of Set SEEK OFF, current position
                                 // in cAlias is changed every time you press
                                 // scroll keys.
                                 // Pluses - it's faster.
                                 // And you are still able to keep current
                                 // record unchanged after READ.
                                 // ex.
                                 // nRecNo := RecNo()
                                 // @ .. Get..
                                 // ...
                                 // READ
                                 // dbGoTo( nRecNo)
                                 //
                                 // BTW if you have Set Key ... Func() and
                                 // this function depends on current
                                 // position in dbf you still can use it
                                 // with only one change in it
                                 // Set Key ... To Func( ..., nRecNo).
                                 // Function( ..., nRecNo)
                                 //    Local noldRecNo := RecNo()
                                 //    dbGoto( nRecNo)
                                 //    ......
                                 //    ......
                                 //    dbGoTo( noldRecNo)
                                 // Return( ...)


#command SET SEEK <x: ON> => lIndexed := <.x.>



// ALERT!!!!!!
// READ NOTES before you use it
#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        SCROLL <cFieldName>                             ;
                        [IN <cAlias>]                                   ;
                        [ORDERED [BY] <cOrder>]                              ;
                        [<moreClauses,...>]                             ;
                                                                        ;
         => @ <row>, <col> GET <var>                                    ;
                        [<clauses>]                                     ;
                        SEND reader := {| oGet|                         ;
                                            GetMyReader( oGet, getList)};
                        SEND cargo  := If( !Empty( #<cFieldName>),      ;
                                          { <(cFieldName)>, <(cAlias)>, ;
                                             <(cOrder)>},               ;
                                          NIL)                          ;
                                          [<moreClauses>]

#ifdef DO_REFRESH

// ALERT!!!!!!
// READ NOTES before you use it
#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        REFRESH [FROM] <cFieldName>                     ;
                        [IN <cAlias>]                                   ;
                        [WITH <cScrollField>]                           ;
                        [<moreClauses,...>]                             ;
                                                                        ;
         => @ <row>, <col> GET <var>                                    ;
                        [<clauses>]                                     ;
                        SEND cargo  := If( !Empty( #<cFieldName>) .AND. ;
                                     fieldPos( <(cFieldName)>) > 0,     ;
                                     {<(cScrollField)>,                 ;
                                      If( !Empty( #<cAlias>),           ;
                                          fieldWblock( <(cFieldName)>,  ;
                                              Select( <(cAlias)>)),     ;
                                          fieldblock( <(cFieldName)>)   ;
                                        )                               ;
                                     }, NIL)                            ;
                        [<moreClauses>]

#endif

// You can define scroll key using setScrollKey() function.
// Syntax 
//      SetScrollKey( <nUpDown>, [<nKeyCode>]) -> nOldKeyCode
//
//          nUpDown - 1 defines the key to decrement
//                    2 --//--          to increment
//
//          nKeyCode is a key code to assign to the <nUpDown>.
//          Defaults are "-" and "+"

#define K_DEC  setScrollKey( 1)
#define K_INC  setScrollKey( 2)
