// dda.cpp : implementation file
//

#include "stdafx.h"
#include "dda.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDDA

CDDA::CDDA(int iFirst, int iLast, int iSteps)
{

    ASSERT(iSteps > 1);

    m_iFirst = iFirst;
    m_iLast = iLast;
    m_iSteps = iSteps;

    // Set the current point to be the first value
    m_iCurrent = iFirst;

    // The basic increment is (iLast - iFirst) / (iSteps - 1)
    // since the end points are included. 
    // The delta is positive if iLast > iFirst and negative if not.
    m_iInc   = (m_iLast - m_iFirst) / m_iSteps;

    if (m_iLast - m_iFirst > 0) {
        m_iSub   = m_iLast - m_iFirst - m_iSteps *  m_iInc;
        m_iDelta = 1;
    } else {
        m_iSub   = m_iFirst - m_iLast + m_iSteps *  m_iInc;
        m_iDelta = -1;
    }
     m_iErr =  m_iAdd = m_iSteps;

}

CDDA::~CDDA()
{
}

