/*
 * File......: SETBOX.PRG
 * Author....: Berend M. Tober
 * CIS ID....: 70541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     SETBOX
 *  $CATEGORY$
 *     Menus and windows
 *  $ONELINER$
 *     Command to compute coordinates for centered box or window.
 *  $SYNTAX$
 *     SETBOX <nHigh> BY <nWide>) TO <nTop>, <nLeft>, <nBottom>, <nRight>
 *  $ARGUMENTS$
 *    <nHigh> - Height of box in screen rows.
 *    <nWide> - Width of box in screen columns.
 *  $RETURNS$
 *     Screen coordinates defining a centered box.
 *  $DESCRIPTION$
 *     This function is useful if you want to display a menu or message
 *     box centered on the screen and you know the height and width of
 *     the box.  You pass as parameters the height and width, and the
 *     routine works by computing the four corner coordinates of a box
 *     centered and having the specified dimensions.
 *
 *     I use this routine often, because I tend to think about and
 *     understand screen image manipulation in a coordinate system
 *     that uses the upper-left corner and box dimensions, rather
 *     than the CA-Clipper system of using four corner coordinates.
 *  $EXAMPLES$
 *     SETBOX 10 BY 10 TO BOXT, BOXL, BOXB, BOXR
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *     SETBOX.CH
 *  $END$
 */

/*  This is included in here for programmer reference

// File:    SETBOX.CH
// Author:  Berend M. Tober
// Date:    1994/07/01
#ifndef _SETBOX_CH

   #translate IAVG(<v1>,<v2>)    => INT((<v1>+<v2>)/2)

   #xcommand SETBOX <h> BY <w> TO <t>, <l>, <b>, <r> ;
   => <t> := MAX( 0, IAVG(MAXROW(),-<h>));
     ;<l> := MAX( 0, IAVG(MAXCOL(),-<w>));
     ;<b> := MIN( MAXROW(), <t>+<h>-1 );
     ;<r> := MIN( MAXCOL(), <l>+<w>-1 )

   #define _SETBOX_CH

#endif
*/

#ifdef FT_TEST          // Sample program
   #include "setbox.ch"
   #include "box.ch"
   #include "inkey.ch"

   PROCEDURE T_SETBOX()

   LOCAL aHW :=   {;                // Heights and widths for example 1
                  { 01, 01 },;
                  { 02, 02 },;
                  { 02, 05 },;
                  { 02, 07 },;
                  { 02, 10 },;
                  { 05, 10 },;
                  { 07, 10 },;
                  { 10, 10 },;
                  { 20, 10 },;
                  { 20, 30 },;
                  { 20, 50 } ;
                  }
   LOCAL n := LEN( aHW )

   LOCAL aMenu := {;                // Menu selections for example 2
                  "A. First item"  ,;
                  "B. Second item" ,;
                  "C. Third item"  ,;
                  "D. Fourth item" ,;
                  "E. Exit"         ;
                  }

   LOCAL nMenuH, nMenuW := 0        // Dimensions for example 2 TBD
   LOCAL nBoxT, nBoxL, nBoxB, nBoxR

   // Example 1:  Just a bunch of boxes

   DO WHILE n > 0 .AND. LASTKEY() != K_ESC
      DISPBOX( 0, 0, MAXROW(), MAXCOL(), REPLICATE(CHR(177),9),"W/B")
      @ 0, 0 SAY PADC("Demonstration of SETBOX: Example 1", 1+MAXCOL())
      SETBOX aHW[n,1] BY aHW[n,2] TO nBoxT, nBoxL, nBoxB, nBoxR
      FT_SHADOW(nBoxT, nBoxL, nBoxB, nBoxR )
      DISPBOX( nBoxT, nBoxL, nBoxB, nBoxR, B_SINGLE+" ", "N/W")
      @ MAXROW(), 0 SAY PADC( "Hit any key to continue", 1+MAXCOL())
      INKEY(0)
      n--
   ENDDO

   // Example 2 :  ACHOICE menu

   DISPBOX( 0, 0, MAXROW(), MAXCOL(), REPLICATE(CHR(177),9),"W/B")
   @ 0, 0 SAY PADC("Demonstration of SETBOX: Example 2", 1+MAXCOL())

   // Compute height and width of box
   nMenuH := LEN( aMenu )
   AEVAL( aMenu, {|x,i| nMenuW := MAX( LEN( x ), nMenuW ) })


   // Compute corner coordinates of centered box, given dimensions
   SETBOX nMenuH+2 BY nMenuW+2 TO nBoxT, nBoxL, nBoxB, nBoxR

   // Display to screen
   SETCOLOR( "W/B, N/W " )
   FT_SHADOW( nBoxT, nBoxL, nBoxB, nBoxR )
   DISPBOX( nBoxT++, nBoxL++, nBoxB--, nBoxR--, B_SINGLE+" " )
   ACHOICE( nBoxT, nBoxL, nBoxB, nBoxR, aMenu )

   // Clean up
   CLEAR SCREEN
   QUIT
   RETURN
#endif
