/*
** Copyright (C) by Intratek Computing, 1994-1995. All rights reserved.
*/

/*
** FILE: error.c
** PURPOSE: Show how error handling is treated.
**
** Tries to allocate a few strings; reports to stdout.
*/

/*
** Must link with smltools.c
*/

#include <stdio.h>
#include "sml.h"
#include "smltools.h"

int main(void)
{
        char *s;

        s = sml_csize(10);              /* Did you initialize SML?  */
        put_sml_error();

        sml_init();                     /* Vital!                   */
        put_sml_error();                /* pointless                */

        s = sml_csize(0xfffe);          /* Yeah, right; not in DOS! */
        put_sml_error();

        s = sml_csize(0xfffe);          /* Yeah, right; not in DOS! */
        put_sml_error();

        s = sml_csize(0);               /* How large did you say?   */
        put_sml_error();                /* n == 0 will be an error  */

        s = sml_csize(1);               /* Should work, right?      */
        put_sml_error();

        sml_free(s);

        return (0);
}
