/*
** Copyright (C) by Intratek Computing, 1994-1995. All rights reserved.
*/

/*
** FILE: justify.c
** PURPOSE: Show general manner in which to use SML; mainly how strings are
**          used and how the justification functions work.
**
** Takes the strings placed on command-line and justifies them.
*/

#include <stdio.h>
#include "sml.h"

#define  SIZE 60                        /* size of work string         */

int main(int argc, char *argv[])
{
        int  i;
        char *str;

        sml_init();                     /* we want SML to work, right? */

        if ( argc < 2 )                 /* no args given               */
        {
                puts("");
                puts("USAGE: justify \"string 1\", [\"string 2\", \"string 3\"]");
                puts("");

                exit(1);
        }

        str = sml_csize(SIZE);

        for ( i = 1; i < argc; i++ )
        {
                strcpy(str, argv[i]);

                sml_jleft(str, ' ', SIZE);
                puts(str);

                sml_jright(str, ' ', SIZE);
                puts(str);

                sml_jcenter(str, '_', SIZE);
                puts(str);
        }

        sml_free(str);                  /* SML will complain if you don't */
                                        /* free the memory it allocated!  */

        return (0);
}
