/*

  A guy asked me how to have columns 1 and 5 in one color, and the
  columns in between in a different color.  This is how I approached
  the solution.

  -- Steve Woolstenhulme
     73060,1302
*/

#include "inkey.ch"
#include "set.ch"
#include "box.ch"

function tbColo
   // keep track of how things were when we got here.
   local nRow := row()
   local cScrn := savescreen( 0, 0, maxrow(), maxcol() )

   // put environmental issues the way we want them.
   set scoreboard off
   set( _SET_DATEFORMAT, 'mm/dd/yyyy' )
   setcursor( 0 )
   cls
   
   // create some sample data and use the dbf.
   makedata()

   // now browse the data.
   browseIt()
   
   // clean up the whole mess.
   dbcloseall()
   restscreen( 0, 0, maxrow(), maxcol(), cScrn )
   setpos( nRow-1, 0 )
return Nil


static function makedata()
   dbcreate( 'sample', { ;
                       { 'Name', 'C', 30, 0 }, ;
                       { 'Birthday', 'D', 8, 0 } ;
                       } )
   use sample new exclusive 

   sample->( dbAppend() )
   sample->NAME := 'Blatt, Freda'
   sample->BIRTHDAY := ctod( '12/31/1942' )

   sample->( dbAppend() )
   sample->NAME := 'Roberts, Tommy'
   sample->BIRTHDAY := ctod( '07/11/1981' )
   
   sample->( dbAppend() )
   sample->NAME := 'Wilson, Grant'
   sample->BIRTHDAY := ctod( '03/18/1938' )

   sample->( dbAppend() )
   sample->NAME := 'Adams, Jodie'
   sample->BIRTHDAY := ctod( '11/21/1956' )

   sample->( dbAppend() )
   sample->NAME := 'Baker, Charles'
   sample->BIRTHDAY := ctod( '05/01/1973' )
   
   sample->( dbAppend() )
   sample->NAME := 'Carroll, Lewis'
   sample->BIRTHDAY := ctod( '05/14/1942' )

   sample->( dbAppend() )
   sample->NAME := 'Donaldson, Robert'
   sample->BIRTHDAY := ctod( '12/12/1957' )

   sample->( dbAppend() )
   sample->NAME := 'Egert, Reginald'
   sample->BIRTHDAY := ctod( '09/15/1977' )
   
   sample->( dbAppend() )
   sample->NAME := 'Duddleston, Roger'
   sample->BIRTHDAY := ctod( '07/18/1948' )

   sample->( dbGoTop() ) 
return Nil


static function browseIt()
   local nTop := 4
   local nLeft := 4
   local nBottom := maxrow() - 4
   local nRight := maxcol() - 4
   local oBrowse := TBrowseDB( nTop, nLeft, nBottom, nRight )
   local nKey := 0
   
   @ nTop - 1, nLeft - 1, nBottom + 1, nRight + 1 box B_DOUBLE
   //                    1    2     3    4     5     6     7     8
   oBrowse:colorSpec := "W+/RB, N/W, B/W, W+/B, W+/G, W+/BG, R/W, W/R"
   oBrowse:autolite := .f.
   oBrowse:colsep := ''

   // this is data.
   oBrowse:addColumn( TBColumnNew( "Customer Name", ;
              { || sample->NAME } ) )
   
   // we'll add color from above:  4 when highlighted, 7 when not.
   oBrowse:getColumn(1):colorBlock := { || { 4, 7 } }

   // these next three are just separators.  we'll leave them default color.
   oBrowse:addColumn( TBColumnNew( "", ;
              { || ' ' } ) )
   
   oBrowse:addColumn( TBColumnNew( "", ;
              { || '' } ) )
   
   oBrowse:addColumn( TBColumnNew( "", ;
              { || ' ' } ) )

   // this is data.  we'll add different colors if old.
   oBrowse:addColumn( TBColumnNew( "Birthday", ;
              { || sample->BIRTHDAY } ) )

   // we'll add color from above:  4 when highlighted, 7 when not.
   // but for people less than 20 years old, let's use 6 & 8 instead.
   oBrowse:getColumn(5):colorBlock := { |x| iif( date() - x > ( 365 * 20 ), ;
                                  { 4, 7 }, { 6, 8 } ) }

   do while ! lastkey() == K_ESC
      
      oBrowse:refreshCurrent()

      do while ! oBrowse:stable .and. ( nKey := inkey() ) == 0
         // stabilize the browse.
         oBrowse:stabilize()
      enddo
      
      // this is the guy that highlights the columns you specify.
      // in this case, columns 1 and 5.
      myColors( oBrowse, { 1, 5 } )

      if oBrowse:stable
         // wait for a key press.
         nKey := inkey(0)
      endif

      do case
      case nKey == K_DOWN
         oBrowse:down()
         
      case nKey == K_PGDN
         oBrowse:pageDown()
         
      case nKey == K_CTRL_PGDN
         oBrowse:goBottom()
         
      case nKey == K_UP
         oBrowse:up()
         
      case nKey == K_PGUP
         oBrowse:pageUp()
         
      case nKey == K_CTRL_PGUP
         oBrowse:goTop()
         
      case nKey == K_RIGHT
         // let's force 'em onto column #5
         oBrowse:colpos := 5
         
      case nKey == K_LEFT
         // let's force 'em onto column #1
         oBrowse:colpos := 1
         
      case nKey == K_HOME
         oBrowse:home()
         
      case nKey == K_END
         oBrowse:end()
         
      case nKey == K_CTRL_HOME
         oBrowse:panHome()
         
      case nKey == K_CTRL_END
         oBrowse:panEnd()
      
      endcase   
   enddo
return Nil
      

static function myColors( oBrowse, aColColors )
   local i
   local nColPos := oBrowse:colpos

   for i := 1 to len( aColColors )
      oBrowse:colpos := aColColors[i]
      oBrowse:hilite()
   next

   oBrowse:colpos := nColPos
return Nil
