/*****************************************************************************
*       TrueColour Graphics version 1.03                                     *
*                                                                            *
*       The TrueColour Graphics code and documentation are                   *
*       Copyright (c) 1994-1995 by Matthew Hildebrand; all rights reserved.  *
*                                                                            *
*       Unauthorised usage or modification of any or all of TrueColour       *
*       Graphics is strictly prohibited.                                     *
*****************************************************************************/

#if !defined(FIXFONTdotH)
#define FIXFONTdotH

#include <stdio.h>



//*****
//***** Complain if image support won't be linked; we need it!
//*****

#if !defined(TCGdotH)
#error TCG.H must be #included before FIXFONT.H.
#endif

#if !defined(TCG_USE_IMAGES)
#error TCG_USE_IMAGES must be #defined when fonts are in use.
#endif



//*****
//***** Bitmapped font services class
//*****

class FixedFont
{
  unsigned charWide, charDeep;		// character cell dimensions
  unsigned realCharWide;		// real character width (before adjustment)
  unsigned char fgInv, bgInv;           // fore/background invisible? (if so, Invisible)
  unsigned char fgRed, fgGreen, fgBlue; // foreground colour
  unsigned char bgRed, bgGreen, bgBlue; // background colour
  void far *rawData;			// raw character data here
  void far *image, *mask;               // buffers for putImageMask()
  unsigned charSize;			// character image size in bytes
public:
  enum
  {
    Opaque, Invisible
  };
  FixedFont(Colour *fg=NULL, Colour *bg=NULL, int fgI=Opaque, int bgI=Invisible);
  FixedFont(char *filename, Colour *fg=NULL, Colour *bg=NULL, int fgI=Opaque, int bgI=Invisible);
  ~FixedFont();
  int load(char *filename);
  inline int status(void);                  // return status code (0=ERROR)
  unsigned width(char *str);                // string width in pixels
  inline unsigned width(char ch);           // character width in pixels
  inline unsigned maxWidth(void);           // max character width in pixels
  inline unsigned height(char *str);        // string depth in pixels
  inline unsigned height(char ch);          // character depth in pixels
  inline unsigned maxHeight(void);          // max character height in pixels
  void put(int x, int y, char *str);        // write a string
  void put(int x, int y, char ch);          // write a single character
  inline void foreground(unsigned char r,   // set foreground colour
                         unsigned char g,
                         unsigned char b,
                         int isInvisible=Opaque);
  inline void foreground(Colour *colour, int isInvisible=Opaque);
  inline void background(unsigned char r,   // set background colour
                         unsigned char g,
                         unsigned char b,
                         int isInvisible=Invisible);
  inline void background(Colour *colour, int isInvisible=Invisible);
  inline void foreground(unsigned char *r,  // get foreground colour
                         unsigned char *g,
                         unsigned char *b,
                         int *isInvisible=NULL);
  inline void foreground(Colour *colour, int *isInvisible=NULL);
  inline void background(unsigned char *r,  // get background colour
                         unsigned char *g,
                         unsigned char *b,
                         int *isInvisible=NULL);
  inline void background(Colour *colour, int *isInvisible=NULL);
};


inline int FixedFont::status(void)
{
  return (rawData==NULL ? 0 : 1);
}

inline unsigned FixedFont::width(char)
{
  return (realCharWide);
}

inline unsigned FixedFont::maxWidth(void)
{
  return (realCharWide);
}

inline unsigned FixedFont::height(char *)
{
  return (charDeep);
}

inline unsigned FixedFont::height(char)
{
  return (charDeep);
}

inline unsigned FixedFont::maxHeight(void)
{
  return (charDeep);
}

inline void FixedFont::foreground(unsigned char r, unsigned char g, unsigned char b, int isInvisible)
{
  fgRed = r;
  fgGreen = g;
  fgBlue = b;
  fgInv = isInvisible;
}

inline void FixedFont::foreground(Colour *colour, int isInvisible)
{
  fgRed = colour->r;
  fgGreen = colour->g;
  fgBlue = colour->b;
  fgInv = isInvisible;
}

inline void FixedFont::background(unsigned char r, unsigned char g, unsigned char b, int isInvisible)
{
  bgRed = r;
  bgGreen = g;
  bgBlue = b;
  bgInv = isInvisible;
}

inline void FixedFont::background(Colour *colour, int isInvisible)
{
  bgRed = colour->r;
  bgGreen = colour->g;
  bgBlue = colour->b;
  bgInv = isInvisible;
}

inline void FixedFont::foreground(unsigned char *r, unsigned char *g, unsigned char *b, int *isInvisible)
{
  *r = fgRed;
  *g = fgGreen;
  *b = fgBlue;
  if (isInvisible != NULL)
    *isInvisible = fgInv;
}

inline void FixedFont::foreground(Colour *colour, int *isInvisible)
{
  colour->r = fgRed;
  colour->g = fgGreen;
  colour->b = fgBlue;
  if (isInvisible != NULL)
    *isInvisible = fgInv;
}

inline void FixedFont::background(unsigned char *r, unsigned char *g, unsigned char *b, int *isInvisible)
{
  *r = bgRed;
  *g = bgGreen;
  *b = bgBlue;
  if (isInvisible != NULL)
    *isInvisible = bgInv;
}

inline void FixedFont::background(Colour *colour, int *isInvisible)
{
  colour->r = bgRed;
  colour->g = bgGreen;
  colour->b = bgBlue;
  if (isInvisible != NULL)
    *isInvisible = bgInv;
}



#endif
