/*****************************************************************************
*       TrueColour Graphics version 1.03                                     *
*                                                                            *
*       The TrueColour Graphics code and documentation are                   *
*       Copyright (c) 1994-1995 by Matthew Hildebrand; all rights reserved.  *
*                                                                            *
*       Unauthorised usage or modification of any or all of TrueColour       *
*       Graphics is strictly prohibited.                                     *
*****************************************************************************/

#if !defined(VARFONTdotH)
#define VARFONTdotH



//*****
//***** Complain if image support won't be linked; we need it!
//*****

#if !defined(TCGdotH)
#error TCG.H must be #included before VARFONT.H.
#endif

#if !defined(TCG_USE_IMAGES)
#error TCG_USE_IMAGES must be #defined when fonts are in use.
#endif



//*****
//***** Structure used by the VariableFont class.
//*****

#pragma option -a-

struct FontCharInfo
{
  unsigned short offsetFromTop;
  unsigned short wide, deep;
  void far *bitmap;
};

#pragma option -a



//*****
//***** Class for dealing with variable-sized, 256-colour, loadable fonts.
//*****

class VariableFont
{
  unsigned char fontPalette[768];
  FontCharInfo characters[256];
  void far *characterData, *charBuf, *maskBuf;
  unsigned short maxWide, maxHigh;
  unsigned spaceBetweenChars;
public:
  VariableFont(void);
  ~VariableFont(void);
  int load(char *filename);                     // returns 0 on error
  void put(int x, int y, char ch);
  void put(int x, int y, char *string);
  unsigned width(char *string);
  unsigned height(char *string);
  inline unsigned short width(char ch);
  inline unsigned short height(char ch);
  inline unsigned short maxWidth(void);
  inline unsigned short maxHeight(void);
  void palette(void *palette);
  inline void *palette(void);
  void palette(unsigned char palReg, unsigned char red, unsigned char green,
               unsigned char blue);
  inline void setPalette(unsigned char palReg, Colour *colour);
  void palette(unsigned char palReg, unsigned char *red, unsigned char *green,
               unsigned char *blue);
  inline void getPalette(unsigned char palReg, Colour *colour);
  inline void spacing(unsigned numPixels);
  inline unsigned spacing(void);
};



/**************************************************************************
*  Function:    VariableFont::width
*
*  Purpose:     Return the width, in pixels, of a single character.
*
*  Entry:       ch = Character of which to find the width.
*
*  Exit:        Returns the width of the character in pixels, not
*               accounting for blank space on either side.
**************************************************************************/

inline unsigned short VariableFont::width(char ch)
{
  return (characters[(unsigned)ch].wide);
}



/**************************************************************************
*  Function:    VariableFont::height
*
*  Purpose:     Return the height, in pixels, of a single character's
*               bitmap.  The offsetFromTop value is ignored.
*
*  Entry:       ch = Character of which to find the height.
*
*  Exit:        Returns the height of the character in pixels, not
*               accounting for blank space above or below.
**************************************************************************/

inline unsigned short VariableFont::height(char ch)
{
  return (characters[(unsigned)ch].deep);
}



/**************************************************************************
*  Function:    VariableFont::maxWidth
*
*  Purpose:     Return the width, in pixels, of the widest character.
*
*  Entry:       N/A
*
*  Exit:        Returns the width of the widest character in pixels, not
*               accounting for blank space used between characters.
**************************************************************************/

inline unsigned short VariableFont::maxWidth(void)
{
  return (maxWide);
}



/**************************************************************************
*  Function:    VariableFont::maxHeight
*
*  Purpose:     Return the height, in pixels, of the tallest character.
*
*  Entry:       N/A
*
*  Exit:        Returns the height of the tallest character in pixels, not
*               accounting for blank space above or below.
**************************************************************************/

inline unsigned short VariableFont::maxHeight(void)
{
  return (maxHigh);
}



/**************************************************************************
*  Function:    VariableFont::palette
*
*  Purpose:     Return the current font palette.
*
*  Entry:       N/A
*
*  Exit:        Returns the address of the current font palette.
**************************************************************************/

inline void *VariableFont::palette(void)
{
  return (fontPalette);
}



/**************************************************************************
*  Function:    VariableFont::getPalette
*
*  Purpose:     Return one of the current font palette registers.
*
*  Entry:       palReg = Palette register to get.
*               colour = Colour structure buffer.
*
*  Exit:        On return, the palette entry is stored in the colour
*               buffer.
**************************************************************************/

inline void VariableFont::getPalette(unsigned char palReg, Colour *colour)
{
  palette(palReg, &colour->r, &colour->g, &colour->b);
}



/**************************************************************************
*  Function:    VariableFont::setPalette
*
*  Purpose:     Set one of the current font palette registers.
*
*  Entry:       palReg = Palette register to set.
*               colour = Colour structure buffer.
*
*  Exit:        N/A
**************************************************************************/

inline void VariableFont::setPalette(unsigned char palReg, Colour *colour)
{
  palette(palReg, colour->r, colour->g, colour->b);
}



/**************************************************************************
*  Function:    VariableFont::spacing
*
*  Purpose:     Set the spacing, in pixels, between characters.
*
*  Entry:       numPixels = New spacing value, in pixels.
*
*  Exit:        N/A
**************************************************************************/

inline void VariableFont::spacing(unsigned numPixels)
{
  spaceBetweenChars = numPixels;            // change spacing value
}



/**************************************************************************
*  Function:    VariableFont::spacing
*
*  Purpose:     Return the spacing, in pixels, between characters.
*
*  Entry:       N/A
*
*  Exit:        Returns the spacing in pixels.
**************************************************************************/

inline unsigned VariableFont::spacing(void)
{
  return (spaceBetweenChars);               // return spacing value
}
 


#endif
