
	include model.inc
	include	vesa.inc

;
;	VGAKIT Version 6.0
;
;	Copyright 1988,89,90,91,92,93,94 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	MODESET.ASM
;
;
.data
	extrn	curbk:word,bksize:word
	extrn	vesafunc:dword

	public	maxx,maxy,scanline,ourseg

maxx	dw	?		;scanline of screen in pixels
maxy	dw	?		;height of screen in pixels
scanline dw	?		;actual width screen in bytes
ourseg	dw	?		;segment of screen buffer

	public	justvesa,novesa,nosvga

justvesa dw	?		;only check for VESA, no chipset tests
novesa	dw	?		;disable all VESA VBE checks
nosvga	dw	?		;disable all SVGA checks including VESA

	public	adrtbl

adrtbl	dd	1024 dup (?)	;offset and bank for each scanline

.code

	public	mkadrtbl
	public	txtmode
	public	setmany

mkadrtbl proc	uses di si
	mov	[curbk],-1
	mov	di,offset adrtbl
	mov	ax,ds
	mov	es,ax
	mov	bx,[maxy]

	mov	ax,[bksize]
	cmp	ax,64
	jz	nobnk
	mov	cl,10
	shl	ax,cl
	dec	ax
	mov	si,ax
	mov	cl,9
	mov	ax,[bksize]
shlp:	inc	cl
	shr	ax,1
	jnz	shlp
	xor	ax,ax
	xor	dx,dx
lp:	push	ax
	shr	ax,cl
	add	dx,ax
	pop	ax
	and	ax,si
	stosw
	xchg	ax,dx
	stosw
	xchg	ax,dx
	add	ax,[scanline]
	dec	bx
	jnz	lp
	ret

nobnk:	xor	ax,ax
	xor	dx,dx
	mov	si,[scanline]
	mov	cx,bx
nlp:	stosw
	xchg	ax,dx
	stosw
	xchg	ax,dx
	add	ax,si
	adc	dx,0
	loop	nlp
	ret

mkadrtbl endp

vesaset	proc	near uses di
	local	modebuf[260]:byte	; extra large to make up for
					; bugs in some VESA VBE's
	push	bx
	mov	ax,4f02h		; set the VESA videomode
	int	10h
	pop	cx
	mov	ax,ss
	mov	es,ax
	lea	di,modebuf[0]		; get the mode information
	mov	ax,4f01h
	int	10h
	mov	ax,modebuf.vesamode.WinGranularity
	mov	[bksize],ax		; bank size from vesamode structure
	mov	ax,modebuf.vesamode.BytesPerLine
	mov	[scanline],ax		; scan line byte width from vesamode
	mov	ax,word ptr modebuf.vesamode.WinFuncPtr
	mov	word ptr [vesafunc],ax
	mov	ax,word ptr modebuf.vesamode.WinFuncPtr+2
	mov	word ptr [vesafunc+2],ax
	ret
vesaset	endp

txtmode	proc
	mov	ax,3
	int	10h
	ret
txtmode	endp

setmany proc	palbuf:ptr byte,begcol:word,numcol:word
if @Datasize
	les	dx,[palbuf]
else
	mov	ax,ds
	mov	es,ax
	mov	dx,[palbuf]
endif
	mov	bx,[begcol]
	mov	cx,[numcol]
	mov	ax,1012h
	int	10h
	ret
setmany endp

	end


