/*
   
   Endor Ltd 
   63 Church Road
   Albrighton 
   Shropshire
   WV7 3HL
   England

   Specialists in design and implementation of EIS and MIS systems 

   
   Telephone: 
       Analysis  081 558 2279    Peter Jordan  MD 
       Technical 0902 374 900    Peter Kulek   Technical Director
   
   Compuserve ID 100140,1220
   
   We design EIS and MIS systems for large data users for use on
   laptops to large networks with auto downloading from mainframes.

   If you have a large database and cannot get it into a user friendly 
   format please give us a call and we will send you a live sample 
   application that will show you how to manipulate vast quantities 
   of data EASILY, with a minimum of tables. 
   
   For example a complete hierachy from parent holding company through 
   to salesperson with profit and loss at each level, targeting, variances 
   both monetary and percentage, graphs at each level for period and weekly 
   figures all with five tables and designed and implemented within a month 
   from recieving TOR. 
   
   Directors and Managers in large corporations have found it very friendly 
   and most important they use it daily. 
   
   To really appreciate the vast amount of data and the easy interface a
   copy of the application has to be seen.
   
   This is not some system using commercial EIS applications which need
   months of training and have heaps of files floating all over the place.
   This is far superior methodology to any of the current commercial offerings.
    

   No Problem to large to solve.
*/
//-----------------------------------------------------------------------------

#include 'impala.ch'


#ifdef TEST

function test()
cls
    ? 'Current Volume Serial No : '
    ?? VolSerial()
    ? 'Current Volume Label Name : '
    ?? VolLabel()
    
    ? 'Volume Serial No In Drive A : '
    ?? VolSerial(1)
    ? 'Volume Label Name In Drive A : '
    ?? VolLabel('A')

return(NIL)

#endif



/*  $DOC$
 *  $FUNCNAME$
 *     VolSerial()
 *  $CATEGORY$
 *     Disk
 *  $ONELINER$
 *     Determines the DOS disk serial number
 *  $SYNTAX$
 *     VOLSERIAL([<xDrive>],[<nNumber>]) --> nVolSerial
 *  $ARGUMENTS$
 *     <xDrive>  Designates the drive whose volume serial number is
 *               to be queried either as letter or Number ie: 'a','A' or 1.  
 *               The default is 0 the current disk drive.
 *     <nNumber> The New Serial number to Set.
 *  $RETURNS$
 *     VOLSERIAL() returns the current volume serial number of the DOS 
 *                 disk, hard disk, or a 0, when you are not dealing 
 *                 with a DOS 4.0 or higher or on error.
 *  $DESCRIPTION$
 *     VOLUME SERIAL NUMBER
 *     Beginning with DOS version 4.0, every floppy or hard disk 
 *     receives a volume serial number during formatting.  
 *     This is a 32-bit number created by DOS using the date,
 *     clock time, and a counter.
 *  $EXAMPLES$
 *     Query the volume serial number of the current drive:
 *     
 *     ? VOLSERIAL()    // 0, when no DOS 4.x disk or error
 *
 *     Sets a new serial number of the floppy in drive A
 *     and returns the old one:
 *     
 *     ? VOLSERIAL(1,123456789)
 *
 *    
 *  $END$
 */

function VolSerial(xDrive,nNumber)
local cData := volume(xDrive)
if ! empty(cData)
    if ISNUMERIC(nNumber)
        volume(xDrive,stuff(cData,3,4,l2bin(nNumber)))
    endif
    return(bin2l(substr(cData,3,4)))
endif
return(0)
//----------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     VolLabel()
 *  $CATEGORY$
 *     Disk
 *  $ONELINER$
 *     Determines the DOS disk Volume Label Name
 *  $SYNTAX$
 *     VOLLABEL([<xDrive>],[<cLabel>]) --> cLabel
 *  $ARGUMENTS$
 *     <xDrive>  Designates the drive whose volume serial number is
 *               to be queried either as letter or Number ie: 'c','C' or 3.  
 *               The default is 0 the current disk drive.
 *     <nNumber> The New Serial number to Set.
 *  $RETURNS$
 *     VOLLABEL() returns the current volume Label Name of the DOS 
 *                 disk, hard disk.
 *  $EXAMPLES$
 *     Query the volume Label Name of the current drive:
 *     
 *     ? VOLLABEL()            
 * //------------------
 *     Sets a New Volume Label on Drive A and Returns The Old One
 *     
 *     ? VolLabel('A','NEW_LABEL')            
 *    
 *  $END$
 */

function VolLabel(xDrive,cLabel)
local cData := volume(xDrive)
if ! empty(cData)
    if ISCHAR(cLabel)
        volume(xDrive,stuff(cData,7,11,padr(cLabel,11)))
    endif
    return(substr(cData,7,11))
endif
return('')







