/* WNDDB.H v1.0 Copyright (c) 1993, 1994 Burnham Park Software, Inc. */
#ifndef __WNDDB_H
#define __WNDDB_H

#ifndef __WNDCLASS_H
#include <wndclass.h>
#endif

#ifndef __COMMDLG_H
#include <commdlg.h>
#endif

#ifndef __PRINT_H
#include <print.h>
#endif

#define IDD_Filename 50
#define IDD_Directory 51
#define IDD_Files 52
#define IDD_Directories 53
#define IDD_Description 54
#define IDD_Text 55

#define DBF_NONE 0
#define DBF_CENTER 1

#define MF_MEMERROR 0
#define MF_READERROR 1
#define MF_TYPEERROR 2
#define MF_WRITEERROR 3
#define MF_REPLACE 4
#define MF_VERSIONERROR 5

#define PF_NONE 0
#define PF_CENTER 1
#define PF_SETUP 2
#define PF_BANDING 4
#define PF_LANDSCAPE 8
#define PF_NEWPAGE 16
#define PF_SECOND 32

DBFUNC FileOpenProc(HWND hwnd, WORD message, WORD wparam, LONG lparam);
DBFUNC FileSaveasProc(HWND hwnd, WORD message, WORD wparam, LONG lparam);

class FILEDB_CLASS : public FILE_CLASS{
  char filename[96], filespec[16], defaultspec[6], caption[41], description[41];
  char* applicationname;
  unsigned int status, head;
  unsigned char flag;
  HANDLE hinstance;
  public:
    FILEDB_CLASS(char* input) : FILE_CLASS(){
      lstrcpy(defaultspec, input);
      caption[0] = 0;
    }
    FILEDB_CLASS() : FILE_CLASS(){
      lstrcpy(defaultspec, "*.*");
      caption[0] = 0;
    }
    char *Getfilespec() { return filespec; }
    char *Getfilename() { return filename; }
    char *Getdefaultspec() { return defaultspec; }
    char *Getcaption() { return caption; }
    char *Getdescription() { return description; }
    char *Getapplicationname() { return applicationname; }
    int Gethead() { return head; }
    int Getflag() { return flag; }
    HANDLE Gethinstance() { return hinstance; }
    void Setdefaultspec(char* input) { lstrcpy(defaultspec, input); }
    void Setcaption(char* input) { lstrcpy(caption, input); }
    void Setdescription(char* input) { lstrcpy(description, input); }
    void Setapplicationname(char* input) { applicationname = input; }
    void Sethinstance(HANDLE input) { hinstance = input; }
    void parsefilename(LPSTR string1, LPSTR string2);
    void DescriptionList(HWND hwnd);
    int FileOpen(HWND hwnd, int f);
    int FileOpen(HWND hwnd) { return FileOpen(hwnd, DBF_CENTER); }
    int FileSaveas(HWND hwnd, int f);
    int FileSaveas(HWND hwnd) { return FileSaveas(hwnd, DBF_CENTER); }
    int DescriptionOpen(HWND hwnd, int input, int f);
    int DescriptionOpen(HWND hwnd, int input)
     { return DescriptionOpen(hwnd, input, DBF_CENTER); }
    int DescriptionSaveas(HWND hwnd, int f);
    int DescriptionSaveas(HWND hwnd) { return DescriptionSaveas(hwnd, DBF_CENTER); }
    int FileMessage(HWND hwnd, int flag);
    int FileRead(HWND hwnd);
    int FileWrite(HWND hwnd);
};

extern FILEDB_CLASS fc;

BOOL FAR PASCAL AbortProc(HDC hdc, short ncode);
DBFUNC PrintProc(HWND hwnd, WORD message, WORD wparam, LONG lparam);

class PRINTDB_CLASS : public PRINT_CLASS{
  unsigned char abort, flag, page, printpage;
  unsigned int vertical, horizontal, height, width, line;
  char printname[40];
  FARPROC abortproc, printproc;
  HWND hprint;
  HANDLE hinstance;
  PRINTDLG pd;
  DEVMODE dm;
  DEVNAMES dn;
  public:
    PRINTDB_CLASS(){
      abort = flag = page = FALSE;
      abortproc = printproc = NULL;
      hprint = NULL;
      printname[0] = 0;
    }
    ~PRINTDB_CLASS() { Freeproc(); }
    int Getabort() { return abort; }
    int Getflag() { return flag; }
    int Getpage() { return page; }
    int Getprintpage() { return printpage; }
    int Getline() { return line; }
    int Getbanding() { return (flag & PF_BANDING) > 0; }
    int Getvertical() { return vertical; }
    int Gethorizontal() { return horizontal; }
    int Getheight() { return height; }
    int Getwidth() { return width; }
    char *Getprintname() { return printname; }
    HWND Gethprint() { return hprint; }
    HANDLE Gethinstance() { return hinstance; }
    void Setabort(int input) { abort = input; }
    void Setabort() { Setabort(TRUE); }
    void Setflag(int input) { flag = input; }
    void Setpage(int input) { page = input; }
    void Setprintpage(int input) { printpage = input; }
    void Setvertical(int input) { vertical = input; }
    void Sethorizontal(int input) { horizontal = input; }
    void Setheight(int input) { height = input; }
    void Setwidth(int input) { width = input; }
    void Setline(int input) { line = input; }
    void Sethprint(HWND input) { hprint = input; }
    void Sethinstance(HANDLE input) { hinstance = input; }
    void Setabortproc();
    void Resetabort() { Setabort(FALSE); }
    void Freeproc(){
      if(abortproc){
        FreeProcInstance(abortproc);
        abortproc = NULL;
      }
      if(printproc){
        FreeProcInstance(printproc);
        printproc = NULL;
      }
    }
    int Testprint() { return error == FALSE && abort == FALSE; }
    int Testpage(int page);
    int PrintMessage(HWND hwnd, int flag);
    int PrintMessage(HWND hwnd) { return PrintMessage(hwnd, error); }
    int Printsetup(HWND hwnd, char *text, int f);
    int Printsetup(HWND hwnd, char *text) { return Printsetup(hwnd, text, PF_CENTER); }
    void Printersetup(HWND hwnd) { Printsetup(hwnd, NULL, PF_SETUP); }
    void Printwindup(HWND hwnd);
    void Startpage();
    int Endpage();
    void PrintText(int dx, int dy, LPSTR text);
};

extern PRINTDB_CLASS pc;

#endif
