//********************************************************************************
// XDIR.PRG
//     A: Support for NDX's
//     B: Changed the time to the 12 hour clock,
//     C: Allowed path names
//     D: Print to a file or the printer (ie: print to PRN)
//     E: Ability to sort by Name /ON
//                        by Date /OD
//                        by File Size /OS
//     F: Print pathway and files specification selected
//     G: Print total space left on the drive selected
//     H: Checks for color board and if so writes yellow on blue
// PKLITE will reduce this program to 132K and it will run fine
// Compile: Clipper XDIR /n/m/w
// Link   : Blinker / RTLink fi XDIR
// Notes  : This is 'fame-ware' - copy as much as you want, modify all you want,
//          distribute all you want.  Just include my name, Lawrence Wolfram
//          as the secondary author and Shaun Botha as the orginal author.
//
//          The authors may be reached as follows:
//          ShaunB..  (Shaun Botha [CI$ 70043,2641])
//          Lawrence Wolfram care of (Sean Fahey [CIS 72303,3671])
//          Kevin S. Gallagher [CIS 70034,2313]
//
// -KSG- 04/94
//
//     A: Norton's IMAGE.IDX is bypassed from index readings
//     B: The [/F] option is hard coded, but can be changed. Use
//        your programmers editors search function and search for
//        all occurances of '/F' to see what i have done.
//     C: I shutdown display to the screen when [/F] is used.
//     D: All hidden directories are marked with chr(176) in the
//        directory listing.
//     E: Forgot to coded FCLOSE() in my original tweaks of this
//        utility, and it worked fine until there were lots of
//        datafiles that needed to be opened, thus i didn't caught
//        it until i recieved errors. The errors didn't hurt anything,
//        they were due to lack of file handles. This has been fixed!
//     F: RENamed xdir.prg to xdir__.prg, but outputs at link as XDIR.EXE
//     
//     Compile: /n/m/l/dKSG_INDEXER
// Link script:
//              nodeflib
//              out xdir
//              blinker clipper page off
//              blinker incremental off
//              file xdir
//              lib clipper,terminal,extend
//
// After linking, shrink the .exe with either PKlite or LZexe - Done!
//
// End KSG modifications
//*****************************************************************************

#include "fileio.ch"
#include "directry.ch"

#define BLOCKSZ 512
#define EXPOFS		22
#define EXPOFS2     24
#define NULL        chr(0)
#xtranslate SORTBLOCK( <dim> )=>{|curr, next|  curr\[<dim>] \< next\[<dim>]}

#ifdef KSG_INDEXER
#stdout 
#stdout ------------------------------------------------------------------------------
#stdout Creating XDIR utility, Please wait!
#stdout ------------------------------------------------------------------------------
#stdout 

    #define bIndexBlock             ;
    { || ".IDX" $ aFiles[x,1] .or.  ;
         ".NTX" $ aFiles[x,1] .or.  ;
         ".NDX" $ aFiles[x,1]       ;
    }
    #define ClipIDX         512
    #define DBFSixIDX      2048
    STATIC aOffSet_ := { 22, 24, ClipIDX }
    #define NTX_EXP_OFFSET aOffSet_[1]  // 22
    #define NDX_EXP_OFFSET aOffSet_[2]  // 24
    #define IDX_EXP_OFFSET aOffSet_[3]  // 512 Clipper, 2048 for DBFSix
    #define NTX_EXP_MAXLEN 250 
    #define FIELD_REC      32
    #define FIELD_LEN      10
    //
    // Output file for [/F]
    //
    #define SEND_TO_DISKFILE "$$$$$$$$.!!!"

#endif


procedure main(cSpec, cSwitch, cExtra, cSort)
    local aFiles, x, nDisksp :=0,nDrivet :=0, cDirectr, lpagect := .t.
    local cBase, cExt, cSize, cDate, cTime, nTotSize, cDirectr2
    local dLUpd, nRecs, lPaged, nRows, lAborted, cExpr, nPos, cBaseDir
    local cSpec2

    // Set up array of drive letters
    STATIC aDrives := {"A","B","C","D","E","F","G","H","I","J","K","L","M", ;
                      "N","O","P","Q","R","S","T","U","V","W","X","Y","Z"}

    SETCOLOR("W/N, N/W")

    // Fix our parameters
    // cDirectr is used in setting up the path
    if cSpec != nil
        cSpec    := upper(cSpec)
        cSpec2   := cSpec
        nPos     := ATLAST("\",cSpec)
        cDirectr :=SUBSTR(cSpec,1,nPos)
        IF nPos == 0
          nPos     := ATLAST(":",cSpec)
          cDirectr :=SUBSTR(cSpec,1,nPos)
        ENDIF
    endif
    if cSwitch != nil
        cSwitch := upper(cSwitch)
    else
        cSwitch := " "
	endif
    if cExtra != nil
        cExtra := upper(cExtra)
    else
        cExtra := " "
    endif
    if cSort != nil
        cSort := upper(cSort)
    else
        cSort := " "
    endif

	lPaged := .f.
    do case
      // Determine whether display is to be paged
      case cSpec2 == "/P"
		lPaged := .t.
        cSpec  := ""
      case cSwitch == "/P" .or. cExtra == "/P";
          .or. cSort == "/P"
		lPaged := .t.
    end case

    do case
    // Determine whether display to be printed to a file
      case cSpec2 == "/F"
        set alternate on
        if cSwitch == " "
           #ifdef KSG_INDEXER
                if file(SEND_TO_DISKFILE)
                    set alternate to (SEND_TO_DISKFILE) additive
                else
                    set alternate to (SEND_TO_DISKFILE)
                endif
           #else
                set alternate to T.TXT
           #endif
        else
           set alternate to (cSwitch)
        endif
        cSpec := ""
      case cSwitch == "/F"
        set alternate on
        if cExtra == " "
           #ifdef KSG_INDEXER
                if file(SEND_TO_DISKFILE)
                    set alternate to (SEND_TO_DISKFILE) additive
                else
                    set alternate to (SEND_TO_DISKFILE)
                endif
           #else
                set alternate to T.TXT
           #endif
        else
           set alternate to (cExtra)
        endif
      case cExtra == "/F"
        set alternate on
        if cSort == " "
           #ifdef KSG_INDEXER
                if file(SEND_TO_DISKFILE)
                    set alternate to (SEND_TO_DISKFILE) additive
                else
                    set alternate to (SEND_TO_DISKFILE)
                endif
           #else
                set alternate to T.TXT
           #endif
        else
           set alternate to (cSort)
        endif
      case cSort == "/F"
        set alternate on
           #ifdef KSG_INDEXER
                if file(SEND_TO_DISKFILE)
                    set alternate to (SEND_TO_DISKFILE) additive
                else
                    set alternate to (SEND_TO_DISKFILE)
                endif
           #else
                set alternate to T.TXT
           #endif
      case cSpec == "/?" .or. cSpec == "/H"
        #ifdef KSG_INDEXER
        // I want for very limited help
        ?"Xdir displays a directory similar to that of DOS's DIR command."
        ?"Also will display dBase file info, and index file info"
        ?
        ? "COMMAND LINE ARGUMENTS: XDIR <PATH> <FILESPEC> /F /P /O<N,S,D> /<?,H>"
        ? "SAMPLE:   XDIR C:\WORK\*.* /ON /F"
        ?
        #else
        ? "Xdir displays a directory similar to that of DOS's DIR command.  In addition"
        ? "the program will display the number of records and fields in a dBase file"
        ? "and will display the index expression of Clipper NTX files and Dbase III"
        ? "NDX files."
        ?
        ? "Paths are supported ie: xdir c:\xxx\ with give the entire directory"
        ? "of subdirectory xxx, xdir c:\xxx\*.ndx will give all of the dbase NDX"
        ? "files and so forth!"
        ?
        ? "COMMAND LINE ARGUMENTS: XDIR <PATH> <FILESPEC> /F /P /O<N,S,D> /<?,H>"
        ? "SAMPLE:   XDIR C:\WORK\*.* /ON /F WORK.DIR"
        ?
        ? "      Note: Default [file_spec] left blank then *.* is assumed"
        ? "            If [/F] is present and [print-file] is blank then"
        ? '             [print_file] is assumed to be "T.TXT "'
        ? "            If [print_file] does not have an extension then the extension"
        ? '              is assumed to be "TXT"'
        ? "            If [print_file] = PRN then directory will print to the printer"
        #endif
        quit
    endcase

    // Default to "*.*"
    if empty(cSpec).or. substr(cSpec,1,2)=="/O"
        cSpec := "*.*"
        cDirectr :=" "
    endif
        cDirectr2 := cDirectr

    // Convert drive letter to number
    if substr(cSpec,2,1) ==":"
      nDrivet := ASCAN(aDrives,SUBSTR(cSpec,1,1))
      if len(cSpec) <3
        cBaseDir := cSpec + "*.*"
      else
        cBaseDir := cSpec
      endif
    else
      nDrivet := "0"
      cBaseDir := curdir()+"\"+cSpec
    endif
    
    ? "Pathway selected "+ cBaseDir
    ?
    ?

    lAborted := .f.
	errorBlock({|e| doBreak(e) })				// Post a basic error handler
    aFiles := directory(cSpec, "HSD")      // Get all files
    do case
      case cSpec2 =="/ON".or.cSwitch =="/ON".or.cExtra =="/ON".or.cSort =="/ON"
           //Sort the directories by name
        aFiles := asort( aFiles,,, SORTBLOCK(1))
      case cSpec2 =="/OS".or.cSwitch =="/OS".or.cExtra =="/OS".or.cSort =="/OS"
           //Sort the directories by size
        aFiles := asort( aFiles,,, SORTBLOCK(2))
      case cSpec2 =="/OD".or.cSwitch =="/OD".or.cExtra =="/OD".or.cSort =="/OD"
           //Sort the directories by date
        aFiles := asort( aFiles,,, SORTBLOCK(3))
    endcase

    #ifdef KSG_INDEXER
        if set(_SET_ALTFILE) == SEND_TO_DISKFILE
            lPaged := .F.
            set console off
        endif
    #endif

    nRows    := 0                          // Initialize row count for pages
	// Figure total size of files
	nTotSize := 0
	aeval(aFiles, {|f| nTotSize += f[F_SIZE] })

	for x := 1 to len(aFiles)
		if inkey() == 27
			lAborted := .t.
			exit
		endif

		nRows++
		cBase := cExt := ""                 // Init these vars

		// Treat directories differently to 'normal' files
        if at("D", aFiles[x, F_ATTR]) != 0
            if at("HD", aFiles[x, F_ATTR]) != 0
                cSize := padr("<DIR> ", 8)
            else
                cSize := padr("<DIR>", 8)
            endif

			cBase := aFiles[x, F_NAME]
		else
            if at(".", aFiles[x, F_NAME]) != 0
				cBase := left(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])-1)
				cExt  := substr(aFiles[x, F_NAME], at(".", aFiles[x, F_NAME])+1)
			else
				cBase := aFiles[x, F_NAME]
			endif
			cSize := ltrim(str(aFiles[x, F_SIZE]))
			cSize := padl(cSize, 8)
		endif

		// Get date and time - convert time to look like DOS
		cDate := dtoc(aFiles[x, F_DATE])
          cTime := left(aFiles[x, F_TIME], 5)
          If val(cTime) < 12
            If val(substr(cTime,1,1))==0
               cTime := " "+substr(cTime,2,4)+"a"
            else
               cTime := cTime + "a"
            endif
          else
             // Convert time to 12 hour clock basis
            cTime := right(str(val(substr(cTime,1,2))-12),2)+substr(cTime,3,3)+"p"
          endif
          // Show the info
		if lPaged
            if lpagect
              if nRows > maxRow()-4
                  ?? "Press any key to continue or [Esc] to quit"
                  if inkey(0) == 27
                      lAborted := .t.
                      ?
                      exit
                  endif
                  ?
                  nRows := 0
                  lpagect := .f.
              endif
            else
              if nRows > maxRow()
                  ?? "Press any key to continue or [Esc] to quit"
                  if inkey(0) == 27
                      lAborted := .t.
                      ?
                      exit
                  endif
                  ?
                  nRows := 0
                  lpagect := .f.
              endif

            endif
        endif
        ?? padr(cBase, 9), padr(cExt, 3), cSize, cDate, cTime
        if cBase == "IMAGE"
            ??"...'Norton Utilities file'"
            ?
            loop
        endif


        #ifdef KSG_INDEXER

        if eval(bIndexBlock)
            if cDirectr == " "
                cExpr := ShowIndice( aFiles[x,F_NAME] )
            else
                cDirectr :=cDirectr+(aFiles[x, F_NAME])
                cExpr := ShowIndice(cDirectr)
            endif
			if len(cExpr) <= (maxCol() - col()-3)
				?? ".." + cExpr
            else
                ? ".." + cExpr
                nRows++
            endif
            cDirectr := cDirectr2
        endif
        #else
        // If this is a NTX file then show the index expression
		if at(".NTX", aFiles[x, F_NAME]) != 0
			// Show the expression - if it's longer than what's still available
			// on the screen show it on the next line
            if cDirectr == " "
                cExpr := ntxExpr(aFiles[x, F_NAME])
            else
                cDirectr :=cDirectr+(aFiles[x, F_NAME])
                cExpr := ntxExpr(cDirectr)
            endif
			if len(cExpr) <= (maxCol() - col()-3)
				?? ".." + cExpr
            else
                ? ".." + cExpr
                nRows++
            endif
            cDirectr := cDirectr2
        endif

        // If this is a NDX file then show the index expression
        if at(".NDX", aFiles[x, F_NAME]) != 0
			// Show the expression - if it's longer than what's still available
			// on the screen show it on the next line
            if cDirectr == " "
                cExpr := ndxExpr(aFiles[x, F_NAME])
            else
                cDirectr :=cDirectr+(aFiles[x, F_NAME])
                cExpr := ndxExpr(cDirectr)
            endif
            if len(cExpr) <= (maxCol() - col()-3)
				?? ".." + cExpr
            else
                ? ".." + cExpr
                nRows++
            endif
            cDirectr := cDirectr2
        endif
        #endif

        // If this is a DBF file then show some extra info
        if at(".DBF", aFiles[x, F_NAME]) != 0
            #ifdef KSG_INDEXER
            if cDirectr == " "
               cDirectr := (aFiles[x, F_NAME])
            else
               cDirectr :=cDirectr+(aFiles[x, F_NAME])
            endif
            ?? "..." + padl(TotalRecs(cDirectr),8,".") + " Records    "
            ?? ListFlds(cDirectr) + " Fields"
            cDirectr := cDirectr2
            #else
			begin sequence
                     if cDirectr == " "
                        cDirectr := (aFiles[x, F_NAME])
                     else
                        cDirectr :=cDirectr+(aFiles[x, F_NAME])
                     endif
                     use (cDirectr) new shared
                     ?? "..." + padl(ltrim(str(lastRec())),8,".") + " Records    " + padl(ltrim(str(fcount())),4)+" Fields"
                     cDirectr := cDirectr2
                     use
			recover
				// More than likely caused by the current directory not being the
				// one where the DBF is located
				?? "..Could not open file"
            end sequence
            #endif
		endif
        ?
	next x

	// Show some summary info
	if lAborted
		? "*Process aborted*"
	endif
	? padl(ltrim(str(len(aFiles))), 10) + " file(s) " + padl(ltrim(str(nTotSize)),8) + " bytes used"
    nDisksp := len(LTRIM(str(DISKSPACE(nDrivet))))
    nDisksp := 27-nDisksp
    ? replicate(" ",nDisksp)+LTRIM(str(DISKSPACE(nDrivet)))+ " bytes free"

    #ifdef KSG_INDEXER
        if set(_SET_ALTFILE) == SEND_TO_DISKFILE
            set console on
        endif
    #endif
return


// This is not exactly a great error handler but it does the job
procedure doBreak(e)
	break e
return
static function ntxExpr(cFile)
	local nHandle, cBuff, cExpr, x

	cExpr := "*Unknown*"
	cBuff := space(BLOCKSZ)

	// Open the file as READONLY, SHARED
	if (nHandle := fopen(cFile, FO_READ + FO_SHARED)) != -1
		// The expression starts at byte 22 in the file
		if fseek(nHandle, EXPOFS, FS_SET) == EXPOFS
			// Read a block big enough to accomodate the index expression
			if fread(nHandle, @cBuff, BLOCKSZ) == BLOCKSZ
				// The expression is terminated by a NULL character
				cExpr := left(cBuff, at(NULL, cBuff)-1)
			else
				cExpr := "Read error in NTX file"
			endif
		else
			cExpr := "Seek error in NTX file"
		endif

		// Close the file
		fclose(nHandle)
	else
		cExpr := "Could not open NTX file"
	endif
return cExpr


static function ndxExpr(cFile)
	local nHandle, cBuff, cExpr, x

	cExpr := "*Unknown*"
	cBuff := space(BLOCKSZ)

	// Open the file as READONLY, SHARED
	if (nHandle := fopen(cFile, FO_READ + FO_SHARED)) != -1
        // The expression starts at byte EXPOFS2 in the file
        if fseek(nHandle, EXPOFS2, FS_SET) == EXPOFS2
			// Read a block big enough to accomodate the index expression
			if fread(nHandle, @cBuff, BLOCKSZ) == BLOCKSZ
				// The expression is terminated by a NULL character
				cExpr := left(cBuff, at(NULL, cBuff)-1)
			else
                cExpr := "Read error in NDX file"
			endif
		else
            cExpr := "Seek error in NDX file"
		endif

		// Close the file
		fclose(nHandle)
	else
        cExpr := "Could not open NDX file"
	endif
return cExpr

function atlast(char1,cspec)
//  gets the position of the last occurrence of a character in a string
//  used to find "/" or ":" in the parameter path string (ie: cspec)
local x,nPos:=0
for x = 1 to len(cspec)
  if substr(cspec,x) = char1
    nPos := x
  endif
next
return nPos

#ifdef KSG_INDEXER
function ShowIndice( cFile )
    local nOffSet := 0
    local cRetVal :=""

    nOffSet := IndiceName( cFile )
    cRetVal := NtxExpEval( cFile, nOffSet )

    do case
        case empty( cRetVal ) .and. nOffSet == ClipIDX
            // Norton stores various info about the disk here
            if "IMAGE" $ cFile
                return "" // "Norton Utilities file"
            endif

            cRetVal := NtxExpEval( cFile, DBFSixIDX )
            if empty( cRetVal)
                // uncomment to enable error message
                // cRetVal := "Error reading "+ cFile
            endif
        case empty( cRetVal )
            // uncomment to enable error message
            // cRetVal := "Error reading "+ cFile
    endcase
return cRetVal

function IndiceName( cFile )
    local cNtxExt := ""
    local nExpOff := 0
    local cPath   := ""

    cNtxExt := upper( subs( cFile, rat(".", cFile) +1, 3 ) )

    if (( nExpOff := if( cNtxExt == "NTX", NTX_EXP_OFFSET,      ;
                     if( cNtxExt == "NDX", NDX_EXP_OFFSET,      ;
                     if( cNtxExt == "IDX", IDX_EXP_OFFSET, -1 ) ;
                                );
                            );
                    ) == -1;
        )
    endif

return nExpOff

static function NtxExpEval( cFile, nOffSet )
    local nHandle := 0, cBuffer := ""
    if ( nHandle := fopen( cFile, FO_READ) ) > 4
        fseek(nHandle,nOffSet,  FS_SET)
        cBuffer := freadstr( nHandle,NTX_EXP_MAXLEN )
        fclose( nHandle )
    endif
return ( cBuffer )


function TotalRecs( cFile )
    local nHandle := 0
    local cBuffer := ""
    local cRecords:= ""
    if ( nHandle := fopen(cFile, FO_READ) ) >4
        fseek(nHandle,4)
        cRecords := space(4)
        fread(nHandle,@cRecords,4)
        fClose(nHandle)
        cRecords := ltrim(str(bin2l(cRecords)))
    else
        cRecords := "Error"
    endif
return cRecords

announce rddsys
init procedure rddinit()
return

static function ListFlds( cFile )
    local nHandle := 0
    local nField  := 1
    local aArr_   := {}
    local nFields := 0

    if ( nHandle := fopen( cFile, FO_READ + FO_SHARED ) ) > 0
        while .t.
            fseek( nHandle, FIELD_REC * nField++, FS_SET )
            if freadStr( nHandle, 1 ) == chr(13)
                exit
            else
                fseek( nHandle, -1, FS_RELATIVE )
            endif
            ++nFields
        enddo
    else
        return "Error"
    endif
    fclose(nHandle)     // 04/94
return ltrim(str(nFields))
#endif
