



                                       Preface


      The Shell System is an application that will allow the user to launch
      selected and password protected Foxpro applications.  Shell itself is
      written in the dBASE IV compatible language called Foxpro.

      Among the Shell System features is the ability to run in a Multi-user
      environment.  The Shell System will maintain passwords based on the
      application or based on the user.  Another benefit of the Shell
      System is the need to load Foxpro only once.

      An IBM personal computer (80386 or better) is recommended.  For
      improved performance, it is highly recommended that the user obtain
      at least three megabytes of extended memory.  A color monitor and a
      mouse are also recommended.

      Considerable effort was expended to make the user reference manual as
      complete as possible.  However, this documentation is in no way to be
      considered an instructive guide to MS-DOS or Foxpro.  Many reference
      texts are available on the market that explain the MS-DOS operating
      system and Foxpro programming.  If you need more information, your
      reference materials should include one of these texts.

      My advice is to read the contents of this user manual.  Familiarize
      yourself with its information.  If you have any questions concerning
      this application, feel free to write or call.































                                     - Page 1 -







                             Copyright/License/Warranty




      This document and the program Shell ("the software") are  copyrighted
      by the author.  The copyright owner hereby licenses you to use the
      software given these restrictions:


           o  the program shall be supplied in its original, unmodified
              form, which includes this documentation;

           o  for-profit use without a license is prohibited;

           o  the program may not be included - or bundled - with other
              goods or services.  Exceptions may be granted upon written
              request only.

           o  no fee is charged beyond a reasonable amount for the media
              and handling ($10 maximum suggested);


           There is no warranty of any kind.  The copyright owner may not
           be held liable for any damages, including any lost profits or
           other incidental or consequential damages arising out of or
           inability to use the software.  By using the software, you agree
           to this.


      Shareware

           Shell is distributed as Shareware.  It is not free software.
           You are free to try it and make copies for others.  If you
           continue to use this application beyond a reasonable trial
           period, you are required to register it with the distributor
           and author.


      ASP Ombudsman

           This program is produced by a member of the Association of
           Shareware Professionals (ASP).  ASP wants to make sure that the
           shareware principle works for you.  If you are unable to resolve
           a shareware-related problem with an ASP member by contacting the
           member directly, ASP may be able to help.  The ASP Ombudsman can
           help you resolve a dispute or problem with an ASP member, but
           does not provide technical support for members' products.

           Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
           MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
           via CompuServe Mail to ASP Ombudsman 70007,3536.



           Copyright (C) 1993 Dennis Allen.  All rights reserved.  All
           trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


      Preface                                                    1
      Copyright/License/Warranty                                 2
      Introduction                                               5
          Manual Content                                         5
          Notation Convention                                    6
      Invoking Shell                                             7
          Protected Mode                                         7
      Creating Sample Records                                    9
          Creating a Shell Record                               13
          Creating a User Password Record                       14
          Quit                                                  15
      Printing Foxpro Shell                                     16
          Printing Shell Records                                16
          Quit                                                  17
      System Setup                                              18
          Expression Builder                                    18
          Printer Control Codes                                 19
          Change Color Set                                      22
              Customizing Color Sets                            22
          Problems & Suggestions                                22
          All About...                                          23
          Display/Print Manual                                  24
          Quit                                                  24
      Utilities                                                 25
          Rebuilding Indices                                    25
          Initializing Databases                                26
      Quit to DOS                                               27




























                                     - Page 3 -







                                  TABLE OF CONTENTS


      Appendices                                                28
          Appendix A/ Generic Editor                            28
          Appendix A-1/ System Menu                             35
              Sysmenu edit                                      35
              Foxpro Calculator                                 35
              Foxpro Calendar                                   35
              Foxpro DOS Shell                                  36
              Printer Eject                                     36
              Video Mode                                        36
              Print Mode                                        36
          Appendix B/ Data Files                                37
              Backup/Restore Data files                         38
          Appendix C/ Error Handling                            39
              Disk Space                                        39
              Printer not Ready                                 39
              Multi-User Errors                                 40
              Syntax Error                                      40
          Appendix D/ Configuring Application                   41
              Foxpro Runtime Unit                               41
                  FOXR.EXE                                      41
                  FOXRW.EXE                                     42
              CONFIG.FP                                         42
                  EMS                                           43
                  MEMLIMIT                                      43
                  PROGWORK                                      43
                  RESOURCE                                      44
                  TIME                                          44
              FOXPRO.INI                                        45
                  DATA                                          45
                  FONTNAME                                      46
                  FONTSIZE                                      46
                  FONTSTYLE                                     46
                  INIT                                          47
                  LAST                                          47
                  MULT                                          47
                  PROG                                          48
                  RECALL                                        48
                  SYSMENU                                       48
                  TEMP                                          49
                  TERM                                          49
              FOXUSER.DBF                                       50
              FOXUSER2.DBF                                      50
              Printer Codes                                     51
              Record Filters                                    51
              Configuring Sideways                              51
      Glossary                                                  52
      Index                                                     55








                                     - Page 4 -







                                    Introduction


      The Shell System is an application that will allow the user to launch
      selected and password protected Foxpro applications.  Shell itself is
      written in the dBASE IV compatible language called Foxpro.

      Before continuing, we should explain a couple of terms.  We will
      refer to our Foxpro Shell System simply as "Shell".

      When we refer to an "editor", it is a program module that allows us
      to add, delete, or change database records. The word "edit" means to
      update, maintain, or change a database record.

      When we refer to a "window", it is a section of the screen that is
      receiving output.  Windows may overlap each other on the screen.
      They are characterized by a double line border and usually have some
      sort of title.

      A "record filter" determines the access allowed to a database.  Only
      those records, defined by a record filter, may be viewed, edited, or
      printed.  Record filters are created/selected using an "expression
      builder".

      Finally, when we say "DOS", we refer to the disk operating system.
      It's usually MS-DOS, but could be Microsoft windows, UNIX, or even
      the Macintosh OS.

      The following sections of this manual will describe all available
      menu options, one at a time.  Each menu option will be illustrated.
      Appendices are included to describe all the files in the Shell
      system, the generic operations of editors, error handling, optimizing
      Shell, and establishing a backup procedure.

























                                     - Page 5 -







                                    Introduction


                              Notation Conventions


      CAPITAL LETTERS

           Capital letters indicates a command.  During command entry, this
           text should be entered exactly as it appears.  Unless specified,
           any command may be in upper or lower-case letters.

      lower case

           Parameters to commands are usually typed in lower-case
           characters.

      Ellipsis "..."

           The ellipsis represent repetition of a previous item.

      Single Key "[ ]"

           The single key command is represented by the characters "[" and
           "]".

      Control keys

           Control keys are designated with a "[Ctrl]-" followed by the
           name of another key (for example: [Ctrl]-[S]).  To enter a
           control key, press [Ctrl] on your keyboard and, while holding it
           down, press the additional key.  On some Foxpro menus, control
           keys are designated with a "^" followed by the name of another
           key (for example: ^[End] for [Ctrl]-[End]).

      Carriage Return

           Depending on your keyboard, the same key may be represented by
           different descriptions.  For example, the carriage return may be
           represented as [Enter], [Return], or [Bent arrow symbol].  For
           the most part, this should not be a problem.  Make sure,
           however, that you understand the function of each key so that
           you understand how they appear in this manual.

      Alternate key

           On an IBM PC keyboard, alternate keys are designated with a
           "[Alt]-" followed by the name of another key (for example:
           [Alt]-[V]).  To enter a control key, press [Alt] on your
           keyboard and, while holding it down, press the additional key.

           On a Macintosh keyboard, [Alt] is produced by holding down both
           the [Ctrl] key and the [Option] key.  To produce [Alt]-[V], for
           example, you must press [Ctrl], [Option], and [V] at the same
           time.



                                     - Page 6 -







                                Invoking Shell System


      The purpose of this section is to help you get started using Shell.
      Your computer should be running and you should be at the DOS prompt.

      You should have already installed the Shell application and the
      Foxpro runtime unit.  You should also have a functional backup
      procedure (See Appendix B).  To invoke Shell, at the DOS prompt,
      type:

           SHL

      and press [Enter].

                                 Protected Mode

      Normally, you would begin in the protected mode.  In the protected
      mode, you are given a list of Foxpro applications.  You would select
      an application and press [Enter].  If the application has been given
      a password, you would be prompted for a password.  Until you enter
      the correct password, you will not be able to invoke the selected
      application.

      However, since you just installed Shell, you will enter the Shell
      main menu.  You should see is the following screen:


      +--------------------------------------------------------------------+
                              Foxpro Shell, Version 01.00.00
                       (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       -----------------------  M A I N    M E N U -----------------------
      |                                                                    |
                           E - Edit  Shell List
      |                                                                    |
                           P - Print Shell List
      |                                                                    |
                           R - Return to Protected Mode
      |                                                                    |
                           S - System Setup
      |                                                                    |
                           U - Utilities
      |                                                                    |
                           M - Change Status (Single-User)
      |                                                                    |
                           Q - Quit this program
      |                                                                    |
      |--------------------------------------------------------------------|
                                Make a selection:
      +--------------------------------------------------------------------+







                                     - Page 7 -







                                Invoking Shell System


      This is our initial screen.  Option 'E' allows you to create and
      maintain all Foxpro shell records.  Option 'P' will print Foxpro
      shell reports.  Option 'R' returns you to the protected mode.  Option
      'S' allows you to change printer codes.  Option 'U' contain
      miscellaneous options that allow you to maintain Shell.  Option 'Q'
      will return you to the DOS prompt.

      By default, Shell runs in a single-user mode.  Option 'M' is
      available only in multi-user mode.  If you are running in a Multi-
      user environment, you will need to configure Shell to run Multi-user
      mode.  Please refer to Appendix D for more information.

      There are a couple of ways to select an option.  One way is to simply
      press the highlighted key, (example: press [S] for system setup).
      Another way is to press the up and down cursor keys to highlight the
      desired option.  Then, by pressing [Enter], the highlighted option is
      selected.

      Note:  If you have a mouse, you can move the mouse cursor to the
      desired option.  Pressing the left mouse button will then select the
      option.


































                                     - Page 8 -







                                Invoking Shell System




                             Creating Sample Records


      First, we need to create sample data.  At the main menu, press [E].
      You should see the following screen:


      +--------------------------------------------------------------------+
                          Foxpro Shell, Version 01.00.00
                    (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Create/Edit Shell List
                          2 - Create/Edit User  List
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      This is the edit menu.  Here, all components of the Foxpro shell
      system can be maintained.  Option '1' will allow you to maintain
      application records.  Option '2' will allow you to maintain user
      passwords.  Option 'Q' will return you to the main menu.

      Before continuing, notice that the edit window is slightly smaller
      than the main menu window.  This is a built-in feature.  This feature
      allows the user to see how far he/she is into the program.  It is
      intended to give the user a sense of depth.





















                                     - Page 9 -







                           Creating a Foxpro Shell Record


      Defining Foxpro application records is simple.  At the edit menu,
      press [1].  The following screen will appear:


      +--------------------------------------------------------------------+
                            Foxpro Shell, Version 01.00.00
                        (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------------- Foxpro Shell --------------------------
      |                                                                    |
           Description:
      |                                                                    |
           File Path:
      |                                                                    |
           File Name:
      |                                                                    |
      |--------------------------------------------------------------------|
              Edit User Passwords
                                          Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      This screen is typical of a generic editor used with Foxpro.  At the
      bottom of the screen are all the one-character options available to
      the user.

      Like the main menu, there are three ways of selecting a function.  By
      direct keystroke, by the cursor keys and [Enter], or by the mouse.
      Before continuing, we will briefly describe each function.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.
      Whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the Enter key,
      moves the cursor forward one field at a time.  The up arrow moves the
      cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      it is already there, [Home] will move the cursor to the first field
      in the screen.  [End] will move the cursor to the end of the field.
      If it is already there, [End] will move the cursor to the last field
      in the screen.



                                     - Page 10 -







                           Creating a Foxpro Shell Record


      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

      Note:  If you have a mouse, move the mouse cursor to the desired
      field.  Press the right mouse button, once to move to the field, and
      once for the help text.

      After you have entered your data, moving the cursor beyond the last
      input field on the screen tells the editor to accept the record.  You
      can either use the arrow keys to move the cursor, or press [F10].
      [Esc] will abort any updating, returning the screen to its original
      condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit on one
      screen.  You use the arrow keys to move from record to record.
      Pressing [F10] will return you to the edit screen.  The browse
      function is explained in more detail in Appendix A.

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                               Edit User Password

      Pressing [E] will allow you to add, delete, or update passwords to
      the current application.  See "Edit User Records" later in this
      manual.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is a quick
      way of finding a desired record.  Since the current database is
      indexed by description, this option will prompt you for the
      description.  Type the desired description and press [Enter].  If
      found, the desired record will be displayed.  You could then delete
      it, or update it.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.
      The goto function is explained in more detail in Appendix A.




                                     - Page 11 -







                           Creating a Foxpro Shell Record


                                  Help Function

      Pressing [H] will display a summary of commands used in the edit
      menu.  Pressing any key after that returns you to the edit menu.

                              Toggle Index Function

      For a database with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

      For example, pressing [T] will change the current index.  Upon
      pressing [F], the user will be prompted with the new index.  Pressing
      [T], repeatedly, will eventually return you to the original index.

      Note:  The Foxpro Shell database has only one index.  Therefore, the
      toggle option is not available.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by
      description, then 'ALPHA' will come after 'BETA'.  Pressing [O] again
      will change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, pressing [F10] will complete the update.
      Pressing [Esc] will abort the update.

                                  Quit Function

      Finally, pressing [Q] will return you the menu that invoked the
      editor.  For more information on the capabilities of this type of
      editor, see Appendix A.















                                     - Page 12 -







                           Creating a Foxpro Shell Record



                             Creating a Shell Record


      Now that you have an idea how the editor works, you can define
      application records.  An application record has a description, a file
      path and a file name.  Each record needs a unique description.  The
      file path is where the application directory is located.  The file
      name is the starting procedure name (no file extension).

      Note:  For the startup procedure name, check you application startup
      batch file.  The name is usually the lastcouple of characters of the
      FOXR command line.

      To create a shell record, your application should already have been
      installed.  Let's say, for example, that dMAIL4 was installed.  You
      would press [A] to add a record.  You would type "dMAIL4" and press
      [Enter] for the description.  You would type "C:\DMAIL4" and press
      [Enter] for the file path.  Finally, you would type "MAL" and press
      [Enter] for the startup procedure name.  You would be prompted for
      another record.  Pressing [Esc] aborts the add function.

      For our purposes, however, we don't need to add a record.  The first
      time you invoked Shell, an application record was created was created
      for you.  This record is the Shell System itself.  So the next time
      you invoke the Shell System, the protect mode will list "Foxpro
      Shell" as an application.




























                                     - Page 13 -







                           Creating a User Password Record


      Now that you have an application, you can attach a password to it.
      The "Foxpro Shell" record should be displayed.  At the shell editor,
      press [E].  You should see the following screen:


      +--------------------------------------------------------------------+
                            Foxpro Shell, Version 01.00.00
                        (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------ User ID Editor ---------------------------
      |                                                                    |
                     Description:
      |                                                                    |
                     User ID:
      |                                                                    |
                     Password:
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                                         Toggle Order (Ascending)
             Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      The edit functions are exactly the same as in the Foxpro shell
      editor.  Press [A] to add.

      A user password record consists of the application description, a
      user id, and a password.  Since this editor was invoked from the
      shell editor, you will not be prompted for a description.

      The user ID field allows you to define passwords to individual users.
      For example, a user id "MARK" could have a password "MASTER" to
      invoke the Foxpro Shell System.  Another user, "JANE" could have a
      password "JANE" allowing her to invoke the Foxpro Shell System.

      For our example, however, we will press [Enter] for a blank User ID.
      Type "MASTER" and press [Enter] for the password.  You will be
      prompted for another record.  Press [Esc] to abort the add function.


      Note:  A blank user ID means that the protected mode will not prompt
      for a user ID.  That is, anyone can type "MASTER" to invoke the Shell
      application.


      Since we do not to add any more passwords, press [Q] to return to the
      shell editor.  Since we need not add any more applications, press [Q]
      to return to the edit menu.






                                     - Page 14 -







                           Creating a User Password Record


                                      Quit


      Option [2] of the edit menu will invoke the user ID editor.  This is
      the same editor as option [E] of the shell editor.  In this editor,
      however, you have a user ID index as well as a description index.
      You also need to specify an application description from a list of
      descriptions.

      Experiment with the user ID editor, if you wish.  Later, you can
      experiment with finding, deleting, and updating records.  For now,
      simply press [Q] to return to the main menu.

      Before we quit, let's try out our new password.  At the main menu,
      press [R] to return to protected mode.  In the protected mode, select
      the application "Foxpro Shell" and press [Enter].  You should be
      prompted for a password.  Type "MASTER" and press [Enter].  If you
      did everything correctly, you should be back at the Shell main menu.





































                                     - Page 15 -







                                 Print Foxpro Shell


      In the first half of this manual we learned how to create a Foxpro
      shell and user records.  Now we are going to learn how to print these
      records.

      From the previous examples, you should now be at the main menu.  We
      will be printing a record, so make sure your printer is connected and
      on-line.  If not, you may wish to skip this section.  If your printer
      is ready, press [P].  You should see the following screen:


      +--------------------------------------------------------------------+
                           Foxpro Shell, Version 01.00.00
                      (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       ------------------------- P R I N T    M E N U --------------------
      |                                                                    |
                           1 - Print Shell   Edit List
                           2 - Print User ID Edit List
      |                                                                    |
                           Q - Return to main menu
      |                                                                    |
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      The menu is simple and self-explanatory.  Option '1' allows you to
      print application record.  Option '2' will print user ID records.
      Option 'Q' will return you to the main menu.


                             Printing Shell Records


      Option '1', of the print menu, introduces the concept of the option
      grid.  At the print menu, press [1].  You should see the following
      screen:

















                                     - Page 16 -







                                 Print Foxpro Shell


      +--------------------------------------------------------------------+
                          Foxpro Shell, Version 01.00.00
                    (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       ---------------------- Mailing Labels --------------------------
      |                                                                    |
           Description:
      |                                                                    |
           File Path:
      |                                                                    |
           File Name:
      |                                                                    |
            Index File:                    Order:
      |--------------------------------------------------------------------|
                  Print   Screen    Help   Update    Quit
      +--------------------------------------------------------------------+


      You are given an option grid.  The option grid will look like the
      Shell edit window.  The option grid prompts will determine what
      records will be printed and in what order.  For example, specifying
      "D:" for file path will print all application installed on drive D.

      From this option grid, you are also allowed to select the index file
      and index order.  These field are the push button equivalent to the
      toggle index/toggle order found in the Foxpro shell editor.

      Press [F10] to complete the option grid.  You will be given a menu of
      choices, depending on the report.  You can press [U] to update the
      option grid.  You can press [H] for help, or press [Q] to quit to the
      print menu.

      Pressing [S] for screen mode, or [P] for print mode, will start
      creating a print file.  During this operation, you can abort by
      pressing [Esc].

      If you pressed [S], you will see the report displayed upon the
      screen.  Press [Pgup] or [Pgdn] to view the report.  Press [Esc] or
      [F10] to return to the option grid.

      Pressing [P] will copy the report to the printer.  When you are
      finished, press [Q] to return to the print menu.

      Note:  If you need to adjust the printer device, printer controls,
      label widths, or label lengths, use option S of the main menu.  See
      System setup.


                                      Quit


      Option '2' of the print menu provides the same prompts as option '1'.
      If you wish, try printing user records.  When you have experimented
      enough, press [Q] at the print menu to return to the main menu.

                                     - Page 17 -







                                    System Setup


      Option 'S' of the main menu offers several facilities.  Among them,
      the ability to change printer control codes.  Upon pressing [S] at
      the main menu, you should see the following:


      +--------------------------------------------------------------------+
                              Foxpro Shell, Version 01.00.00
                       (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  S Y S T E M   S E T U P  ---------------------
      |                                                                    |
                           1 - Edit Expression Builder
                           2 - Edit Printer Control Codes
                           3 - Change Color Set
                           4 - Problems & Suggestions
                           5 - All about...
      |                                                                    |
                           M - Display/Print Manual
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option '1' will invoke the expression builder.  The expression
      builder creates a record filter.  A record filter defines those
      records that can be viewed, edited, and printed.

      Option '2' allows you to change printer control codes.

      Option '3' will allow you to change the current color set.  If you
      don't like the colors used by Shell, this option lets you change
      them.

      Option '4' will allow you to leave a message to the application
      author.  Messages can point out a problem or can offer a suggestion.

      Option '5' will display status information about this application.
      What version of Foxpro is running and about much memory is available.

      Option 'M' allows you to display and/or print the user manual.
      Option 'Q' returns you to the main menu.


                               Expression Builder


      The expression builder allows you to select a record filter from a
      list of record filters.  A record filter defines those records in a
      database that can be viewed, edited, or printed.  The record filter
      is in effect only while your application is running.  Filters can be
      redefined as often as desired.

                                     - Page 18 -







                                    System Setup



      Note:  In this application, filters will be created and used for the
      user ID database.

      At the system setup menu, press [1].  Upon entry, you are given a
      list of existing record filters.  Chose an existing filter.  For
      example, move the cursor to the filter named "Blank user ID".  Press
      [Enter].  The filter "Blank user ID" is now active and will allow you
      to view only those records with a blank user id.  In other words,
      application passwords.

      You also might want to create a record filter.  At the system setup
      menu, press [1].  Press [F10] for the menu and press "N" to create an
      expression.  Enter "Dennis Allen" for the name of your expression.
      You will be given a choice of the custom expression builder, or the
      Foxpro expression builder.  Unless you know how to use the Foxpro
      expression builder, select the custom builder.

      You will be given a popup list of available field names.  Select the
      field "User ID".  The next popup will display the action that can be
      taken on "User ID".  Select the popup "Contains".  Now you will be
      prompted for a character string.  Type "Dennis Allen" and press
      [Enter].

      The record filter is displayed.  You may add, delete, or edit phrases
      in the expression.  But just press [F10] to accept the current one.

      That's all there is to it!  You've created a filter that views only
      passwords belonging to the user "Dennis Allen".  Press [Enter] to
      select the filter.  You will be returned to the system setup menu.
      If you don't want to use this filter, simply return to the expression
      builder and press [Esc] to abort.

      Note:  If you are running on a network, see Appendix D:  Record
      filters.


                              Printer Control Codes


      At the setup menu, press [2].  The following screen will be
      displayed:













                                     - Page 19 -







                                    System Setup


      +--------------------------------------------------------------------+
                           Foxpro Shell, Version 01.00.00
                      (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------- S Y S T E M   S E T U P ---------------------
      |                                                                    |
                     Printer Name         : Default
                     Printer Device       : PRN
                     Printer Default      : CHR(27)+"@"
                     Printer 10 cpi       :
                     Printer 12 cpi       :
                     Printer Condense On  :
                     Printer Bold      On :
                     Printer Bold      Off:
                     Printer Underline On :
                     Printer Underline Off:
      |                                                                    |
                     Number of Straight Lines/Page:
                     Number of Sideways Lines/Page:
      |                                                                    |
                     Print in Draft mode?
      |--------------------------------------------------------------------|
               Press [ESC] to abort and return to main menu...
      +--------------------------------------------------------------------+

                                  Printer Name


      The printer name is simply identifies the current configuration.  If
      the database P_CODES.DBF is available, you may press [F1] for a list
      of all available printers.  A selection changes all printer codes to
      the selected printer.  Press [F10] to complete the screen.

                                 Printer Device

      The printer device defines where output is to be sent.  Typically,
      you would use LPT1 or LPT2.  In the Multi-user environment, this
      option also allows you to define the network spooler.

















                                     - Page 20 -







                                    System Setup


                                  Printer Codes

      If you have an 80 column printer, define the control codes required
      by your printer to invoke compressed printing.  These control codes
      are sometimes referred to as 16.7 or 17 characters per inch.  Also
      define the control codes required to cancel condensed printing.
      These control codes are sometimes referred to as the default.  Shell
      will use these codes for reports normally requiring a 132 column
      printer.  Printer control codes are specified with dBASE expressions
      such as:

      CHR(27) + CHR(64)

      or:


      CHR(27) + '@'

      In general, most printer manuals give printer control strings as
      BASIC programming statements using the BASIC function CHR$().  The
      dBASE CHR() function is identical, so simply removing the "$" sign
      from the examples in your printer manual should do the job.

      Note:  If you press [F1], you will see a browse popup of available
      printers.  Simply select your printer and press [Enter].  All printer
      codes will be converted to the selected printer.

                             Straight lines per page

      To this day, there are some printers that do not accept form feeds.
      So rather than asking for form feed code, Shell asks for the number
      of lines per page.  Most printers use 66 lines.  Laser printers
      usually need 57 lines.

                                    Sideways

      It is sometimes necessary to print large reports using a sideways
      print utility.  So in case it is ever needed, the system setup
      prompts for the number of lines to print sideways.  For an 80 column
      printer, use 53 lines. For a 132 column printer, use 90 lines.

                                   Draft mode

      A report option grid creates a report file.  From the option grid,
      there are two ways to print this file:  Regular mode and draft mode.
      In regular mode the report file is read and printed, one line at a
      time.  The user may press [Esc] to abort.  If the printer becomes
      off-line, the user can usually restart at the point of interruption.

      In draft mode, the report file is copied directly to the print
      device.  In MS-DOS windows, draft mode will bypass the print spooler.
      Draft mode, however, does not allow the user to press [Esc] or nor
      does it allow the user to restart a print job.


                                     - Page 21 -







                                    System Setup


      The mode you use depend on your needs.  Regular mode is the most
      reliable method.  Under MS-DOS windows, draft mode is the quickest.


                                Change Color Set


      A Foxpro color set defines all color attributes used by this
      application.  Upon pressing [3] at the system setup, a popup menu
      will display all the different color sets available.  These color
      sets reside within the Foxpro resource file (FOXUSER.DBF).  Use the
      cursor keys to highlight the desired color set.  Then, select by
      pressing [Enter].

                             Customizing Color Sets


      A new feature has been added to the color selector.  The user now has
      the ability to customize colors.  Once a color has been selected, the
      color selector will search for a second Foxpro resource file
      (FOXUSER2.DBF).  In this file, color sets are stored in ASCII text
      format.

      If you are a system administrator, you will be prompted whether to
      edit the ASCII text of your selected color set.  The text layout is
      simple.  Twelve lines for the twelve color schemes used by this
      application.  Each line contain ten color pairs.  A color pair
      "W*/B+", for example, would denote a white foreground, blue
      background ("*" denotes blinking and "+" denotes intensity).  For a
      description of color pairs used within a scheme, check the color
      picker portion of the Foxpro manual.

      Experiment with different color sets.  Note that the top of the
      screen may not change color until you exit and reenter the
      application.  Be warned, however.  The color set becomes permanent
      until the next time you select a different color.

      Note:  The second Foxpro resource file can only be created and edited
      by the system administrator.


                             Problems & Suggestions


      Upon pressing [4], you will be presented with a memo window.  Type
      any message you wish to leave the application programmer.  Press
      [F10] to complete the message, or [Esc] to abort.  Your message will
      be placed in the Foxpro error file (FOXERR.DBF).

      If you have already created messages, you may wish to modify them.  A
      browse, indicating the date and time of each message, will be
      displayed.  Select the desired message record.  Then, press [Ctrl]-
      [Pgdn] to expand the message window.


                                     - Page 22 -







                                    System Setup



                                  All About...


      Option '5', of the system menu, will display status information about
      this application.  What version of Foxpro is running, about much
      memory is available, and the different kinds of application modes
      (Multi-user, debug, system administration).  This option will also
      tell you how the various data paths are defined.














































                                     - Page 23 -







                                    System Setup


                              Display/Print Manual



      Option 'M', of the system menu, will display the user manual.  You
      may use [PgUp] or [PgDn] to view various pages.  You may print the
      entire user manual by pressing [Alt]-P].  Press [Esc] to return to
      the system setup menu.


                                      Quit


      Before leaving the system setup menu, a reminder.  Record filters
      remain in effect only for the duration of the application.  Color
      sets and printer control codes, on the other hand, are permanent.
      When you have experimented enough, press [Q] at the system setup menu
      to return to the main menu.





































                                     - Page 24 -







                                      Utilities


      Option 'U' of the main menu provides the miscellaneous options needed
      to maintain the Foxpro shell system.  Upon pressing [U] at the main
      menu, you should see the following:


      +--------------------------------------------------------------------+
                              Foxpro Shell, Version 01.00.00
                       (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       -------------------  U T I L I T Y    M E N U ---------------------
      |                                                                    |
                           A - Rebuild indices
                           B - Initialize Databases
      |                                                                    |
                           Q - Quit this Menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                 Your selection:
      +--------------------------------------------------------------------+


      Option 'A' reconstructs all system indices in the event of a crash or
      other strange system behavior.  Option 'A' also removes deleted
      records, thereby reclaiming disk space.

      Option 'B' will allow you to reset any or all database files in the
      Shell system.  Option 'Q' will return you to the main menu.

      Note:  Options 'A' and 'B' are available only in single-user mode.
      Option 'B' is only available to the system administrator.  See
      Appendix D.


                               Rebuilding Indices


      Option 'A' of the utility menu will reconstruct all system indices in
      the event of a crash or other strange system behavior.  You will be
      prompted whether to continue.  Upon pressing [Y], all indices will be
      rebuilt.  Option 'A' also removes deleted records, thereby reclaiming
      disk space.  You will then be returned to the utility menu1.











      ____________________
      1 Not available in Multi-user mode.  See Appendix D.

                                     - Page 25 -







                                      Utilities



                             Initializing Databases


      Option 'B' of the utility menu will allow you to "reset" any or all
      database files in the Shell system by removing all data from them.
      You probably will want to use this option after completing the sample
      entries and exercises in this manual, so you can begin fresh with
      "real" data.

      Upon press [B] at the utility menu, you will be prompted whether to
      reset each database file, one at a time.  You will then be returned
      to the utility menu2.

      When you have experimented enough, press [Q] at the utility menu to
      return to the main menu.




































      ____________________
      2 System Administration function only.  See Appendix D.

                                     - Page 26 -







                                     Quit to DOS


      Once you have returned to the main menu, press [Q] to return to the
      DOS ready.  It is VERY important that you do not leave the Shell
      System without returning to DOS.  NEVER turn off the machine while in
      the Shell system.  Doing so may result in file corruption and lots of
      headaches to us developers.

      This concludes the system overview.  If you wish to know more about
      the Foxpro shell editor, or any other editor in the Shell system, see
      Appendix A.  If you wish to know about the file layouts, see Appendix
      B.  If you ever see the infamous error message "Ignore, Retry,
      Suspend, or Quit", see Appendix C.  If you wish to install the multi-
      user mode, see Appendix D.











































                                     - Page 27 -







                                     Appendix A


      This section describes all characteristics, in detail, of the generic
      editor used in this type of Foxpro application.  While this editor
      may be customized for many applications, all share common functions.
      Thus, to learn one version is to know another version.

      This type of Foxpro application usually has an edit menu.  This menu
      allows the user to invoke one or more editors.  The following is an
      example of the edit menu used in the dMAIL4 System:


      +--------------------------------------------------------------------+
                          Mailing List, Version 03.05.00
                    (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       ----------------------  E D I T    M E N U ------------------------
      |                                                                    |
                          1 - Edit Mailing List
                          2 - Edit User IDs
      |                                                                    |
                          Q - Return to main menu
      |                                                                    |
      |--------------------------------------------------------------------|
                                   Your selection:
      +--------------------------------------------------------------------+


      In this edit menu, the user has the option to use two editors.  Each
      editor allows the user to maintain separate, but related, databases
      in the dMAIL4 System.  While we really don't need to go any further,
      but it is good to know where most editors are invoked.

      Once a generic editor is invoked, its window will be displayed.  The
      window consists of a window title, field descriptions, and all fields
      of the database record that happens to be current.  A menu window is
      also displayed.  The menu window contains all the one-character
      options available to the user.  The following is a sample screen of
      the mailing list editor used in the dMAIL4 System:


















                                     - Page 28 -







                                     Appendix A


      +--------------------------------------------------------------------+
                            Mailing List, Version 03.05.00
                        (c) 1993 Dennis Allen, All rights reserved
      |                                                                    |
       --------------------------- Mailing List --------------------------
       User ID:
       First Name:                       Last:
                  Billing                Shipping
       Address 1 :
       Address 2 :
       City/State:
       Zip Code  :
       Sex:          Status:             Head of HouseHold:
       Home: (  )    -                   Birth:
       Work: (  )    -                   Wedding:
       Soc.Sec. #:   -  -                Active Date:
            [ ] MS-DOS    +------------ Message Memo -------------+
            [ ] CP/M      |                                       |
            [ ] TRSDOS    |                                       |
                          +---------------------------------------+
      |--------------------------------------------------------------------|
              Toggle Index (Last Name)    Toggle Order (Ascending)
              Add    Browse Delete Find   Goto   Help  Update   Quit
      +--------------------------------------------------------------------+


      All editors have the same basic functions.  Before continuing, we
      will describe each function in detail.

                                  Add Function

      Pressing [A] will allow you to add a record to the current database.
      The cursor will be positioned on the first field in the record.  Now
      whether adding or updating a record, there only a few keystrokes you
      need to know.

      You can move the cursor from field to field using the arrow keys.
      For instance, the Right arrow, the Down arrow, and the [Enter] key,
      moves the cursor forward one field at a time.  The left arrow and up
      arrow will move the cursor back one field.

      Note:  If you have a mouse, you also can move from field to field.
      Simply move the mouse cursor to the desired field and press the left
      mouse button.

      The [Home] key will move the cursor to the beginning of a field.  If
      the cursor is already there, [Home] will move the cursor to the first
      field in the screen.  The [End] key will move the cursor to the end
      of the field.  If the cursor is already there, [End] will move the
      cursor to the last field in the screen.

      If you need more information on any field, press [F1].  If there is
      help information, a help window will be displayed.  The help window
      will remain until you press either [Esc] or [F10].

                                     - Page 29 -







                                     Appendix A



      Note: By pressing [F1] (then [F10] if there is help text), you may
      invoke another Foxpro editor.  If the current input field is
      validated against another file, the editor of that file will appear.
      Use the Goto option to display the desired record.  Then press [Q] to
      quit.  Your input field will be filled with the corresponding field
      in the chosen record.

      Pressing [Ctrl]-[Home] will repeat the last text that was displayed
      in the current field.  This function provides a convenient means of
      adding many records with similar field descriptions.

      Once you have entered your data, moving the cursor beyond the last
      field on the screen tells the editor to accept the record.  Pressing
      [F10] also will tell the editor to accept the record.  You would then
      be prompted to add another record.  The [Esc] key will abort the add
      function, returning the screen to its original condition.

                                 Browse Function

      Pressing [B] will invoke the Foxpro browse function.  The browse
      function will display as many database records as will fit in one
      window.  You can use the left arrow, right arrow, [Tab], and [Shift]-
      [Tab] keys to move the cursor from field to field.  You can move from
      record to record with the up and down arrow keys.  You use the page
      up/down keys to display the next/previous window of records in the
      current database.

      If you have a mouse, you also can use the characters located on the
      right side of the window.  Place the mouse cursor on the up/down
      arrow characters and press the left button to move one record at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position you in
      the database.

      Mouse Note:  After you found the record you want, place the mouse
      cursor on the record and press the left button.  Otherwise, the first
      time you try to update a record will put you back to the last record
      displayed before using the mouse.

      If there are more fields than can be displayed in one window,
      pressing [TAB] will scroll to the next field.  Pressing [Shift]-[TAB]
      will scroll back one field.

      If you have a mouse, you also may use the characters located across
      the bottom of the window.  Place the mouse cursor on the left/right
      arrow characters and press the left button to move one field at a
      time.  The diamond character show where you're located in relation to
      the rest of the database.  Place the mouse cursor on the diamond and
      press the left button.  Dragging the diamond will re-position the
      fields displayed in the database.



                                     - Page 30 -







                                     Appendix A


      Mouse Note:  After you found the field you want, place the mouse
      cursor on the field and press the left button.  Otherwise, the first
      time you try to update a field will put you back to the last field
      displayed before using the mouse.

      In the browse function you may edit any field as desired.  Press
      [Ctrl]-[N] to add a record from the browse.  Press [Ctrl]-[T] to
      delete the current record from the browse.  When finished, press
      [F10] to return to the edit menu.  Pressing [Esc] also will return
      you to the edit menu, but it will abort any change to the current
      record.

      Note:  The JKEY incremental search has recently been added to the
      browse command.  When performing a browse, press [Ctrl]-[J] to
      activate JKEY.  A search will begin on the current index.  Each new
      keystroke will be added to the search string and the record, closest
      matching to the current string, will be displayed.  You may press
      [BackSpace] to revise the search string, or press [Ctrl]-[Y] to clear
      it.  To abort JKEY, simply press [Ctrl]-[J] once again (or [Esc] to
      abort the browse).

                                 Delete Function

      Pressing [D] will allow you to delete the currently displayed record.
      You will be prompted whether you are sure.  Pressing [Y] deletes the
      record from the database.

                                  Find Function

      Pressing [F] will invoke the find function.  This option is only
      available if a database is indexed.

      If invoked, you would type the key of the desired record, and press
      [Enter].  If found, the record would be displayed.  You could then
      delete it, or update it.


      Note:  The key doesn't have to be a complete description.  For
      incomplete keys, the find function will try to find the record with
      the closet matching key.

      Recently, wild-carding has been introduced into the [F]ind function.
      For example, suppose we have a customer file.  It has an index by
      last name.  When the find function prompts us, we could type:

           Last Name:  ..ll..

      In this example, we are searching for a customer whose last name
      contain a "ll".  In another example:

           Last Name:  ..en

      We are searching for a customer whose last name ends with "en".  In
      one more example:

                                     - Page 31 -







                                     Appendix A



           Last Name:  al..

      We are searching for a customer whose last name begins with "al".

      Here's where wild-carding get interesting.  Let's use the first
      example.  Say we find a customer whose last name contains a "ll".  If
      we use the [G]oto function, we get an extra option.  This option,
      called [C]ontinue, will allow us to find the next customer whose last
      name contains a "ll".

      The continue option will remain in effect until you perform another
      find.  It will search for the next wild-card occurrence no matter
      where you are in the database.  In that sense, think of wild-carding
      as an implicit record filter.

      Oh, a new feature has been added to wild-carding:  The triple period
      "...".  Like the double period "..", the triple period denotes wild-
      carding.  Using the triple, however, will also disable the current
      index during the search.

      You see, wild-card searches are a LOT faster when done on an
      unordered database.  So if you are looking for just one record or two
      records, don't care about viewing order, and are using a huge
      database, the triple period might save you valuable time.

                                  Goto Function

      Pressing [G] will create a pop-up menu.  This popup menu allows the
      user to display different records in the current database.  Press [F]
      for the first record in the database.  Press [L] for the last record.
      Press [N] for the next record.  Press [P] for the previous record.
      The goto window remains active until you press [Esc] or [Q] to quit.

      If the current database is indexed, order is defined by the toggle
      order function.  For example, if the current record is customer 5,
      pressing [N] will display customer 6.  If the index order is
      descending, however, pressing [N] will display customer 4.  See
      toggle index order.

      A new option, [W] for window, has been added.  Pressing [W] activates
      the goto window.  The user may then move the goto window to any
      location on the screen.  That location remains in effect for the
      duration of the editor.

      To move the window, press [Ctrl]-[F7].  The goto window border will
      flash.  Press any cursor key to move the window.  Press [Ctrl]-[F7]
      to stop the window from flashing.  Then press [Esc] to resume the
      normal goto prompts.

      Note:  You also may use a mouse to move the goto window.  Press [W].
      Place the mouse cursor on the border of the goto window.  Press the
      left button.  Drag the mouse cursor (and window) to the desired
      location.  Then, press the right button to resume the goto prompts.

                                     - Page 32 -







                                     Appendix A



                                  Help Function

      Pressing [H] will display a summary of commands used in the edit menu
      as in the following screen.  Pressing any key after that returns you
      to the edit menu.


          Command prompt

          [T]oggle Index -  Change Index used by [F]ind command
          Toggle [O]rder -  Current Index in Ascending/Descending Order

          [A]dd        -  Add a record to the current database
          [B]rowse     -  List all records a page at a time
          [D]elete     -  Delete the currently displayed record
          [F]ind       -  Search database for record with specified key
          [G]oto       -  Display the First, Last, Next, or Previous record
          [H]elp       -  Display help information
          [R]ecall     -  Recall Deleted Records
          [U]pdate     -  Update the currently displayed record
          [Q]uit       -  Return to calling program

          Common full screen keystrokes

          [ESC]        -  Abort operation, return to prompt/menu
          [HOME]       -  move cursor to beginning field
          [END]        -  move cursor to ending field
          [CTRL][HOME] -  repeat last input field completed
          [CTRL][END]  -  Complete operation, return to prompt/menu
          [F1]         -  Display Help text/call another editor
          [F10]        -  Complete operation, return to prompt/menu























                                     - Page 33 -







                                     Appendix A



                                 Recall Function

      Pressing [R] allows you to recall a deleted record.  You will be
      presented with a browse window of all deleted records.  Simply locate
      the record to be recalled and press [Enter].

      Note:  If the current database has no deleted() index, you will be
      prompted for the record key (just like the find function).  Type the
      key of the record to be recalled and press [Enter].  If the deleted
      record is found, it is made active again.


                              Toggle Index Function

      For databases with multiple indices, the toggle option will be
      displayed.  The toggle option allows the user to change what index
      will be used with the [F]ind option.  The current index is displayed
      in parenthesis.

                              Toggle Order Function

      This option toggles the order of the current index.  The current
      order is displayed in parenthesis.

      For example, if the current order is ascending, pressing [O] will
      toggle the order to descending.  If the current index is by last
      name, then 'ALPHA' will come after 'BETA'  Pressing [O] again will
      change the current index back to ascending.

                                 Update Function

      Pressing [U] allows you to update the currently displayed record.
      Like the add function, moving the cursor past the last field will
      complete the updating.  Pressing [Esc] will abort any update.

                                  Quit Function

      Finally, pressing [Q] will quit the editor.  You will be returned to
      the menu that invoked the editor.















                                     - Page 34 -







                                    Appendix A-1




      If you ever been on an input field, you may have noticed that
      pressing [Alt] displays a menu at the very top of the screen.  This
      is called the system menu, or sysmenu for short.  The system menu
      displayed is a customized version of the Foxpro sysmenu.  It contains
      a variety of functions and is available to all users.  The following
      describes only a few features available through the sysmenu.  For
      more information, see the Foxpro users manual.


                                  Sysmenu edit


      The sysmenu edit popup is very powerful.  It gives any input field a
      variety of edit functions.  For example, highlighting a section of
      text ([Shift] and cursor key) and pressing [Del] will delete this
      text.  But [Ctrl]-[C] would have copied this text into the clipboard.
      You would then use [Ctrl]-[V] to paste this text.

      Note:  The sysmenu edit popup provides a [Ctrl]-[U] option to undo a
      deletion, copy, cut, or paste.

      Another example:  Suppose you are editing a memo field.  The sysmenu
      edit popup provides a [Ctrl]-[F] option to find specified text.  This
      popup also provides a [Ctrl]-[G] option to repeat the last find.

      There are other functions in the sysmenu edit popup.  See the Foxpro
      users manual for details.


                                Foxpro Calculator


      Simply enter a numeric value on any input field.  Press [Alt]-[F4] to
      activate the Foxpro calculator.  The Foxpro calculator will display
      your numeric value.

      When you have a new calculated value, press [Ctrl]-[F4] to deactivate
      the calculator.  Your new numeric value will be placed into the
      current input field.

      Note:  If you just want the calculator, press [F4].  But you must be
      on an input field to invoke [F4].


                                 Foxpro Calendar


      Simply enter a date on any input field.  Press [Alt]-[F5] to invoke
      the Foxpro calendar.  The Foxpro calendar will display the year,
      month, and day of the specified date.



                                     - Page 35 -







                                    Appendix A-1


      Select any desired date.  When you have a new date, press [Ctrl]-[F5]
      will deactivate the calendar.  Your new date will be placed into the
      current input field.

      Note:  If you just want the calendar, press [F5].  But you must be on
      an input field to invoke [F5].


                                Foxpro DOS Shell


      In Foxpro for DOS, the system pulldown menu provides a DOS shell.  If
      you are a system administrator, pressing [Alt]-[S] [O] brings up the
      DOS command window.  Type any desired DOS command.  Type 'EXIT' and
      press [Enter] to leave the DOS shell.


                                  Printer Eject


      Press [F7] for a page eject.  A form feed will be sent to the printer
      device, specified in the System Setup.  Very useful for people with
      Laser Printers.

                                   Video Mode


      Press [Alt]-[V] for the video mode.  In Foxpro for DOS, a VGA screen
      will toggle between 25 and 43 line modes.  All subsequent windows
      will conform to the specified mode.  Very useful in displaying
      reports.

      In Foxpro for windows, [Alt]-[V] will display a font selector.  All
      sub-windows, to the current window, will conform to the specified
      font.  If you change the main menu window, the font becomes permanent
      to your application.


                                   Print Mode


      In Foxpro for windows, you can print a report with the current font.
      Send the report to the screen and use the 'Print' option of the
      'File' popup in sysmenu.  'Print' will print the entire contents of
      the current window, fonts and all.  Remember, however, that 'Print'
      will not use your printer codes.

      Note:  'Print' may not be available with the Foxpro for windows
      runtime unit.  To print font reports, obtain the developers copy of
      Foxpro for windows.





                                     - Page 36 -







                                      GLOSSARY


      ANSI  -  American National Standards Institute.  A standard for both
           screen output and keyboard input.

      Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
           labeled with arrows.

      ASCII  -  American Standard Code for Information Interchange.  A
           standard 7 bit code used to represent data.

      Batch File  -  A file containing multiple DOS commands.  These
           commands are executed by DOS, one at a time, as if typed by the
           user.

      Byte  -  A unit of information.  In text form, equivalent to an ASCII
           character.

      Code  -  Program code.  Another way of saying program instructions.

      Compiler  -  A program that converts program code from one form to
           another, usually more primitive, form.  The converted code is
           then ready for execution.

      CONFIG.FP  -  The Foxpro configuration file.  This file tells Foxpro
           where is find the resource file.  On a network, there is a one
           copy for each Foxpro user.

      CONFIG.FPM  -  The Foxpro for Macintosh configuration file.

      CONFIG.FPW  -  The Foxpro for windows configuration file.

      Cursor  -  A flashing character on the screen.  It indicates where
           typed text will be next placed.

      Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
           labeled with arrows.

      Data Dictionary  -  A database file that defines the input/output to
           database files in an application.

      dBASE  -  Popular database management language.  The software package
           dBASE III+ is an interpreter for dBASE code.

      Disk  -  A unit where information is stored.  There are two major
           types: hard disk, and floppy disk.

      Disk Error  -  An error occurring when a program is unable to read or
           write properly to a disk.

      Diskspace  -  A unit of how much room is available on a drive.  It is
           usually measured in bytes.

      DOS  -  Disk Operating System.



                                     - Page 52 -







                                      GLOSSARY


      EMS  -  Refers to expanded memory.  Most 80286 computers have
           expanded memory.  80386 computers have extended memory.  There
           are, however, 80386 software drivers (QEMM for example), that
           can offer either extended or expanded memory.

      Extended  -  Extended memory.  80386 (or better) computers have
           extended memory.  The extended version of Foxpro needs at least
           three megabytes of extended memory.  The standard version of
           Foxpro requires expanded memory.

      Filespec  -  any DOS filename.ext including catalog names, passwords,
           etc.

      Floppy Disk  -  A self contained unit where information is stored.
           Depending on the type, floppy disks are easily transportable.
           Sometimes called a diskette.

      Foxbase  -   A dBASE III plus compatible language.

      Foxpro  -   A dBASE IV compatible language.

      FOXERR.DBF  -  The Foxpro error file.  Every major error event is
           recorded in this file.

      FOXUSER.DBF  -  The Foxpro resource file.  This file stores all the
           attributes of the user.  It also stores all the color sets
           available to Foxpro.  On a network, there is a one copy for each
           Foxpro user.

      Hard Disk  -  A self contained unit where information is stored.
           Usually not removable.

      HELP  -  A facility that provides on-line assistance in the use of a
           given program.

      Highlight  -  A form of a cursor, where an entire field is considered
           the cursor.

      Interpreter  -  A program that executes language code.  Whereas a
           compiler translates program code to executable code, an
           interpreter translates a single line of program code before
           executing it.

      Kilobyte  -  One kilobyte of memory equals 1,024 bytes.

      Megabyte  -  One megabyte of memory equals 1,024,000 bytes.

      Multi-user  -  When more one than one person is capable of
           accessing/updating the same database at the same time.

      MS-DOS  -  Microsoft Disk Operating System.

      Sideways  -  A DOS Utility that will print text up and down instead
           of across the paper.

                                     - Page 53 -







                                      GLOSSARY



      Source Code  -  What a translator/compiler takes in as input.

      Syntax  -  The rules for the arrangement of statements in a
           programming language


















































                                     - Page 54 -







                                        Index


      *.ESL  41                            Creating a User Password Record
      *.ESO  41                                14
      .BAT  37                             Creating Sample Records  9
      .CDX  37                             Cursor  29, 52
      .DBF  37                             Cursor Keys  52
      .FPT  37                             Customizing Color Sets  22
      .FXP  37                             DATA  45
      .PRG  37                             Data dictionary  37, 48, 52
      [Alt]-[F4]  35                       DBASE  52
      [Alt]-[F5]  35                       DBASE IV  1, 5
      [Alt]-[V]  36                        Delete Function  11, 31
      [Ctrl]-[F4]  35                      Disk  52
      [Ctrl]-[F5]  36                      Disk Error  52
      [Ctrl]-[Home]  30                    Disk Space  39
      [Ctrl]-[J]  31                       Diskspace  52
      [Ctrl]-[N]  31                       Display/Print Manual  24
      [Ctrl]-[T]  31                       DOS  5, 52
      [Ctrl]-[Y]  31                       Draft mode  21
      [End]  29                            Edit User Password  11
      [Esc]  30                            Editor  5
      [F1]  29                             EMS  41, 43, 53
      [F10]  31                            Expanded  43
      [F4]  35                             Expression builder  5, 18
      [F5]  36                             Extended  1, 43, 53
      [F7]  36                             Filespec  53
      [Home]  29                           Filter  18
      [Shift]-[TAB]  30                    Find Function  11, 31
      [TAB]  30                            Floppy Disk  53
      Add Function  10, 29                 FONTNAME  46
      All About...  23                     FONTSIZE  46
      ANSI  49, 52                         FONTSTYLE  46
      Appendix A  28                       Foxbase  53
      Appendix A-1  35                     FOXERR.DBF  22, 37, 40, 53
      Appendix B  37                       Foxpro  1, 5, 53
      Appendix C  39                       Foxpro Calculator  35
      Appendix D  41                       Foxpro Calendar  35
      Arrow Keys  52                       Foxpro DOS Shell  36
      ASCII  52                            Foxpro for DOS  36
      BACK  38                             Foxpro for windows  36, 43, 45,
      Backup/Restore Data Files  38            46
      Batch File  52                       Foxpro runtime unit  7, 41
      Browse Function  11, 30              Foxpro runtime unit directory
      Byte  52                                 41
      Change Color Set  22                 FOXPRO.INI  45
      Code  52                             FOXR.EXE  41
      Compiler  52                         FOXRUN  41
      CONFIG.FP  41, 42, 52                FOXRW.EXE  42
      CONFIG.FPM  52                       FOXSWAP.COM  41
      CONFIG.FPW  42, 43, 52               FOXUSER.DBF  22, 37, 50, 53
      Configuring Sideways  51             FOXUSER2.DBF  22, 50
      Copyright/License/Warranty  2        GLOSSARY  52
      Creating a Foxpro Shell Record       Goto Function  11, 32
          10                               Hard Disk  53
      Creating a Shell Record  13          HELP  53

                                     - Page 55 -







                                        Index


      Help Function  12, 33                Resource directory  41
      Highlight  53                        SCR.DBF  37
      Index  55                            Shell  1, 5
      INIT  47                             SHELL.DBF  37
      Initializing Databases  26           SHL  7
      Interpreter  53                      SHLSYS.MEM  37
      Introduction  5                      Sideways  21, 53
      Invoking Shell System  7             SIDEWAYS.COM  51
      JKEY  31                             SIDEWAYS.DFT  51
      Kilobyte  53                         Source Code  54
      Laser Printers  36                   Straight lines per page  21
      LAST  47                             SWSETUP.COM  51
      LIM 4.0  43                          Syntax  54
      Macintosh  6                         Syntax Error  40
      MANUAL  37                           Sysmenu  35, 48
      Megabyte  53                         Sysmenu edit  35
      Megabytes  1                         System administration  47
      MEMLIMIT  43                         System administrator  22, 36, 39
      Memo  22, 37                         System Setup  18
      MODE  39                             TABLE OF CONTENTS  3
      MS-DOS  1, 53                        TEMP  49
      MULT  47                             TERM  49
      Multi-user  20, 53                   TIME  44
      Multi-User Errors  40                Toggle Index Function  12, 34
      Network  20, 41, 47                  Toggle Order Function  12, 34
      Notation Conventions  6              UNBACK  38
      P_CODES.DBF  20                      Update Function  12, 34
      Preface  1                           USER.DBF  37
      Print Foxpro Shell  16               Utilities  25
      Print Mode  36                       Video Mode  36
      Printer Codes  21, 37, 51            Wild-carding  31
      Printer Control Codes  19            Window  5
      Printer Device  20
      Printer Eject  36
      Printer Name  20
      Printer not Ready  39
      Printing Shell Records  16
      Problems & Suggestions  22
      PROG  48
      PROGWORK  43
      Protect mode  13
      Protected Mode  7, 14, 15
      Q*.*  37
      Quit  15, 17, 24
      Quit Function  12, 34
      Quit to DOS  27
      Ramdisk  49
      Rebuilding Indices  25
      RECALL  48
      Recall Function  34
      Record filter  5, 18
      Record Filters  51
      Regular mode  21
      RESOURCE  44

                                     - Page 56 -



