#ifndef __lint
static const char rcsid[] = "@(#) $Header: sfstat.c,v 1.7 94/01/09 16:19:59 deyke Exp $";
#endif

#include <stdio.h>

#include <fcntl.h>
#include <pwd.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "bbs.h"

/* In sfstat.c: */
int main(int argc, char **argv);

/*---------------------------------------------------------------------------*/

int main(int argc, char **argv)
{

  FILE *fp1;
  FILE *fp;
  char buf[1024];
  char host[80];
  char out[2048];
  int fd;
  int i;
  struct index index;
  struct passwd *pw;
  unsigned long cycle;

  cycle = (argc >= 2) ? atoi(argv[1]) : 0;
  if (chdir(WRKDIR)) exit(1);
  for (; ; ) {
    if ((fd = open(INDEXFILE, O_RDONLY, 0644)) < 0) goto next;
    if (lseek(fd, (long) (-sizeof(struct index )), 2) < 0) goto next;
    if (read(fd, (char *) &index, sizeof(index)) != sizeof(index)) goto next;
    if (!(fp = fopen(CONFIGFILE, "r"))) goto next;
    if (cycle)
      strcpy(out, "\033[H\033[J\033H\033J");
    else
      *out = 0;
    while (fgets(buf, sizeof(buf), fp)) {
      if (sscanf(buf, "%s", host) < 1) continue;
      if (!(pw = getpwnam(host))) continue;
      sprintf(buf, "%s/" SEQFILE, pw->pw_dir);
      if (!(fp1 = fopen(buf, "r"))) continue;
      if (fscanf(fp1, "%d", &i) == 1)
	sprintf(out + strlen(out), "%-6s  %5d\n", pw->pw_name, index.mesg - i);
      fclose(fp1);
    }
    fclose(fp);
    write(1, out, strlen(out));
next:
    if (!cycle) exit(0);
    if (fd >= 0) close(fd);
    sleep(cycle);
  }
}

