/* @(#) $Header: crc.c,v 1.5 94/01/14 21:27:53 deyke Exp $ */

#include "global.h"
#include "mbuf.h"
#include "crc.h"

#include "calc_crc.h"

/*---------------------------------------------------------------------------*/

void append_crc_16(bp)
struct mbuf *bp;
{

  char *p;
  int crc = 0;
  int n;
  struct mbuf *last_bp;

  if (!bp) return;
  for (; bp; bp = bp->next) {
    last_bp = bp;
    for (p = bp->data, n = bp->cnt; n; n--)
      crc = (crc >> 8) ^ Crc_16_table[(crc ^ *p++) & 0xff];
  }
  if (!(bp = alloc_mbuf(2))) return;
  bp->data[0] = crc;
  bp->data[1] = crc >> 8;
  bp->cnt = 2;
  last_bp->next = bp;
}

/*---------------------------------------------------------------------------*/

int check_crc_16(head)
struct mbuf *head;
{

  char *p;
  int cnt = 0;
  int crc = 0;
  int n;
  struct mbuf *bp;

  for (bp = head; bp; bp = bp->next) {
    cnt += bp->cnt;
    for (p = bp->data, n = bp->cnt; n; n--)
      crc = (crc >> 8) ^ Crc_16_table[(crc ^ *p++) & 0xff];
  }
  if (crc || cnt < 3) return (-1);
  cnt -= 2;
  for (bp = head; bp->cnt < cnt; bp = bp->next) cnt -= bp->cnt;
  bp->cnt = cnt;
  free_p(bp->next);
  bp->next = 0;
  return 0;
}

/*---------------------------------------------------------------------------*/

static const int Crc_rmnc_table[] = {
  0x0f87, 0x1e0e, 0x2c95, 0x3d1c, 0x49a3, 0x582a, 0x6ab1, 0x7b38,
  0x83cf, 0x9246, 0xa0dd, 0xb154, 0xc5eb, 0xd462, 0xe6f9, 0xf770,
  0x1f06, 0x0e8f, 0x3c14, 0x2d9d, 0x5922, 0x48ab, 0x7a30, 0x6bb9,
  0x934e, 0x82c7, 0xb05c, 0xa1d5, 0xd56a, 0xc4e3, 0xf678, 0xe7f1,
  0x2e85, 0x3f0c, 0x0d97, 0x1c1e, 0x68a1, 0x7928, 0x4bb3, 0x5a3a,
  0xa2cd, 0xb344, 0x81df, 0x9056, 0xe4e9, 0xf560, 0xc7fb, 0xd672,
  0x3e04, 0x2f8d, 0x1d16, 0x0c9f, 0x7820, 0x69a9, 0x5b32, 0x4abb,
  0xb24c, 0xa3c5, 0x915e, 0x80d7, 0xf468, 0xe5e1, 0xd77a, 0xc6f3,
  0x4d83, 0x5c0a, 0x6e91, 0x7f18, 0x0ba7, 0x1a2e, 0x28b5, 0x393c,
  0xc1cb, 0xd042, 0xe2d9, 0xf350, 0x87ef, 0x9666, 0xa4fd, 0xb574,
  0x5d02, 0x4c8b, 0x7e10, 0x6f99, 0x1b26, 0x0aaf, 0x3834, 0x29bd,
  0xd14a, 0xc0c3, 0xf258, 0xe3d1, 0x976e, 0x86e7, 0xb47c, 0xa5f5,
  0x6c81, 0x7d08, 0x4f93, 0x5e1a, 0x2aa5, 0x3b2c, 0x09b7, 0x183e,
  0xe0c9, 0xf140, 0xc3db, 0xd252, 0xa6ed, 0xb764, 0x85ff, 0x9476,
  0x7c00, 0x6d89, 0x5f12, 0x4e9b, 0x3a24, 0x2bad, 0x1936, 0x08bf,
  0xf048, 0xe1c1, 0xd35a, 0xc2d3, 0xb66c, 0xa7e5, 0x957e, 0x84f7,
  0x8b8f, 0x9a06, 0xa89d, 0xb914, 0xcdab, 0xdc22, 0xeeb9, 0xff30,
  0x07c7, 0x164e, 0x24d5, 0x355c, 0x41e3, 0x506a, 0x62f1, 0x7378,
  0x9b0e, 0x8a87, 0xb81c, 0xa995, 0xdd2a, 0xcca3, 0xfe38, 0xefb1,
  0x1746, 0x06cf, 0x3454, 0x25dd, 0x5162, 0x40eb, 0x7270, 0x63f9,
  0xaa8d, 0xbb04, 0x899f, 0x9816, 0xeca9, 0xfd20, 0xcfbb, 0xde32,
  0x26c5, 0x374c, 0x05d7, 0x145e, 0x60e1, 0x7168, 0x43f3, 0x527a,
  0xba0c, 0xab85, 0x991e, 0x8897, 0xfc28, 0xeda1, 0xdf3a, 0xceb3,
  0x3644, 0x27cd, 0x1556, 0x04df, 0x7060, 0x61e9, 0x5372, 0x42fb,
  0xc98b, 0xd802, 0xea99, 0xfb10, 0x8faf, 0x9e26, 0xacbd, 0xbd34,
  0x45c3, 0x544a, 0x66d1, 0x7758, 0x03e7, 0x126e, 0x20f5, 0x317c,
  0xd90a, 0xc883, 0xfa18, 0xeb91, 0x9f2e, 0x8ea7, 0xbc3c, 0xadb5,
  0x5542, 0x44cb, 0x7650, 0x67d9, 0x1366, 0x02ef, 0x3074, 0x21fd,
  0xe889, 0xf900, 0xcb9b, 0xda12, 0xaead, 0xbf24, 0x8dbf, 0x9c36,
  0x64c1, 0x7548, 0x47d3, 0x565a, 0x22e5, 0x336c, 0x01f7, 0x107e,
  0xf808, 0xe981, 0xdb1a, 0xca93, 0xbe2c, 0xafa5, 0x9d3e, 0x8cb7,
  0x7440, 0x65c9, 0x5752, 0x46db, 0x3264, 0x23ed, 0x1176, 0x00ff
};

/*---------------------------------------------------------------------------*/

void append_crc_rmnc(bp)
struct mbuf *bp;
{

  char *p;
  int crc = 0xffff;
  int n;
  struct mbuf *last_bp;

  if (!bp) return;
  for (; bp; bp = bp->next) {
    last_bp = bp;
    for (p = bp->data, n = bp->cnt; n; n--)
      crc = (crc << 8) ^ Crc_rmnc_table[((crc >> 8) ^ *p++) & 0xff];
  }
  if (!(bp = alloc_mbuf(2))) return;
  bp->data[0] = crc >> 8;
  bp->data[1] = crc;
  bp->cnt = 2;
  last_bp->next = bp;
}

/*---------------------------------------------------------------------------*/

int check_crc_rmnc(head)
struct mbuf *head;
{

  char *p;
  int cnt = 0;
  int crc = 0xffff;
  int n;
  struct mbuf *bp;

  for (bp = head; bp; bp = bp->next) {
    cnt += bp->cnt;
    for (p = bp->data, n = bp->cnt; n; n--)
      crc = (crc << 8) ^ Crc_rmnc_table[((crc >> 8) ^ *p++) & 0xff];
  }
  if ((crc & 0xffff) != 0x7070 || cnt < 3) return (-1);
  cnt -= 2;
  for (bp = head; bp->cnt < cnt; bp = bp->next) cnt -= bp->cnt;
  bp->cnt = cnt;
  free_p(bp->next);
  bp->next = 0;
  return 0;
}

/*---------------------------------------------------------------------------*/

static const int Crc_ccitt_table[] = {
  0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
  0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
  0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
  0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
  0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
  0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
  0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
  0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
  0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
  0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
  0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
  0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
  0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
  0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
  0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
  0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
  0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
  0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
  0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
  0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
  0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
  0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
  0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
  0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
  0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
  0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
  0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
  0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
  0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
  0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
  0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
  0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
};

/*---------------------------------------------------------------------------*/

void append_crc_ccitt(bp)
struct mbuf *bp;
{

  char *p;
  int crc = 0xffff;
  int n;
  struct mbuf *last_bp;

  if (!bp) return;
  for (; bp; bp = bp->next) {
    last_bp = bp;
    for (p = bp->data, n = bp->cnt; n; n--)
      crc = (crc >> 8) ^ Crc_ccitt_table[(crc ^ *p++) & 0xff];
  }
  crc ^= 0xffff;
  if (!(bp = alloc_mbuf(2))) return;
  bp->data[0] = crc;
  bp->data[1] = crc >> 8;
  bp->cnt = 2;
  last_bp->next = bp;
}

/*---------------------------------------------------------------------------*/

int check_crc_ccitt(buf, cnt)
const char *buf;
int cnt;
{
  int crc = 0xffff;

  for (; cnt > 0; cnt--)
    crc = (crc >> 8) ^ Crc_ccitt_table[(crc ^ *buf++) & 0xff];
  return (crc & 0xffff) == 0xf0b8;
}

