#ifndef __lint
static const char rcsid[] = "@(#) $Header: netupdc.c,v 1.21 93/10/31 07:26:23 deyke Exp $";
#endif

/* Net Update Client */

#include <sys/types.h>

#include <fcntl.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>

#include "buildsaddr.h"
#include "configure.h"
#include "netupd.h"
#include "strdup.h"

static void pexit(const char *s);
static void doread(int fd, char *buf, size_t cnt);
static void dowrite(int fd, const char *buf, size_t cnt);

/*---------------------------------------------------------------------------*/

static void pexit(const char *s)
{
  perror(s);
  exit(1);
}

/*---------------------------------------------------------------------------*/

static void doread(int fd, char *buf, size_t cnt)
{

  char *p = buf;
  int n;

  while (cnt) {
    n = read(fd, p, cnt);
    if (n < 0) pexit("read");
    if (!n) {
      fprintf(stderr, "read(): End of file\n");
      exit(1);
    }
    p += n;
    cnt -= n;
  }
}

/*---------------------------------------------------------------------------*/

static void dowrite(int fd, const char *buf, size_t cnt)
{

  const char * p = buf;
  int n;

  while (cnt) {
    n = write(fd, p, cnt);
    if (n <= 0) pexit("write");
    p += n;
    cnt -= n;
  }
}

/*---------------------------------------------------------------------------*/

int main(int argc, char **argv)
{

  char *client;
  char *cp;
  char *server;
  char buf[1024];
  char filename[1024];
  int addrlen;
  int fdfile;
  int fdsocket;
  int filesize;
  int flags = 0;
  int i;
  int net_filesize;
  int net_i;
  struct sockaddr *addr;

  alarm(6 * 3600);

  server = (argc < 2) ? "db0sao" : argv[1];

  if (argc < 3) {
    if (gethostname(buf, sizeof(buf))) pexit("gethostname");
    if (cp = strchr(buf, '.')) *cp = 0;
    client = strdup(buf);
  } else
    client = argv[2];

  if (getuid()) {
    fprintf(stderr, "%s: Permission denied\n", *argv);
    exit(1);
  }

  umask(022);
#ifdef linux
  putenv("HOME=/");
#else
  putenv("HOME=" HOME_DIR "/root");
#endif
  putenv("LOGNAME=root");
  putenv("PATH=/bin:/usr/bin:/usr/ucb:/usr/local/bin:/usr/contrib/bin");
  putenv("SHELL=/bin/sh");
  putenv("TZ=MEZ-1MESZ");

  if (chdir("/tcp")) pexit("/tcp");

  if (*PATCH_PROG) flags |= USE_PATCH;

#ifdef linux
  if (!(flags & USE_PATCH)) {
    fprintf(stderr, "patch: cannot execute\n");
    exit(1);
  }
#endif

  if (*GZIP_PROG) flags |= USE_GZIP;

  if (!(addr = build_sockaddr("unix:/tcp/.sockets/netcmd", &addrlen))) {
    fprintf(stderr, "build_sockaddr(): Failed\n");
    exit(1);
  }

  fdsocket = socket(addr->sa_family, SOCK_STREAM, 0);
  if (fdsocket < 0) pexit("socket");

  if (connect(fdsocket, addr, addrlen)) pexit("connect");

  strcpy(buf, "binary\n");
  dowrite(fdsocket, buf, strlen(buf));

  sprintf(buf, "connect tcp %s netupds\n", server);
  dowrite(fdsocket, buf, strlen(buf));

  if (flags) {
    sprintf(buf, "%d", flags);
    dowrite(fdsocket, buf, strlen(buf) + 1);
  }

  dowrite(fdsocket, client, strlen(client) + 1);

  doread(fdsocket, (char *) &net_filesize, 4);
  filesize = ntohl(net_filesize);

  tmpnam(filename);
  fdfile = open(filename, O_WRONLY | O_CREAT | O_TRUNC, 0600);
  if (fdfile < 0) pexit(filename);
  while (filesize > 0) {
    i = filesize < sizeof(buf) ? filesize : sizeof(buf);
    doread(fdsocket, buf, i);
    dowrite(fdfile, buf, i);
    filesize -= i;
  }
  if (close(fdfile)) pexit("close");

  sprintf(buf,
	  "%s < %s | sh",
	  (flags & USE_GZIP) ? GZIP_PROG " -d" : "uncompress",
	  filename);
  i = system(buf);
  net_i = htonl(i);
  dowrite(fdsocket, (char *) &net_i, 4);

  if (unlink(filename)) pexit(filename);

  if (!i) system("exec make");

  return i;
}

