//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//
// Ultrasound version by Jochen Quante 1994
//                    modified by Daniel Sachs 1994
//

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

//#ifdef _MSC_VER
#include <assert.h>
//#endif

#include "forte.h"
#include "gf1proto.h"
#include "ultraerr.h"

#include "cthugha.h"
#include "audio.h"

int GUSok=0;

int GUS_installed=0;

ULTRA_CFG GUS_config;

void *vbfr_free;

extern int (*init_audio)(void);
extern void (*close_audio)(void);
extern int (*audio_firsttime)(void);
extern int (*audio_everytime)(int wait);

extern int  (*get_level)(int channel);
extern void (*set_level)(int channel, int level);
extern int  (*level_incr)(int channel);

extern void (*set_input)(enum device_list device);

static int GUS_get_params(void)
{ char *settings;
  if ((settings = getenv("ULTRASND")) != NULL)
    { sscanf(settings,"%x,%d,%d,%d,%d",&(GUS_config.base_port),
			&(GUS_config.dram_dma_chan),
			&(GUS_config.adc_dma_chan),
			&(GUS_config.gf1_irq_num),
			&(GUS_config.midi_irq_num));
      GUS_installed = 1;
    }
  else
    GUS_installed = 0;
  return GUS_installed;
}

static void ultra_input(char far *buffer, long bufsize, unsigned samplerate)
{
	assert( UltraRecordData(buffer,2*sample_stereo,bufsize,0,0) );
}

void GUS_set_input(enum device_list device)
{
	UltraEnableOutput();

	switch( device )
	{
		case CDInput:		UltraDisableLineIn();	 // No controls for CD input
								UltraDisableMicIn();

								break;

		case LineInput:	UltraEnableLineIn();
								UltraDisableMicIn();

								break;

		case MicInput:		UltraDisableLineIn();
								UltraEnableMicIn();

								break;
	}
}

void GUS_close(void)
{
//	_dos_freemem(FP_SEG(voice_buffer));
	free(vbfr_free);

	UltraClose();
}

int GUS_blank(void)
{
	return 0;
}



int GUS_firsttime(void)
{
	UltraSetRecordFrequency(sample_rate);
	ultra_input(voice_buffer,(long)(2*BUFF_WIDTH+80),sample_rate);

	return 0;
}


int GUS_everytime(int wait)
{
	int x;
	static int prev=0;
	unsigned char far *sbuff;
	int noisy=0, last=0;
	static int firsttime=1;


	if( sample_rate != actual_rate )
	{
		if( sample_rate < 4000 )
			sample_rate = 4000;


		if( sample_rate > 44100 )
			sample_rate = 44100;

		actual_rate = sample_rate;

//		UltraReset(14);
		UltraSetRecordFrequency(sample_rate);
	}
	else
		if( wait )
			while (UltraRecordDmaBusy()) {
				if (kbhit())
					break;
			}
		else
			if( UltraRecordDmaBusy() )
				return 0;

	sbuff=voice_buffer ;
	sbuff += 6;

	last=(signed char)*sbuff;
	sbuff++;
	for (x=0; x<70; x+=2) {
		//align...

		if ((*sbuff)>=prev && last<prev-1) {
			break;
		} else {
			last= *sbuff;
			sbuff+=2;
		}
	}

	prev=(signed char)*sbuff;

	for (x=0; x<BUFF_WIDTH; x++) {
		  stereo[x][0]=(*sbuff++) ^ 128; // convert 2s complement
		stereo[x][1]=(*sbuff++) ^ 128; // to Byte
	}

	ultra_input(voice_buffer,(long)(2*BUFF_WIDTH+80),sample_rate);

	return 1;
}

int GUS_init(void)
{  char *tempBuff;

	init_audio=GUS_init;
	close_audio=GUS_close;
	audio_firsttime=GUS_firsttime;
	audio_everytime=GUS_everytime;

	get_level = GUS_blank;
	set_level = GUS_blank;
	level_incr = GUS_blank;

	set_input = GUS_set_input;

//	sample_rate = 44100;
//	sample_stereo = 1;

	if (!GUS_get_params()) {
		printf("UltraSound card not found.\n");
		return -1;
	}
	if (UltraProbe(GUS_config.base_port) != NO_ULTRA) {
		if (UltraOpen(&GUS_config,14) != NO_ULTRA) {
			if( tempBuff = malloc(buffer_size+16) ) {
				FP_SEG(voice_buffer) = FP_SEG(tempBuff) + 1;
				FP_OFF(voice_buffer) = 0;

				vbfr_free = tempBuff;

				voice_seg=FP_SEG(voice_buffer);
				switch (device) {
					case LineInput:
						UltraEnableLineIn();     // enable LINE
						break;
					case MicInput:
						UltraEnableMicIn();      // enable MIC
						break;
				}
				GUSok=1;
				return 0;
			} else {
				printf("Failed to init driver\n");
				return -2;
			}
		} else {
			return 1;
		}
	} else {
		printf("UltraSound card not found.\n") ;
		return -1;
	}
	return 0;
}

