//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "audio.h"
#include "translat.h"

static unsigned char tempscrn[BUFF_SIZE];

// Use two half-sized tables because MSC can then optimize the code
// to be almost TWICE as fast (no >64k blocks)
static unsigned int mapping1[102][BUFF_WIDTH];
static unsigned int mapping2[102][BUFF_WIDTH];

static int have_table=0;

void translate_screen(void)
{
	register unsigned int x;
	register char *screen;
	register unsigned int *map;

	if (!have_table)
		return;

	screen=buff;
	map=mapping1;

	memcpy(tempscrn,buff,BUFF_SIZE);

	tempscrn[0]=0;  // Set 0,0 to black - for safety reasons :-)

	for (x=0; x<(102*BUFF_WIDTH); x++) {
		*screen++=tempscrn[*map++];
	}

	map=mapping2;

	for (x=0; x<(102*BUFF_WIDTH); x++) {
		*screen++=tempscrn[*map++];
	}

}


// int translate=1;
int translate=0;

#define M_PI 3.14159265358979323846
#define RADEG (180.0/M_PI)
char maptabfile[255]="ROTATE.TAB";

int init_translate(void)
{
	int x,y,map_x,map_y;
	double polar_r,polar_a;
	double temp_y,temp_x;
	unsigned int offset=0;
	int badfile=0;

	FILE *fp;

	for (y=0; y<102; y++)
		for (x=0; x<BUFF_WIDTH; x++)  {
			mapping1[y][x]=0;
			mapping2[y][x]=0;
		}

	if ((fp=fopen(maptabfile,"rb"))!=NULL) {
		printf("Reading translation table: %s\n",maptabfile);
		printf("\nTranslation tables can be very slow on a 386...\n");
		printf("To disable translation tables, rename the ROTATE.TAB file\n");

		for (y=0; y<102; y++) {
			fread(&mapping1[y],sizeof(unsigned int),BUFF_WIDTH,fp);
		}
		for (y=0; y<102; y++) {
			fread(&mapping2[y],sizeof(unsigned int),BUFF_WIDTH,fp);
		}
		fclose(fp);
		for (y=0; y<102; y++)
			for (x=0; x<BUFF_WIDTH; x++) {
				if (mapping1[y][x]<0) {
					printf("Neg at %d,%d\n",x,y);
					mapping1[y][x]=0;
					badfile++;
				}

				if (mapping2[y][x]>=(unsigned int)BUFF_SIZE) {
					printf("High at %d,%d\n",x,y);
					mapping2[y][x]=0;
					badfile++;
				}
				if (mapping2[y][x]<0) {
					printf("Neg at %d,%d\n",x,y);
					mapping2[y][x]=0;
					badfile++;
				}

				if (mapping2[y][x]>=(unsigned int)BUFF_SIZE) {
					printf("High at %d,%d\n",x,y);
					mapping2[y][x]=0;
					badfile++;
				}

			}
		have_table=1;

		if (badfile)
			printf("%d Errors in translation table\n",badfile);

		return 0;
	} else {
		printf("No Translation tables\n");
		have_table=0;
		return 1;
	}

}


