/********************************************************************/
/*                                                                  */
/* Reussites pour OS/2                                              */
/*                                                                  */
/* Installation en franais, version 1.51                           */
/*                                                                  */
/* Copyright 1994 (C) par Felix Maschek, Hamburg                    */
/*                                                                  */
/* EMail: CompuServe 100120,1370                                    */
/*                   OS2SHARE                                       */
/*                                                                  */
/********************************************************************/

'@Echo Off'

/* chargement de REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisations */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation de Russites 1.51...'
Say ''


/* vrifications... */

Result = SysFileTree( "CARDS.EXE", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : CARDS.EXE introuvable !'
  Signal DONE
  End

Result = SysFileTree( "PICTURES.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : PICTURES.DLL introuvable !'
  Signal DONE
  End

Result = SysFileTree( "CARDSFRA.HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : CARDSFRA.HLP introuvable !'
  Signal DONE
  End

Result = SysFileTree( "CARDSFRA.DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'Erreur : CARDSFRA.DLL introuvable !'
  Signal DONE
  End

/* demande du rpertoire destination  l'utilisateur */
 
Say 'Veuillez entrer le nom complet du rpertoire o installer Russites'
Say '  Par dfaut : C:\REUSSITE : '
Pull Directory
If Directory = "" Then Directory = 'C:\REUSSITE'


/* create target-path. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'Erreur : Impossible de crer le rpertoire destination'
    Signal DONE
    End
  End
Say '';

/* Cration de l'objet sur le bureau */

Folder = '<WP_DESKTOP>'

/* Install */

Say 'Copie de Russites vers ' Directory '...'
Copy "CARDS.EXE" Directory"\CARDS.EXE" '1>NUL'
Copy "PICTURES.DLL" Directory"\PICTURES.DLL" '1>NUL'
Copy "CARDSGER.HLP" Directory"\CARDSGER.HLP" '1>NUL'
Copy "CARDSGER.DLL" Directory"\CARDSGER.DLL" '1>NUL'
Copy "CARDSENG.HLP" Directory"\CARDSENG.HLP" '1>NUL'
Copy "CARDSENG.DLL" Directory"\CARDSENG.DLL" '1>NUL'
Copy "CARDSNOR.HLP" Directory"\CARDSNOR.HLP" '1>NUL'
Copy "CARDSNOR.DLL" Directory"\CARDSNOR.DLL" '1>NUL'
Copy "CARDSSWE.HLP" Directory"\CARDSSWE.HLP" '1>NUL'
Copy "CARDSSWE.DLL" Directory"\CARDSSWE.DLL" '1>NUL'
Copy "CARDSFRA.HLP" Directory"\CARDSFRA.HLP" '1>NUL'
Copy "CARDSFRA.DLL" Directory"\CARDSFRA.DLL" '1>NUL'

Say 'Cration de l''objet sur le bureau...'
Type = 'WPProgram'
Title = 'Russites'
Parms = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\CARDS.EXE;PARAMETERS=CARDSFRA;STARTUPDIR='Directory';OBJECTID=<CARDS>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'L''objet a t cr sur le bureau ! Termin.'
Else             
  Say 'Erreur : impossible de crer l''objet sur le bureau.'

Signal DONE

FAILURE:
Say 'Erreur pendant un traitement REXX.'
Signal DONE

HALT:
Say 'Halte REXX.'
Signal DONE

SYNTAX:
Say 'Erreur de syntaxe REXX.'
Signal DONE

DONE:
Exit
