/*****************************************************************************
 * $Id: rmt_disk.c,v 1.4 1994/02/16 15:29:17 edvkai Exp $
 *****************************************************************************
 * $Log: rmt_disk.c,v $
 * Revision 1.4  1994/02/16 15:29:17  edvkai
 * Dummy checkin for CVS 1.3 crlf.
 *
 * Revision 1.3  1993/11/25 18:53:54  edvkai
 * Removed DLL import by number.
 * Changed return codes to avoid ambiguities.
 * Changed lseek into seek, parameter changes.
 *
 * Revision 1.2  1993/05/26  17:06:44  AK
 * 32-bit TCP/IP
 *
 * Revision 1.1.1.1  1993/02/08  21:31:56  AK
 * TAR device interface DLLs.
 *
 * Revision 1.1  1993/02/08  21:31:54  AK
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: rmt_disk.c,v 1.4 1994/02/16 15:29:17 edvkai Exp $";

/*
 *	disk.c
 *
 * Floppy disk interface for GNU tar.
 *
 * Thanks to Kai Use Rommel for the disk locking code.
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#ifndef __IBMC__
# define _Packed
#endif
#include <os2.h>

#ifndef __IBMC__
# define _System
#endif

static int	wrflag;
static unsigned	last_error;

int _System
rmt_open(char *name, int mode, int prot)
{
	ULONG	r, handle, action;

	wrflag = (mode & 3) != O_RDONLY;
	r = DosOpen((PSZ)name, &handle, &action, 0L, 0, FILE_OPEN,
		OPEN_SHARE_DENYNONE
		+ OPEN_FLAGS_FAIL_ON_ERROR
		+ OPEN_FLAGS_DASD
		+ (mode & 3), 0);
	if (r) {
		last_error = r;
		return -2;
	}
	if (wrflag) {
	        BYTE cmd = 0;
		ULONG ulParmLengthInOut = sizeof(cmd), 
		      ulDataLengthInOut = 0;
		DosDevIOCtl(handle, IOCTL_DISK, DSK_LOCKDRIVE, 
			    &cmd, sizeof(cmd), &ulParmLengthInOut,
			    0, 0, &ulDataLengthInOut);
	}
	return handle;
}

int _System
rmt_close(int fd)
{
	if (wrflag) {
		BYTE cmd = 0;
		ULONG ulParmLengthInOut = sizeof(cmd), 
		      ulDataLengthInOut = 0;
		DosDevIOCtl(fd, IOCTL_DISK, DSK_UNLOCKDRIVE, 
			    &cmd, sizeof(cmd), &ulParmLengthInOut,
			    0, 0, &ulDataLengthInOut);
	}
	return 0;
}

long _System
rmt_error(void)
{
	return last_error;
}

char * _System
rmt_status(long rcode)
{
	static char msg[30];
	sprintf(msg, "System error code %u", last_error);
	return msg;
}

#ifdef __EMX__

unsigned long
_DLL_InitTerm(unsigned long mod_handle, unsigned long flag)
{
	if (!flag) {
		_CRT_init();
	} else {
		_CRT_term();
	}
	return 1;
}

#endif
