/* idx2html.cmd - Convert Hobbes 00index.txt to WWW HTML file */
/* Version 1.0, 11 December 1994                              */
/* Written by Kevin.Lowey@Usask.CA                            */

parse arg inputfile outputfile ftp_site start_dir

if outputfile="" then do
  say "idx2html: Convert Hobbes FTP 00index.txt files to html"
  say "          Version 1.0, 11 December 1994"
  say " "
  say "USAGE: idx2html Index_file HTML_file [ftpsite] [starting_dir]"
  say "     Index_File: Original 00index.txt file in the format used at Hobbes"
  say "     HTML_file:  Filename to put the resulting HTML document into"
  say "     ftpsite:    Optional name of FTP site being indexed."
  say '                 Defaults to "ftp-os2.nmsu.edu"'
  say "     starting_dir: Starting directory on that site."
  say '                   Defaults to "OS2/"' 
  say '                   Do not add the leading  "/". Trailing "/" optional'
  say " "
  say "DESCRIPTION:"
  say "This program converts a 00index.txt file from an FTP site to a WWW"
  say "html document. This allows people with web browsers to view the"
  say "files and their descriptions listed in the 00index file, and download"
  say "desired files immediately from the list".
  say " "
  say "INPUT FILE FORMAT"
  say 'The input file format must be that used by "ftp-os2.nmsu.edu".'
  say '- BLANK LINES are passed through unchanged'
  Say '- If the first word on a nonblank line ends with ":", it is taken'
  Say '  as a subdirectory name under the starting directory. All files'
  Say '  listed under this section are relative to this new file name.'
  Say '- The first word on all other lines are taken as file or directory'
  Say '  names, with the rest of the line taken as a comment' 
 
  exit (1)
end

/* Constants */
if ftp_site = "" then do
  ftp_site = "ftp-os2.nmsu.edu"
end

if start_dir = "" then do
  Start_dir = "os2/"
end

pagetitle = ftp_site||" Directory: "||start_dir

html_start = '<a href="ftp://'||ftp_site||"/"||Start_dir
if right(html_start,1) <> "/" then do
  html_start = html_start||"/"
end


/* Variables */
current_dir = ""

/* startup */
call rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call sysloadfuncs
rc = sysfiledelete(outputfile)

/* Writing the header */
say "Writing Header"
call lineout outputfile, "<html>"
call lineout outputfile, "<head>"
call lineout outputfile, "<title>"
call lineout outputfile, pagetitle
call lineout outputfile, "</title>"
call lineout outputfile, "</head>"
call lineout outputfile, "<body>"
call lineout outputfile, "<h1>"||pagetitle||"</h1>"
call lineout outputfile, "<pre>"

/* Process */
say "Processing ..."
do while lines(inputfile) > 0
  dataline = linein(inputfile)

  if length(strip(dataline)) = 0 then do
    call lineout outputfile, dataline
  end
  else do
    parse var dataline firstword endline

    if pos(":",firstword) = 0 then do  
      outline = html_start||current_dir||firstword||'">'||firstword||'</a> '||endline
      call lineout outputfile, outline
    end /* then do */
    else do
      call lineout outputfile,dataline
      current_dir = left(firstword,pos(":",firstword)-1)||'/'
      Say "Processing Directory "||current_dir
    end /* else do */
  end /* else do */
end

/* Writing the end */
say "Writing Closing"
call lineout outputfile,"</pre>"
call lineout outputfile,"</body>"
call lineout outputfile,"</html>"

say "Done"
exit(0)
