.********************************************************
:userdoc.
:docprof toc=123.
:title.Compasses and Ruler for OS/2
.******************************************
:h1 res=100. Overview
:p.
C.u.R. is able to do constructions with compasses and ruler on a 
computer. Clearly, advantages are that one is able to
:ul.
:li. move construction points and observe the result,
:li. generate tracks of points,
:li. hide or display construction details.
:eul.:p.
This program uses OS/2 and its help facilities. The interface consists
of a construction window and the toolbox. For further information read
about
:ul compact.
:li. :link reftype=hd res=200.The construction window.:elink.
:li. :link reftype=hd res=300.The toolbox.:elink.
:li. :link reftype=hd res=400.The menus.:elink.
:li. :link reftype=hd res=500.The keyboard.:elink.
:li. :link reftype=hd res=1000.The author.:elink.
:eul.
.******************************************************
:h1 res=200. The construction window.
:i1. Construction Window
:p.
This window displays your construction. Hidden objects can be made 
visible by the corresponding menu option. The window can be scrolled. 
One can zoom in and out.
:p.
After choosing a tool, the left mouse button is used to choose a point
inside the construction window.
:p.
The tool can also be chosen with the keyboard.
(:link reftype=hd res=500.Using the keyboard:elink.)
.******************************************************
:h1 res=300. The Toolbox.
:i1. Tool Box
:p.
This window shows the available tools as icons. You can choose a tool 
with the mouse or the keyboard (left and right arrow key and return).
:p.
A text explains the action, which is expteced from the user.
This text may change during the work with the tool.
:p.
Here is a description of the tools.
:dl compact.
:dt.:artwork name='car\point.bmp'.
:dd.Generates a point.
:dt.:artwork name='car\line.bmp'.
:dd.Generates a straight line through two points.
:dt.:artwork name='car\ray.bmp'.
:dd.Generates a ray.
:dt.:artwork name='car\segment.bmp'.
:dd.Generates a line segment.
:dt.:artwork name='car\circle.bmp'.
:dd.Generates a circle from center and radius point.
:dt.:artwork name='car\move.bmp'.
:dd.Moves a point. This point may not be constructed from other 
objects (e.g., by a cut).
:dt.:artwork name='car\moveon.bmp'.
:dd.Moves a point on a line, ray, segment or circle. This can be used 
to study what happens to another point, if a given point is moved 
along a circle (say). Track the other point first. The line or circle
must not depend on the point.
:dt.:artwork name='car\pointon.bmp'.
:dd.Generates an arbitrary point on an object.
:dt.:artwork name='car\intersect.bmp'.
:dd.Intersects two objects. This generates one or two points. 
Intersections may become invalid. Then all objects depending on it are
also invalid.
:dt.:artwork name='car\track.bmp'.
:dd.Track points. Choose the point and then move another point. The 
tracks are deleted at the next choice of this tool.
:dt.:artwork name='car\hide.bmp'.
:dd.Hide or unhide an object. Hidden objects can be made visible by 
a menu option.
:dt.:artwork name='car\delete.bmp'.
:dd.Delete an object and all objects depending on it.
:dt.:artwork name='car\edit.bmp'.
:dd.Edit an object.
:dt.:artwork name='car\angle.bmp'.
:dd.Constructs an angle from three points. The angle is always 
oriented in the mathematical positive sense.
:edl.:p.
:hp2.Note &colon.:ehp2. The following tools can be replaced by pure 
construction steps. They just help to solve a bigger construction 
problem.
:dl compact.
:dt.:artwork name='car\lot.bmp'.
:dd.Generate a plumb line from a point to a line object.
:dt.:artwork name='car\parallel.bmp'.
:dd.Generate a parallel line through a point to a line object.
:dt.:artwork name='car\circle3.bmp'.
:dd.Generate a circle from center, and two points, whose distance
gives the radius.
:dt.:artwork name='car\middle.bmp'.
:dd.Generates the middle point between two points.
:edl.
.******************************************************
:h1 res=400. The menus.
:i1. Menus
:p.
All menu points should be self explaining (I hope). Some can be chosen
with keyboard shortcuts as displayed besides the menu text.
.******************************************************
:h1 res=500. The Keyboard.
:i1. Keys
:p.
The tools can be chosen with the keyboard. Press letters "qwertyuiop"
or "asdfghj".
:dl compact.
:dthd.:hp2.Taste:ehp2.
:ddhd.:hp2.Zweck:ehp2.
:dt.F1
:dd.Help (also in dialog windows)
:dt.F2
:dd.Index for help.
:dt.F3
:dd.Help for keys.
:dt.F4
:dd.Content of help.
:dt.F5
:dd.Zoom in.
:dt.F6
:dd.Zoom out.
:dt.F8
:dd.Choose default object color.
:dt.F9
:dd.Edit comment of construction.
:dt.F10
:dd.Toggle showing all objects.
:dt.<--
:dd.(Backspace key) Delete the lastly constructed object.
:edl.
.******************************************************
:h1 res=600. Die Object Choice
:p.
This dialog appears, if the choice with the mouse was not unique.
Choose the object with a double click or OK.
.******************************************************
:h1 res=1000. ber den Autor.
:i1. Autor
:p.
This program was written using a self made C++ library. You use it 
at your own risk. Questions and comments are wellcome.
:xmp.
Dr. R. Grothmann
Ahornweg 5a
85117 Eitensheim

EMail&colon.
rene.grothmann@ku-eichstaett.de
:exmp.:p.
.****
:h1 res=2000 hide. Object choice
:p.
Double click on the object you want, or select and press OK.
.****
:h1 res=2010 hide. Edit object
:p.
Not all fields in this dialog are changable. A point can only be 
moved, if it is not a constructed point.
.****
:h1 res=2020 hide. Error
:p.
This should only happen, if you change the construction file manually.
.****
:h1 res=2030 hide. Default Color
:p.
Choose the default color for further constructions.
.****
:h1 res=2040 hide. Comment
:p.
You may want to comment your construction.
.******************************************************
:euserdoc.
