/* Find long file names in a specified tree */

'@Echo Off'

call RxFuncAdd 'SysFileTree', 'REXXUTIL', 'SysFileTree'

say 'LongFile - finds non-8.3 files/directories'
say 'cobbled together by: Doug Azzarito'

Parse Upper Arg FileSpec                    /* FileSpec is our search spec*/
if FileSpec = '' then signal usage

say 'Starting search of:' FileSpec

rc=SysFileTree(FileSpec, 'file', 'BSO');    /* search for files & dirs */

LongCount = 0                               /* count of long names found */
say file.0 'files to process'               /* tell 'em how many candidates*/
do i=1 to file.0                            /* loop through candidates */
   iName = LASTPOS('\',file.i) + 1          /* iName=index of base name */
   iDot = POS('.',file.i,iName)             /* iDot=index of DOT (if any)*/
   iEnd = LENGTH(file.i) +1                 /* iEnd = index of end */
   if iDot = 0 then iDot = iEnd             /* No dot? set iDot to end */
   if iDot - iName > 8 | iEnd - iDot > 4 then  /* NAME>8 or .EXT > 4=LFN! */
   do
     say file.i                             /* display long file name */
     LongCount = LongCount + 1              /* and increment counter */
   End
end                                         /* end of main loop */
say LongCount 'Long filenames found'        /* tell user how many hits */
return 0                                    /* and go home happy! */

Usage:                      /* No parms specified, let's explain ourselves */
  Say 'usage: LONGFILE filespec'
  Say ' where filespec is a wildcard filespec'
  say ''
  say 'LONGFILE will search for any non-8.3 filename in the specified'
  say 'filespec (including subdirs, hidden files, etc).'
  say 'ex: LONGFILE C:\*        searches the entire C: drive for long file names'
  say '    LONGFILE D:\OS2\A*   searches the D:\OS2 tree for long file names'
  say '                         that begin with the letter A.'
  Exit 1
