/*
    Example of using the RexxDate function package

    Usage: rxdate <date-string> <format-string>
*/

/* check whether the RxDate Function is loaded, if not, load it */
IF RxFuncQuery('RxDate')
    THEN CALL RxFuncAdd 'RxDate', 'RexxDate', 'RxDate'

parse arg myDate myFormat

if myFormat = ''
    then myFormat = '%A %B %d, %Y'

myDateCode = RxDate(myDate)
say 'DateCode =' myDateCode', formatted version =' RxDate(myDateCode, myFormat)


/*
** Find the day New Year's Eve falls on, and how many days until then
*/
til_newyears = rxDate('12/31') - myDateCode
say 'New Year''s Eve' rxDate(, '%Y') 'falls on' rxDate('12/31', '%A')', days left =' til_newyears


/*
**  Figure out the beginning and ending of this week
*/
sunday = myDateCode - RxDate(myDateCode, '%w')
say 'This week is' RxDate(sunday, myFormat) 'thru' RxDate(sunday+6, myFormat)

return
