program test;

{ Test program for Openfiles unit.  Should be compilable in TP/BP 6+, TPW 1.5+ }

uses
{$ifdef windows}
  {$ifdef ver15}
  wincrt,wobjects,openfiles;
  {$else}
  wincrt,objects,openfiles;
  {$endif}
{$else}
  objects,openfiles;
{$endif}

{ This routine uses the callback function "for_each_open_file".  It's the
  only way to get the file open mode. }

procedure doit(prefix:string);
  procedure printone(f:string;openmode:word); far;
  begin
    writeln(prefix,f:12,' mode ',openmode);
  end;
begin
  for_each_open_file(@printone);
end;

{ This routine builds the collection of strings and prints it }

procedure doit2(prefix:string);
var
  c:Pcollection;

  { Print each filename }
  procedure printone(f:PString); far;
  begin
    writeln(prefix,f^);
  end;

  { Release each string }
  procedure disposeone(f:PString); far;
  begin
    DisposeStr(f);
  end;

begin
  c:=get_open_files;
  if c <> nil then
  begin
    c^.foreach(@printone);

    { This shows the proper way to dispose of the collection }

    c^.foreach(@disposeone);
    c^.deleteall;
    dispose(c,done);
  end;
end;

var
  f:file;
  i : longint;
begin
  assign(f,'test.pas');
  reset(f);
  allfiles := true;
  doit('Open by some process:  ');
  allfiles := false;
  doit2('Open by us:  ');

  { At the end, the exitproc will print one more list (in DOS). }
end.
