{$DEFINE ANALYZE}
{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+}
{$M 16384,0,655360}
program swart4;
(* uses PET { or MON }; *)
var TimerTick: ^Word {absolute $0040:$006C};
    Ticks: Word;
{
    File: SWART4.PAS
  Author: drs. Robert E. Swart (bobs@dragons.nest.nl)
          P.O. Box 799
          5702 NP Helmond
          THE NETHERLANDS
}
Const words: LongInt = 0;
      inword: Boolean = True { global: value retained between blocks!! };

Const BufSize: Word = 8 * 4096;
var Buffer: PChar;
    Size,code: Word;
    infile,outfile: File;

    function WordCount(var Str: PChar; Size: Word): LongInt;
    var words: LongInt;
        i: Word;
    begin
      words := 0;
      for i:=0 to Size-1 do
      begin
        if (Str[i] <= ' ') then inword := False
        else
        begin
          if not inword then
          begin
            inword := True;
            Inc(words)
          end
        end
      end;
      WordCount := words
    end {WordCount};

    procedure UpperFast(Str: PChar; Size: Word);
    { 48 Bytes macro to UpCase a Block of Memory }
    InLine(
      $8C/$DA/               {       mov   DX,DS                 }
      $BB/Ord('a')/
          Ord('z')-Ord('a')/ {       mov   BX,'z'-'a'/'a'        }
      $59/                   {       pop   CX                    }
      $5E/                   {       pop   SI                    }
      $1F/                   {       pop   DS                    }
      $FC/                   {       cld                         }

      $D1/$E9/               {       shr   CX,1                  }
      $73/$0B/               {       jnc   @Part1                }
      $AC/                   {       lodsb                       }
      $28/$D8/               {       sub   AL,BL                 }
      $38/$F8/               {       cmp   AL,BH                 }
      $77/$04/               {       ja    @Part1                }
      $80/$6C/$FF/
          Ord('a')-Ord('A')/ {@Loop: sub   Byte Ptr[SI-1],'a'-'A'}
      $E3/$14/               {@Part1:jcxz  @Exit                 }
      $AD/                   {       lodsw                       }
      $28/$D8/               {       sub   AL,BL                 }
      $38/$F8/               {       cmp   AL,BH                 }
      $77/$04/               {       ja    @Part2                }
      $80/$6C/$FE/
          Ord('a')-Ord('A')/ {       sub   Byte Ptr[SI-2],'a'-'A'}
      $49/                   {@Part2:dec   CX                    }
      $28/$DC/               {       sub   AH,BL                 }
      $38/$FC/               {       cmp   AH,BH                 }
      $77/$EC/               {       ja    @Part1                }
      $EB/$E6/               {       jmp   @Loop                 }
      $8E/$DA                {@Exit: mov   DS,DX                 }
    ) {UpperFast};

    procedure UpperAnalyze(Str: PChar; Size: Word);
    { The time spend in this one can be measured... }
    begin
      UpperFast(Str, Size)
    end {UpperAnalyze};

begin
  TimerTick := Ptr(Seg0040,$006C);
  Assign(infile,ParamStr(1));
  reset(infile,1);
  Assign(outfile,ParamStr(2));
  rewrite(outfile,1);

  GetMem(Buffer,BufSize);
  Ticks := TimerTick^;
  repeat
    BlockRead(infile,Buffer^,BufSize,Size);
    Inc(Words,WordCount(Buffer,Size));
    {$IFDEF ANALYZE}
      UpperAnalyze(Buffer,Size);
    {$ELSE}
      UpperFast(Buffer,Size);
    {$ENDIF}
    BlockWrite(outfile,Buffer^,Size)
  until Size < BufSize;
  Ticks := TimerTick^ - Ticks;
  FreeMem(Buffer,BufSize);

  close(infile);
  close(outfile);
  writeln('Swart4: ',words,' - ',Ticks:4,' ticks.');
  writeln('Buffer size of: ',BufSize,' bytes.')
end.
