{----------------------------------------------------------------------
  This is a program that grew out of an article in the April 14, 1994
  issue of PC Magazine which discussed the structure of an NE
  (New Executable) file. The article explored how to read the header
  information to find out (a) whether the file is a Windows (or DPMI)
  executable, and (b) the names of any DLLs that are needed by the
  program or DLL.

  This is NOT a foolproof method of discovering all DLL dependencies,
  however. Since a DLL can be loaded at run-time with the LoadLibrary()
  function, those DLLs aren't necessarily imported; therefore, their
  names will not appear in the EXE header.

  At any rate, this program will assist in discovering what DLLs
  are used by a particular program (useful when you want to remove
  a Windows program from your system!).

  This code is donated to the public domain. Use it any way you want.

  Comments and questions are appreciated...

  Phil Jurgenson, 75060,222
 ----------------------------------------------------------------------}

program Needs;

{$R NEEDS.RES}

{$D NEEDS.EXE DLL reference program}


uses
  WinProcs,
  WinTypes,
  Strings,
  WinDos,
  OWindows,
  ODialogs,
  CommDlg,
  Ctl3d;        { OWL unit for accessing Microsoft's CTL3D.DLL }

const
  ID_LISTBOX  = 101;
  ID_SELECT   = 102;
  ID_STATTEXT = 103;
  ID_ABOUT    = 104;

  IDS_FILTER  = 1;    { string table ID for open file dialog filter string }
  IDS_NOTEXE  = 2;    { 'Not a valid EXE/DLL file.' }
  IDS_NOTWINEXE = 3;  { 'Not a Windows EXE/DLL file.'}
  IDS_NODLLS  = 4;    { 'References no DLLs.'}

  AppName : PChar = 'NEEDS';

type
  TFileName = Array[0..255] of Char;
  TNeedsApp = Object(T3dApplication)
    procedure InitMainWindow; virtual;
    procedure InitInstance; virtual;
  end;

  PNeedsWindow = ^TNeedsWindow;
  TNeedsWindow = Object(T3dDlgWindow)
    pDLLList : PListBox;
    pExeName : PStatic;
    FileName : TFileName;
    constructor Init(aParent : PWindowsObject; aTitle : PChar);
    procedure SetupWindow; virtual;
    procedure CenterWindow(aParent : PWindow);
    function GetClassName : PChar; virtual;
    procedure GetWindowClass(var aWndClass : TWndClass); virtual;
    procedure IDAbout(var Msg : TMessage); virtual id_First + ID_ABOUT;
    procedure IDSelect(var Msg : TMessage); virtual id_First + ID_SELECT;
    procedure FillListBox(fName : String);
  end;

{----------------------------------------------------------------------}
{         TNeedsWindow methods
{----------------------------------------------------------------------}

constructor TNeedsWindow.Init(aParent : PWindowsObject; aTitle : PChar);
  begin
    inherited Init(aParent, aTitle);
    pDLLList := New(PListBox, InitResource(@Self, ID_LISTBOX));
    pExeName := New(PStatic, InitResource(@Self, ID_STATTEXT, 128));
  end;

procedure TNeedsWindow.SetupWindow;
  begin
    inherited SetupWindow;
    pDLLList^.ClearList;
    pExeName^.SetText('');
    CenterWindow(Nil);
  end;

function TNeedsWindow.GetClassName : PChar;
  begin
    GetClassName := AppName;
  end;

procedure TNeedsWindow.GetWindowClass(var aWndClass : TWndClass);
  begin
    inherited GetWindowClass(aWndClass);
    aWndClass.hIcon := LoadIcon(HInstance, AppName);
  end;


{ Routine for centering a window on the screen. If aParent is NIL,
  the window is centered in the screen, otherwise is centered over
  the parent window.

  Borland SHOULD have included this function in OWL...
}

procedure TNeedsWindow.CenterWindow(aParent : PWindow);
  var
    rcDlg,
    rcParent,
    rcScreen : TRect;
    pHwnd    : HWND;
    dlgW,
    dlgH,
    xLeft,
    yTop,
    xMid,
    yMid     : Integer;
  begin
    with rcScreen do begin
      Left := 0;
      Top  := 0;
      Right := GetSystemMetrics(SM_CXSCREEN);
      Bottom := GetSystemMetrics(SM_CYSCREEN);
    end;
    if (aParent <> Nil) then
      begin
        pHwnd := aParent^.HWindow;
        GetWindowRect(pHwnd, rcParent);
      end
    else begin
      pHwnd := 0;
      rcParent := rcScreen;
    end;
    xMid := (rcParent.Left + rcParent.Right) div 2;
    yMid := (rcParent.Top + rcParent.Bottom) div 2;
    GetWindowRect(HWindow, rcDlg);
    dlgW := rcDlg.Right - rcDlg.Left;
    dlgH := rcDlg.Bottom - rcDlg.Top;
    xLeft := xMid - (dlgW div 2);
    yTop := yMid - (dlgH div 2);
    if (xLeft < 0) then
      xLeft := 0
    else if (xLeft + dlgW) > rcScreen.Right then
      xLeft := rcScreen.Right - dlgW;
    if (yTop < 0) then
      yTop := 0
    else if (yTop + dlgH) > rcScreen.Bottom then
      yTop := rcScreen.Bottom - dlgH;

    SetWindowPos(HWindow, 0, xLeft, yTop, -1, -1, SWP_NOSIZE or SWP_NOZORDER);
  end;


{ Do the About dialog }

procedure TNeedsWindow.IDAbout(var Msg : TMessage);
  begin
    Application^.ExecDialog(New(PDialog, Init(@Self, 'AboutDlg')));
  end;


{ What to do when the Select... button is clicked.
  Invoke the common file open dialog, then send the selected
  file name to the FillListBox routine.
}

procedure TNeedsWindow.IDSelect(var Msg : TMessage);
  const
    DefExt = 'exe';
  var
    OpenFN      : TOpenFileName;
    Filter      : array [0..100] of Char;
    FullFileName: TFilename;
    WinDir      : array [0..145] of Char;
    fName       : String;
    i           : Integer;
  begin
    GetWindowsDirectory(WinDir, SizeOf(WinDir));
    SetCurDir(WinDir);
    StrCopy(FullFileName, '');

    FillChar(Filter, SizeOf(Filter), #0);  { Set up for double null at end }
    LoadString(HInstance, IDS_FILTER, Filter, 100);
    for i := 0 to 100 do
      if (Filter[i] = #9) then
        Filter[i] := #0;

    FillChar(OpenFN, SizeOf(TOpenFileName), #0);
    with OpenFN do
    begin
      hInstance     := HInstance;
      hwndOwner     := HWindow;
      lpstrDefExt   := DefExt;
      lpstrFile     := FullFileName;
      lpstrFilter   := Filter;
      lpstrFileTitle:= FileName;
      flags         := ofn_FileMustExist;
      lStructSize   := sizeof(TOpenFileName);
      nFilterIndex  := 1;       {Index into Filter String in lpstrFilter}
      nMaxFile      := SizeOf(FullFileName);
    end;
    if GetOpenFileName(OpenFN) then begin
      fName := StrPas(FileName);
      FillListBox(fName);
    end;
  end;

{ Search the selected file for EXE header information, and display
  any imported DLL names in the listbox.
}

procedure TNeedsWindow.FillListBox(fName : String);
  var
    f         : File;
    Buff      : PChar;
    sLen,
    OldFMode  : Byte;
    modTable,
    impNames,
    refCount,
    wVal      : Word;
    modOfs,
    impOfs,
    lVal      : LongInt;
    mName     : Array[0..9] of Char;
    i         : Integer;
    pName     : TFileName;
    pMsg      : Array[0..30] of Char;
  begin
    StrPCopy(pName, fName);
    pExeName^.SetText('');
    pDLLList^.ClearList;
    OldFMode := FileMode;
    FileMode := 0;      { ReadOnly }
    Assign(f, fName);
    Reset(f, 1);

    { See if it's a valid .EXE file }
    GetMem(Buff, $40);
    BlockRead(f, Buff^, $40);
    if ((Buff[0] <> #$4D) or (Buff[1] <> #$5A)) then begin
      FreeMem(Buff, $40);
      LoadString(HInstance, IDS_NOTEXE, pMsg, 30);
      MessageBox(0, pMsg, pName, mb_OK);
      Close(f);
      Exit;
    end;

    { Make sure it's a Windows .EXE file }
    Move(Buff[$18], wVal, SizeOf(Word));
    if (wVal < $40) then begin
      FreeMem(Buff, $40);
      LoadString(HInstance, IDS_NOTWINEXE, pMsg, 30);
      MessageBox(0, pMsg, pName, mb_OK);
      Close(f);
      Exit;
    end;

    { Find the Windows header }
    Move(Buff[$3C], lVal, SizeOf(LongInt));   { offset of Windows header }
    FreeMem(Buff, $40);
    GetMem(Buff, $2C);
    Seek(f, lVal);
    BlockRead(f, Buff^, $2C);                 { first 44 bytes of header }
    Move(Buff[$1E], refCount, SizeOf(Word));  { #entries in module ref table }
    if (refCount = 0) then begin
      FreeMem(Buff, $2C);
      LoadString(HInstance, IDS_NODLLS, pMsg, 30);
      MessageBox(0, pMsg, pName, mb_OK);
      Close(f);
      Exit;
    end;

    pExeName^.SetText(pName);
    Move(Buff[$28], modTable, SizeOf(Word));  { offset of module ref table }
    Move(Buff[$2A], impNames, SizeOf(Word));  { offset of imported names table }

    FreeMem(Buff, $2C);

    modOfs := lVal + modTable;
    impOfs := lVal + impNames;

    for i := 1 to refCount do begin
      Seek(f, modOfs);
      BlockRead(f, wVal, SizeOf(Word));

      Seek(f, impOfs + wVal);
      BlockRead(f, sLen, SizeOf(Byte));
      FillChar(mName, SizeOf(mName), #0);
      BlockRead(f, mName[0], sLen);

      pDLLList^.AddString(mName);

      modOfs := modOfs + SizeOf(Word);
    end;


    Close(f);
    FileMode := OldFMode;
  end;

{----------------------------------------------------------------------}
{         Application initialization
{----------------------------------------------------------------------}

procedure TNeedsApp.InitMainWindow;
  begin
    MainWindow := New(PNeedsWindow, Init(Nil, 'NEEDSDLG'));
  end;

procedure TNeedsApp.InitInstance;
  begin
    Register3dApp(Name,True,True,True);
    inherited InitInstance;
    HAccTable := 0;
  end;


var
  NeedsApp : TNeedsApp;

begin
  NeedsApp.Init(AppName);
  NeedsApp.Run;
  NeedsApp.Done;
end.
