 Program ExPrtScr;

   {-----------------------------------------------------------------------}
   {                                                                       }
   {  Program ExPrtScr                  Demonstration of Protected Mode    }
   {                                    Print Screen Handler Using EZDPMI  }
   {-----------------------------------------------------------------------}
   {                                                                       }
   {  This is a demonstration program to show the use of a Real Mode       }
   {  Call Back using the EZDPMI unit.                                     }
   {                                                                       }
   {  Program description:                                                 }
   {                                                                       }
   {    1. Provide a routine to be used as a Real Mode Interrupt           }
   {       Service Routin, procedure SetPrintScreenFlag.                   }
   {       Also provide routines to install and remove the interrupt.      }
   {                                                                       }
   {    2. In the program's main block:                                    }
   {        a. Install the ISR, saving original interrupt vector.          }
   {        b. Run a test loop to demonstrate the ISR.                     }
   {        c. Remove the ISR and restore original interrupt vector.       }
   {                                                                       }
   {-----------------------------------------------------------------------}
   {  This unit provided "AS-IS" for The Pascal Magazine by Ray Bernard.   }
   {-----------------------------------------------------------------------}


 Uses
   Crt,      { for ReadKey and Keypressed }
   WinDOS,   { for TRegisters type }
   EZDPMI;

 const
   PrtScrInt = $05;  { Print Screen Interrupt Number }

 var
   NewPrtScrISR : RealProc;          { EZDPMI type for callback routine info }
   OldPrtScrISR : Pointer;           { the previous real mode ISR address }
   PrintScreenWasPressed : Boolean;  { flag for our pmode ISR to set }
   NewISRInstalled : Boolean;        { flag to indicate un-install needed }


 procedure SetPrintScreenFlag(var Regs : TRegisters); far;
 {-Set a flag to indicate that the Print Screen key was pressed}
 begin
   PrintScreenWasPressed := True;
 end;


 function InstallPrintScreenHandler : Boolean;
 {-Install real mode callback for SetPrintScreenFlag }
 { saving the real mode address in NewPrtScrISR, and }
 { the old real mode ISR address in OldPrtScrISR.    }
 const
   IsForInterruptHandler = True;
 begin
 { Call DPMI services to allocate a real mode callback for the new ISR }
   GetCallBack(SetPrintScreenFlag, IsForInterruptHandler, NewPrtScrISR);
 { Get the old ISR's address and install the new ISR }
   if @NewPrtScrISR <> Nil then
     begin
       GetRealIntVec($05, OldPrtScrISR);
       SetRealIntVec($05, @NewPrtScrISR);
       InstallPrintScreenHandler := True;
       PrintScreenWasPressed := False;    { be sure to clear flag for ISR }
       NewISRInstalled := True;           { indicate install okay }
     end
   else
     InstallPrintScreenHandler := False;
 end;


 procedure FreePrintScreenHandler;
 {-Free the real mode callback for SetPrintScreenFlag }
 begin
 { Restore the old Print Screen handler }
   SetRealIntVec(PrtScrInt,OldPrtScrISR);
 { Free the DPMI callback routine }
   DestroyCallBack(NewPrtScrISR);
 end;


 begin { program ExPrtScr }
 { Install and notify user }
   if InstallPrintScreenHandler then
     begin
       Writeln('New Print Screen handler installed.');
       Writeln('Press PrintScreen for message, any other key to quit.');
     end
   else
     Writeln('New Print Screen handler NOT installed ... press any key.');

 { Loop and show when the user pressed PrintScreen }
  repeat
     if PrintScreenWasPressed then
       begin
         Writeln(#7'Print Screen was pressed.');
         PrintScreenWasPressed := False;
       end;
   until Keypressed;

   if ReadKey = #0 then
     ; { do nothing -- just a call to get the key }

 { Remove the new ISR }
   if NewISRInstalled then
     begin
       FreePrintScreenHandler;
       Writeln('System''s previous PrintScreen function restored.');
     end;
 end. { program ExPrtScr }
