Unit Datelib;

Interface

uses
   Dos,
   StrLib;

const
   Months : array[1..12] of string[3]
            = ('JAN',  'FEB',  'MAR',  'APR',  'MAY',  'JUN',
               'JUL',  'AUG',  'SEP',  'OCT',  'NOV',  'DEC');
   Mois   : array[1..12] of string[4]
            = ('JANV', 'FEVR', 'MARS', 'AVRL', 'MAI ', 'JUIN',
               'JUIL', 'AOUT', 'SEPT', 'OCTB', 'NOVM', 'DECM');
   NumDays : array[1..12] of integer
             = (31, 29, 31, 30, 31, 30, 30, 31, 30, 31, 30, 31);

type
   TJulianDate = longint;

   TDate = record
      Day   : integer;
      Month : integer;
      Year  : integer;
      end;

Function SystemDate : longint;
Function DateToJulian ( D : TDate ) : longint;
Function ValidDay ( Day, Month : integer) : boolean;
Function ValidDate ( S : string ) : boolean;
Function ValidMonth ( Month : string ) : integer;
Function LeapYear ( Year : integer ) : boolean;
Function DateToStr ( Date : TDate ) : string;
Function JDateToStr ( JulianDate : TJulianDate ) : string;
Function StrToJDate ( S : string ) : TJulianDate;
Function ExactAge(D1, D2 : TDate) : integer;
Function DayOfWeek ( D : TDate ) : integer;
Function DayOfWeekStr ( D : TDate ) : string;
Function YearsDiff ( D1, D2 : TDate ) : integer;
Function JYearsDiff ( JD1, JD2 : TJulianDate ) : integer;

Procedure StrToDate ( S : string; var Date : TDate);
Procedure AssignDate ( var Date : TDate; DD, MM, YY : integer );
Procedure JulianToDate ( JD : longint; var Date : TDate );

Implementation

{========================================================================}

Function SystemDate : longint;

var
   DD, MM, YY, WW : word;
   Date : TDate;

Begin
   GetDate ( YY, MM, DD, WW );
   AssignDate ( Date, DD, MM, YY );
   SystemDate := DateToJulian ( Date );
End;

{========================================================================}

Function YearsDiff ( D1, D2 : TDate ) : integer;

Begin
   YearsDiff := abs ( D1.Year - D2.Year );
End;

{========================================================================}

Function JYearsDiff ( JD1, JD2 : TJulianDate ) : integer;

var
   D1, D2 : TDate;

Begin
   JulianToDate ( Jd1, D1 );
   JulianToDate ( Jd2, D2 );
   JYearsDiff := YearsDiff ( D1, D2 );
End;

{========================================================================}

Function ExactAge(D1, D2 : TDate) : integer;

  var
    Age : integer;

  Begin
    if DateToJulian ( D2 ) < DateToJulian ( D1 ) then
      begin
        ExactAge := 0;
        exit;
      end;
    Age := D2.Year - D1.Year;
    if D2.Month > D1.Month then
      dec(Age);
    if D2.Month = D1.Month then
      if D2.Day > D1.Day then
        dec(Age);
    ExactAge := Age;
  End;

{========================================================================}

Function DateToStr ( Date : TDate ) : string;

var
   DateStr, S : string [ 12 ];

Begin
   DateStr := '';
   S := IntToStr ( Date.Day );
   if length ( S ) = 1 then
     S := '0' + S;
   DateStr := DateStr + S + '-';

   S := Months [ Date.Month ];
   DateStr := DateStr + S + '-';

   S := IntToStr ( Date.Year );
   DateStr := DateStr + S;

   DateToStr := DateStr;
End;

{========================================================================}

Function JDateToStr ( JulianDate : TJulianDate ) : string;

var
   Date : TDate;

Begin
   JulianToDate ( JulianDate, Date );
   JDateToStr := DateToStr ( Date );
End;

{========================================================================}

Procedure StrToDate ( S : string; var Date : TDate);

var
   i : byte;
   Month : string [ 3 ];

Begin
   Date.Day := StrToInt ( S [ 1 ] + S [ 2 ] );
   Month := UpCaseStr ( copy ( S, 4, 3 ) );
   i := 1;
   {$B-}
   while ( i <= 12 ) and ( Month <> Months [ i ] ) do
     inc ( i );
   {$B+}
   Date.Month := i;
   Date.Year  := StrToInt ( copy ( S, 8, length ( S ) ) );
End;

{========================================================================}

Function StrToJDate ( S : string ) : TJulianDate;

var
   Date : TDate;

Begin
   StrToDate ( S, Date );
   StrToJDate := DateToJulian ( Date );
End;

{========================================================================}

Procedure AssignDate ( var Date : TDate; DD, MM, YY : integer );

Begin
   Date.Day   := DD;
   Date.Month := MM;
   Date.Year  := YY;
End;

{========================================================================}

Function ValidMonth ( Month : string ) : integer;

var
   i : integer;
   Found : boolean;

Begin
   Month := UpCaseStr ( Month );
   i := 1;
   Found := false;
   while ( not Found ) and ( i <= 12 ) do
      if Month = Months [ i ] then
         Found := true
      else
         inc ( i );

    if i > 12 then
       ValidMonth := 0
    else
       ValidMonth := i;
End;

{========================================================================}

Function ValidDay ( Day, Month : integer) : boolean;

Begin
   ValidDay := Day <= NumDays [ Month ];
End;

{========================================================================}

Function ValidDate ( S : string ) : boolean;

var
   Day, Month, Year : integer;

Begin
   Year := StrToInt ( copy ( S, 8, length ( S ) ) );

   Month := ValidMonth ( copy ( S, 4, 3 ) );
   if Month = 0 then
      begin
      ValidDate := false;
      exit;
      end;

   Day := StrToInt ( S [ 1 ] + S [ 2 ] );
   if ( LeapYear ( Year ) ) and ( Month = 2 ) then
      ValidDate := Day <= ( NumDays [ Month ] + 1 )
   else
      ValidDate := Day <= NumDays [ Month ];

End;

{========================================================================}

Function LeapYear ( Year : integer ) : boolean;

Begin
   LeapYear := (Year mod 4 = 0) and not ((Year mod 100 = 0)
                                and not ((Year mod 400 = 0)));
End;

{========================================================================}

Function DateToJulian ( D : TDate ) : longint;

var
   JD : longint;

Begin
   if D.Year < 100 then  { assume 19th century }
      inc ( D.Year, 1900 );
   JD := (D.Month - 14) div 12;
   JD := D.Day - 32075 + (1461 * (D.Year + 4800 + JD) div 4) +
                         (367 * (D.Month - 2 - JD * 12) div 12) -
                         (3 * ((D.Year + 4900 + JD) div 100) div 4);
   DateToJulian := JD;
End;

{========================================================================}

Procedure JulianToDate ( JD : longint; var Date : TDate );

var
   TempA, TempB, TempC : longint;

Begin
   TempA := JD + 68569;
   TempB := 4 * TempA div 146097;
   TempA := TempA - ( 146097 * TempB + 3 ) div 4;
   Date.Year := 4000 * ( TempA + 1 ) div 1461001;
   TempC := Date.Year;
   TempA := TempA - ( 1461 * TempC div 4 ) + 31;
   Date.Month := 80 * TempA div 2447;
   TempC := Date.Month;
   Date.Day := TempA - ( 2447 * TempC div 80 );
   TempA := Date.Month div 11;
   Date.Month := Date.Month + 2 - ( 12 * TempA );
   Date.Year := 100 * ( TempB - 49 ) + Date.Year + TempA;
End;

{========================================================================}

Function DayOfWeek ( D : TDate ) : integer;
{ Sunday=0, Monday=1, etc..., Saturday=6 }
var
   DW, Century : integer;

Begin
   if D.Year < 100 then
      inc ( D.Year, 1900 );
   dec ( D.Month, 2 );
   if ( D.Month < 1 ) or ( D.Month > 10 ) then
      begin
      inc ( D.Month, 12 );
      dec ( D.Year );
      end;
   Century := D.Year div 100;
   D.Year := D.Year mod 100;
   DW := ( trunc ( int ( 2.6 * D.Month - 0.2 ) ) + D.Day + D.Year +
         ( D.Year div 4 ) + ( Century div 4 ) - Century - Century ) mod 7;
   if DW < 0 then
      inc ( Dw, 7 );
   DayOfWeek := DW;
End;

{========================================================================}

Function DayOfWeekStr ( D : TDate ) : string;

const
   DayNames : array [ 0..6 ] of string [ 10 ]
              = ( 'Sunday', 'Monday', 'Tuesday', 'Wednesday',
                  'Thursday', 'Friday', 'Saturday' );
Begin
   DayOfWeekStr := DayNames [ DayOfWeek ( D ) ];
End;

{========================================================================}

End.