Unit EnumStrs;

{ enumerator field strings }

Interface

uses
   Global, Objects;

{ add enumerator id's here }
{ and the actual strings at the end of this file }
type
   TEnumId = ( enSmoker, enSex, enProvince );

type
   PEnumerator = ^TEnumerator;
   TEnumerator = object ( TCollection )
      MaxLen : word;
      Constructor Init ( NumItems : byte );
      Procedure CalcMaxLen;
      end;

var
   Enumerator : array [ TEnumId ] of PEnumerator;

Function SmokerStr ( Status : TSmoker ) : string;
Function SexStr ( Sex : TSex ) : string;
Function ProvinceStr ( Province : TProvince ) : string;

Implementation

{========================================================================}
{ Enumerator Collection object                                           }
{========================================================================}

Constructor TEnumerator.Init ( NumItems : byte );

Begin
   inherited Init ( NumItems, 0 );
End;

{========================================================================}

Procedure TEnumerator.CalcMaxLen;

var
   i : word;

Begin
   MaxLen := 0;
   for i := 0 to Count - 1 do
      if length ( PString ( At ( i ) )^ ) > MaxLen then
         MaxLen := length ( PString ( At ( i ) )^ );
End;

{========================================================================}
{ Functions for retrieving the strings within the enumerators            }
{========================================================================}

Function SexStr ( Sex : TSex ) : string;

Begin
   with Enumerator [ enSex ]^ do
      SexStr := PString ( At ( ord ( Sex ) ) )^;
End;

{========================================================================}

Function SmokerStr ( Status : TSmoker ) : string;

Begin
   with Enumerator [ enSmoker ]^ do
      SmokerStr := PString ( At ( ord ( Status ) ) )^;
End;

{========================================================================}

Function ProvinceStr ( Province : TProvince ) : string;

Begin
   with Enumerator [ enProvince ]^ do
      ProvinceStr := PString ( At ( ord ( Province ) ) )^;
End;

{========================================================================}

Begin
   { it would probably be better to put these strs into a resource file }
   Enumerator [ enProvince ] := New ( PEnumerator, Init ( 12 ) );
   with Enumerator [ enProvince ]^ do
      begin
      Insert ( NewStr ( 'Nova Scotia' ) );
      Insert ( NewStr ( 'New Brunswick' ) );
      Insert ( NewStr ( 'Newfoundland' ) );
      Insert ( NewStr ( 'Prince Edward Island' ) );
      Insert ( NewStr ( 'Quebec' ) );
      Insert ( NewStr ( 'Ontario' ) );
      Insert ( NewStr ( 'Manitoba' ) );
      Insert ( NewStr ( 'Saskatchewan' ) );
      Insert ( NewStr ( 'Alberta' ) );
      Insert ( NewStr ( 'British Columbia' ) );
      Insert ( NewStr ( 'Yukon' ) );
      Insert ( NewStr ( 'North West Territories' ) );
      CalcMaxLen;
      end;

   Enumerator [ enSmoker ] := New ( PEnumerator, Init ( 2 ) );
   with Enumerator [ enSmoker ]^ do
      begin
      Insert ( NewStr ( 'Smoker' ) );
      Insert ( NewStr ( 'Non Smoker' ) );
      CalcMaxLen;
      end;

   Enumerator [ enSex ] := New ( PEnumerator, Init ( 2 ) );
   with Enumerator [ enSex ]^ do
      begin
      Insert ( NewStr ( 'Male' ) );
      Insert ( NewStr ( 'Female' ) );
      CalcMaxLen;
      end;
End.
