unit NoiseLib ;

interface

uses
  crt ;

  procedure Note ( Frequency : word ; Duration : word ) ;

  procedure Blip ;
  procedure Bleep ;
  procedure Beep ;
  procedure Bloop ;
  procedure ThreeSlowBlips ;
  procedure ThreeFastBlips ;
  procedure FatalErrorBloop ;

implementation

  procedure Note ( Frequency : word ; Duration : word ) ;

  begin
    if Frequency > 0 then
      sound ( Frequency ) ;

    delay ( Duration ) ;
    nosound ;
  end;

  procedure Blip ;

  begin
    Note ( 4000, 15 ) ;
  end ;

  procedure Beep ;

  begin
    Note ( 750, 15 ) ;
  end ;

  procedure Bleep ;

  begin
    Note ( 2000, 80 ) ;
    Note ( 1000, 80 ) ;
    Note ( 2000, 80 ) ;
  end ;

  procedure Bloop ;

  begin
    Note ( 1000, 80 ) ;
    Note (  500, 80 ) ;
    Note ( 1000, 80 ) ;
  end ;

  procedure ThreeSlowBlips ;

  begin
    Blip ;
    Note ( 0, 200 ) ;
    Blip ;
    Note ( 0, 200 ) ;
    Blip ;
  end ;

  procedure ThreeFastBlips ;

  begin
    Blip ;
    Note ( 0, 20 ) ;
    Blip ;
    Note ( 0, 20 ) ;
    Blip ;
  end ;

  procedure FatalErrorBloop ;

  begin
    Bloop ;
    Note ( 0, 200 ) ;
    Bleep ;
  end ;

end.
