Program Test;

uses
   Global, Fields, EnumStrs,
   App, Objects, Drivers, Memory, Views, Menus, Dialogs;

const
  cmShowDialog = 1000;

type
   TDemo = object ( TApplication )
      Constructor Init;
      Procedure HandleEvent ( var Event: TEvent ); virtual;
      Procedure InitMenuBar; virtual;
      end;

{========================================================================}

Constructor TDemo.Init;

var
  Event : TEvent;

Begin
   inherited Init;

   with Event do
      begin
      Event.What := evCommand;
      Event.Command := cmShowDialog;
      PutEvent ( Event );
      end;
End;

{========================================================================}

Procedure TDemo.InitMenuBar;

var
  R: TRect;

Begin
   GetExtent ( R );
{   inc ( R.A.Y );}
   R.B.Y := R.A.Y + 1;
   MenuBar := New(PMenuBar, Init(R, NewMenu(
              NewSubMenu('~F~ile', hcNoContext, NewMenu(
                NewItem('~D~emo Dialog','', kbNoKey, cmShowDialog, hcNoContext,
                NewLine(
                NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext, nil)))),
              nil))));
End;

{========================================================================}

Procedure ShowDialog;

var
  Dialog : PDialog;
  R : TRect;
  Control : PView;
  DataRec : record
     Name : string [ 50 ];
     Age  : integer;
     Sex  : TSex;
     Smoker : TSmoker;
     Province : TProvince;
     Amount : real;
     end;

Begin
   R.Assign(14,4,60,18);
   Dialog := New ( PDialog, Init(R, 'New Client') );

   with Dialog^ do
      begin
      R.Assign(8,2,30,3);
      Control := New(PInputLine, Init(R, 50));
      Insert(Control);
      R.Assign(2,2,8,3);
      Insert(New(PLabel, Init(R, '~N~ame:', Control)));


      R.Assign(37,2,41,3);
      Control := New(PIntegerField, Init(R, '##'));
      Insert(Control);
      R.Assign(32,2,37,3);
      Insert(New(PLabel, Init(R, '~A~ge:', Control)));

      R.Assign(7,5,19,6);
      Control := New(PEnumeratorField, Init(R, enSex));
      Insert(Control);
      R.Assign(7,4,12,5);
      Insert(New(PLabel, Init(R, 'Se~x~:', Control)));

      R.Assign(22,5,38,6);
      Control := New(PEnumeratorField, Init(R, enSmoker));
      Insert(Control);
      R.Assign(22,4,38,5);
      Insert(New(PLabel, Init(R, '~S~moking Status:', Control)));

      R.Assign(12,8,43,9);
      Control := New(PEnumeratorField, Init(R, enProvince));
      Insert(Control);
      R.Assign(2,8,12,9);
      Insert(New(PLabel, Init(R, '~P~rovince:', Control)));

      {try a few variations!}
      { eg.  no decimals, percent sign, no commas, no dollar sign, etc }
      R.Assign(12,9,43,10);
      Control := New(PRealField, Init(R, '$###,###.##'));
      Insert(Control);
      R.Assign(2,9,12,10);
      Insert(New(PLabel, Init(R, '~A~mount:', Control)));

      R.Assign(10,11,18,13);
      Control := New(PButton, Init(R, 'O~k~', cmOK, bfDefault ));
      Insert(Control);

      R.Assign(25,11,35,13);
      Control := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
      Insert(Control);

      SelectNext(False);
      end;

   with DataRec do
      begin
      Name := '';
      Age := 20;
      Sex := Male;
      Smoker := NonSmoker;
      Province := NS;
      Amount := 100.0;
      end;

   Dialog^.SetData ( DataRec );
   DeskTop^.ExecView ( Dialog );
   Dialog^.SetData ( DataRec );

   Dispose ( Dialog, Done );
End;

{========================================================================}

Procedure TDemo.HandleEvent;

Begin
   inherited HandleEvent ( Event );
   if Event.What = evCommand then
      begin
      case Event.Command of
         cmShowDialog : ShowDialog;
         else Exit;
         end;
      ClearEvent ( Event );
      end;
End;

{========================================================================}

var
  Demo : TDemo;

Begin
   Demo.Init;
   Demo.Run;
   Demo.Done;
End.
