(*  Code Listings for Article "Colour by Vision"
    by Hans van der Veeke
    Issue 3 of The Pascal Magazine
    ============================================ *)


(* LISTING 1 *)

    PMyWindow = ^TMyWindow;
    TMyWindow = OBJECT(TWindow)
      CONSTRUCTOR Init(R : TRect; Header: String; Nr : INTEGER);
    END;

    PMyView = ^TMyView;
    TMyView = OBJECT(TView)
      PROCEDURE Draw; VIRTUAL;
    END;

    CONSTRUCTOR TMyWindow.Init(R : TRect; Header : String; Nr : INTEGER);
    VAR    Inside : PMyView;
    BEGIN
      Inherited Init(R, Header, Nr);
      GetClipRect(R);
      R.Grow(-1, -1);
      Inside := (New(PMyView, Init(R)));
      Insert(Inside);
    END;

    PROCEDURE TMyView.Draw;
    VAR     ScreenBuffer : TDrawBuffer;
    BEGIN
      Inherited Draw;
      WriteStr(1, 1, 'What color am I ?', 1);
      MoveChar(ScreenBuffer, ' ', GetColor(2), Size.X);
      MoveStr(ScreenBuffer, 'And what is my color ?', GetColor(2));
      WriteLine(1, 2, Size.X, 1, ScreenBuffer);
      WriteStr(1, 3, 'Red alert on the Enterprise...', $1E)
    END;

  PROCEDURE TMyApp.DemoView;
  VAR  R : TRect;
  BEGIN
    R.Assign(20, 5, 60, 15);
    DeskTop^.Insert(New(PMyWindow, Init(R, 'Demo Window', wnNoNumber)));
  END;


(* IN-TEXT CODE FROM PAGE 25 *)

   FUNCTION TMyWindow.GetPalette : PPalette;

   CONST
     MyColors = cBlueWindow + #69;
     P        : STRING[Length(MyColors)] = MyColors;

   BEGIN
     GetPalette := @P;
   END;


   FUNCTION TMyApplication.GetPalette : PPalette;

   CONST
     MyColors = cAppColor + #$3D;
     P        : STRING[Length(MyColors)] = MyColors;

   BEGIN
     GetPalette := @P;
   END;



(* LISTING 2 *)

   FUNCTION TMyStaticText.GetPalette : PPalette;

   CONST
     MyColors = #33;
     P        : STRING[Length(MyColors)] = MyColors;

   BEGIN
     GetPalette := @P;
   END;

   FUNCTION TMyDialog.GetPalette : PPalette;

   CONST
     MyColors = CGrayDialog + #128;
     P        : STRING[Length(MyColors)] = MyColors;

   BEGIN
     GetPalette := @P;
   END;

   FUNCTION TMyApplication.GetPalette : PPalette;

   CONST
     MyColors = CAppColor + #$3D;
     P        : STRING[Length(MyColors)] = MyColors;

   BEGIN
     GetPalette := @P;
   END;

