program TestEZ1;

{ Program used in testing EZDPMI. This is a realmode program
  that sets up an interrupt handler on interrupt $66, and then
  calls COMMAND.COM. The program can be unloaded by typing EXIT
  at the DOS command prompt - a simple TSR.

  Functions supported via this INT $66 handler are:
    AX=0: Fill the block pointed to by ES:DI with the string
          'The quick brown fox jumps over the lazy dog'
    AX=1: Returns the address of a realmode routine in CX:DX
          that does the same as calling INT $66 with AX=0.
    AX=2: Returns the value of SP in AX

  The companion program TestEZ2 will test the relevant EZDPMI
  routines by interfacing with this one. }

{$IFNDEF MSDOS} !! ERROR: this should be a real mode program {$ENDIF}

{$M 2048,0,0} {No heap}

uses
  DOS;

const
  TheSentence : string[45] =
     'The quick brown fox jumps over the lazy dog';

procedure WriteSentence; far;
assembler;
  asm
    push ds
    push si
    push cx
    pushf
    mov si, seg @Data
    mov ds, si
    lea si, TheSentence
    mov cx, 46
    cld
    rep movsb
    popf
    pop cx
    pop si
    pop ds
  end;

procedure Int66Handler;
assembler;
  asm
    pushf
    or ax, ax
    jnz @@TryFunction1
    call WriteSentence
    jmp @@Exit
  @@TryFunction1:
    cmp ax, 1
    jne @@TryFunction2
    mov cx, cs
    lea dx, WriteSentence
  @@TryFunction2:
    cmp ax, 2
    jne @@Exit
    mov ax, sp
  @@Exit:
    popf
    iret
  end;

var
  Saved66 : pointer;

begin
  GetIntVec($66, Saved66);
  SetIntVec($66, @Int66Handler);
  writeln('EZDPMI test suite TSR loaded, type EXIT to unload.');
  SwapVectors;
  Exec(GetEnv('COMSPEC'), '');
  SwapVectors;
  SetIntVec($66, Saved66);
  writeln('EZDPMI test suite TSR unloaded.');
end.