program TestEZ2;

{ Program used in testing EZDPMI. This is a protected mode or Windows
  program that calls interrupt $66. This interrupt has been set up by
  TSR program TESTEZ1 - see the source for that program for details.}

{$IFDEF MSDOS} !! Error - should be a protected mode program {$ENDIF}

uses
{$IFDEF Windows}
  WinCrt,
{$ENDIF}
  WinDOS, EZDPMI;

procedure ReportDPMIerror(WentOK : boolean);
  begin
    if not WentOK then
      begin
        writeln;
        writeln('DPMI error');
        Halt(1);
      end;
  end;

type
  OS = record O, S : word; end;
  ByteArray = array [0..15] of byte;

var
  i : integer;
  ProtProc : ^ByteArray;
  RealProcedure : RealProc;
  RealPStr, ProtPStr : ^string;
  Regs : TRegisters;
  WordArray : array [0..2] of word;

begin
  { First allocate a DOS memory block }
  writeln('Allocating DOS block');
  ReportDPMIError(DOSGetMem(RealPStr, ProtPStr, sizeof(string)));

  { Try writing to it }
  writeln('Writing to DOS block');
  ProtPStr^ := 'The cat sat on the mat';

  { Try reading to it }
  writeln('Reading DOS block');
  writeln('==[', ProtPStr^, ']==');

  { Call int $66, with AX=0, ES:DI pointing to our DOS block }
  writeln('Calling INT $66 with AX=0: write to ES:DI');
  FillChar(Regs, sizeof(Regs), 0);
  with Regs do
    begin
      ax := 0;
      es := OS(RealPStr).S;
      di := OS(RealPStr).O;
    end;
  ReportDPMIError(RealIntr($66, Regs));

  { Try reading the DOS block again }
  writeln('Reading DOS block again');
  writeln('==[', ProtPStr^, ']==');

  { Scrub it clean }
  writeln('Scrubbing DOS block - ready for next test');
  FillChar(ProtPStr^, sizeof(string), $21);
  writeln('==[', ProtPStr^, ']==');

  { Call int $66, with AX=1 to get address of real mode proc}
  writeln('Calling INT $66 with AX=1: get realmode proc');
  FillChar(Regs, sizeof(Regs), 0);
  with Regs do
    begin
      ax := 1;
    end;
  ReportDPMIError(RealIntr($66, Regs));
  @RealProcedure := Ptr(Regs.cx, Regs.dx);

  { Map a protected mode pointer onto this procedure }
  writeln('Mapping a protected mode pointer onto realmode proc');
  ReportDPMIError(GetMappedDPMIPtr(ProtProc, @RealProcedure, 128));

  { Read the first few bytes of this procedure }
  writeln('Reading the first few bytes of this procedure');
  writeln('Should read:  30  86  81 156 190');
  write  ('         ==>');
  for i := 0 to 4 do
    write(ProtProc^[i]:4);
  writeln;

  { free the mapped protected mode pointer }
  writeln('Freeing the mapped protected mode pointer');
  ReportDPMIError(FreeMappedDPMIPtr(ProtProc));

  { Call the real mode procedure }
  writeln('Calling the real mode procedure');
  for i := 0 to 2 do
    WordArray[i] := i*i + 3;
  FillChar(Regs, sizeof(Regs), 0);
  with Regs do
    begin
      es := OS(RealPStr).S;
      di := OS(RealPStr).O;
    end;
  ReportDPMIError(RealCall(RealProcedure, Regs, 3, @WordArray));

  { Try reading the DOS block again }
  writeln('Reading DOS block again');
  writeln('==[', ProtPStr^, ']==');

  { Dispose of our DOS block }
  writeln('Disposing DOS block');
  ReportDPMIError(DOSFreeMem(ProtPStr));

  writeln('--Done--');

  { Call int $66, with AX=2 to get value of realmode SP }
  writeln('Calling INT $66 with AX=2: get SP value');
  FillChar(Regs, sizeof(Regs), 0);
  with Regs do
    begin
      ax := 2;
    end;
  ReportDPMIError(RealIntr($66, Regs));
  writeln('Realmode SP: ', Regs.ax);

end.