program XCrtErr;

{ Example program showing the use of the EZCrtErr unit to
  trap critical errors.

  Copyright (c) 1994, Julian M. Bucknall }

uses
  Crt,
  Printer,
  EZCrtErr;

var
  PrinterRetry : word;

function MyInt24(var CED : TCritErrData) : TCritErrResponse; far;
  begin
    {Fail all errors, except retry printer errors 5 times}
    if CED.IsBlockDevice then
      MyInt24 := cerFail
    else
      begin
        inc(PrinterRetry);
        if (PrinterRetry > 5) then
             MyInt24 := cerFail
        else MyInt24 := cerRetry
      end;
  end;

var
  F : file;
  Ch : char;
  I : integer;

begin
  InstallCritErrHandler(MyInt24);

  writeln('Trying to print to the printer. Ensure that it is disconnected.');
  write('Press any key...');
  Ch := ReadKey;
  writeln;

  PrinterRetry := 0;
  writeln(lst, 'hello');
  I := IOResult;
  writeln('I/O error: ', I, ' (tried ', PrinterRetry, ' times)');

  writeln('Trying to read from the diskette drive. Ensure that it is empty.');
  write('Press any key...');
  Ch := ReadKey;
  writeln;

  Assign(F, 'a:\test');
  Reset(F);
  I := IOResult;
  writeln('I/O error: ', I);
  if (I = 0) then
    Close(F);
end.