program XCtlBrk;

{ Example program showing the use of the EZCtlBrk unit to
  trap Ctrl+Break. Note that the BIOS translates the
  Ctrl+Break to a ^C character and places it in the
  keyboard buffer before calling Int $1B.

  Copyright (c) 1994, Julian M. Bucknall }

uses
  Crt,
  EZCtlBrk;

var
  Ch : char;
  Count :integer;

begin
  writeln('Press Ctrl+Break 5 times');
  writeln('(any other key terminates)');

  InstallCtrlBreakHandler;

  Ch := ^C;
  Count := 0;
  repeat
    if CtrlBreakWasHit then
      begin
        write('+');
        inc(Count);
      end;
    if KeyPressed then
      Ch := ReadKey;
  until (Count = 5) or (Ch <> ^C);

  RemoveCtrlBreakHandler;
end.
