program GetPointer;

{ This program will link into either a C++ DLL made from
  PtrUnit.Cpp or a Pascal DLL made from PtrUnit.Pas. }

uses WinTypes, WinProcs, PtrUnit, Strings;

const
  AppName = 'GetPtrP';

procedure GetPtrP_OnLButtonDown(Window: HWnd);
var
  Temp, S: PChar;
  DC: HDC;
  NumAry: TNumAry;
  i: Integer;
begin
  GetMem(S, 100);
  DC := GetDC(GetFocus);
  Temp :=  PChar(GetPtr);
  wvsprintf(S, 'The data is: %s ', Temp);
  TextOut(DC, 10, 40, S, StrLen(S));

  for i := 0 to 20 do
    NumAry[i] := i * 3;
  WriteData(DC, NumAry);

  ReleaseDC(GetFocus, DC);
  FreeMem(S, 100);
end;

procedure GetPtrP_OnPaint(Window: HWnd);
var
  PaintDC: HDC;
  PaintStruct: TPaintStruct;
begin
  PaintDC := BeginPaint(Window, PaintStruct);
  TextOut(PaintDC, 10, 10, 'Click left mouse button', 23);
  EndPaint(Window, PaintStruct);
end;

function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  AboutProc: TFarProc;
begin
  WindowProc := 0;
  case Message of
    wm_Destroy: begin
      PostQuitMessage(0);
      exit;
    end;
    wm_LButtonDown: GetPtrP_OnLButtonDown(Window);
    wm_Paint: GetPtrP_OnPaint(Window);
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;

procedure WinMain;
var
  Window: HWnd;
  Message: TMsg;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: AppName;
    lpszClassName: AppName);
begin
  if HPrevInst = 0 then
  begin
    WindowClass.hInstance := HInstance;
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    if not RegisterClass(WindowClass) then Halt(255);
  end;
  Window := CreateWindow(
    AppName,
    'Turbo Pascal GetPtrP',
    ws_OverlappedWindow,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  ShowWindow(Window, CmdShow);
  UpdateWindow(Window);
  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;
  Halt(Message.wParam);
end;

begin
  WinMain;
end.
