///////////////////////////////////////////////////
// pointers.cpp                                  //
// programmer: Charlie Calvert                   //
///////////////////////////////////////////////////

#define STRICT
#include <windows.h>
#include <string.h>



extern "C" long CALLBACK _export WndProc(HWND, UINT, WPARAM, LPARAM);
extern "C" void far * CALLBACK GetPtr(void);
extern "C" int CALLBACK _export WriteData(HDC DC, int far * Num);

int CALLBACK WriteData(HDC DC);

#pragma argsused

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR  lpszCmdParam, int nCmdShow)
	{
	static char szAppName[] = "MyDll";
	HWND hWindow;
	MSG  Msg;
	WNDCLASS WndClass;

	if (!hPrevInstance)
		{
		WndClass.style		= CS_HREDRAW | CS_VREDRAW;
		WndClass.lpfnWndProc	= (WNDPROC)WndProc;
		WndClass.cbClsExtra     = 0;
		WndClass.cbWndExtra	= 0;
		WndClass.hInstance	= hInstance;
		WndClass.hIcon		= LoadIcon(NULL, IDI_APPLICATION);
		WndClass.hCursor	= LoadCursor(NULL, IDC_ARROW);
		WndClass.hbrBackground  = (HBRUSH)GetStockObject(WHITE_BRUSH);
		WndClass.lpszMenuName	= NULL;
		WndClass.lpszClassName  = szAppName;

		RegisterClass (&WndClass);
		}

	hWindow = CreateWindow(szAppName,
		"Pointers",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);

	ShowWindow(hWindow, nCmdShow);
	UpdateWindow(hWindow);

	while (GetMessage(&Msg, NULL, 0, 0))
		{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
		}
	return Msg.wParam;
	}

long FAR PASCAL _export WndProc(HWND hWindow, UINT Message, WPARAM wParam, LPARAM lParam)
{
  char S[25];
  int Num[25];
  HDC DC;
  PAINTSTRUCT PaintStruct;

  switch(Message)
  {
    case WM_DESTROY:
      PostQuitMessage(0);
      return 0;

    case WM_LBUTTONDOWN:
      DC = GetDC(hWindow);
      for (int i = 0; i < 25; i++)
        Num[i] = i * 2;
      WriteData(DC, Num);
      wsprintf(S, "The data is: %s", (void far *)GetPtr());
      TextOut(DC, 10, 40, S, strlen(S));
      ReleaseDC(hWindow, DC);
      return 0;

    case WM_PAINT:
      DC = BeginPaint(hWindow, &PaintStruct);
      TextOut(DC, 10, 10, "Click left mouse button.", 24);
      EndPaint(hWindow, &PaintStruct);
      return 0;
  }

  return DefWindowProc(hWindow, Message, wParam, lParam);
}
