#include <windows.h>
#include <string.h>
#include "printinf.h"

extern "C" long FAR PASCAL _export WndProc(HWND hWindow, WORD Message, WORD wParam, LONG lParam);

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR  lpszCmdParam, int nCmdShow)
	{
	static char szAppName[] = "Generic";
	HWND hWindow;
	MSG  Msg;
	WNDCLASS WndClass;

	if (!hPrevInstance)
		{
		WndClass.style		= CS_HREDRAW | CS_VREDRAW;
		WndClass.lpfnWndProc	= (WNDPROC)WndProc;
		WndClass.cbClsExtra     = 0;
		WndClass.cbWndExtra	= 0;
		WndClass.hInstance	= hInstance;
		WndClass.hIcon		= LoadIcon(NULL, IDI_APPLICATION);
		WndClass.hCursor	= LoadCursor(NULL, IDC_ARROW);
		WndClass.hbrBackground  = GetStockObject(WHITE_BRUSH);
		WndClass.lpszMenuName	= NULL;
		WndClass.lpszClassName  = szAppName;

		RegisterClass (&WndClass);
		}

	hWindow = CreateWindow(szAppName,
		"The Dll Experiment",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInstance,
		NULL);

	ShowWindow(hWindow, nCmdShow);
	UpdateWindow(hWindow);

	while (GetMessage(&Msg, NULL, 0, 0))
		{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
		}
	return Msg.wParam;
	}

long FAR PASCAL _export WndProc(HWND hWindow, WORD Message, WORD wParam, LONG lParam)
{
	HDC DC;
	PAINTSTRUCT PaintStruct;
	char S[100];


	switch(Message)
	{
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;

		case WM_PAINT:
			DC = BeginPaint(hWindow, &PaintStruct);
			GetPrinter(S);
			TextOut(DC, 10, 10, S, strlen(S));
			DriverVersion(DC);
			EndPaint(hWindow, &PaintStruct);
     	return 0;
	}

	return DefWindowProc(hWindow, Message, wParam, lParam);
}
