{$I SHDEFINE.INC}

{$I SHUNITSW.INC}

{$V-}

unit TestFin;
{This unit tests the ShFinanc unit over a range of values. Both Ordinary
 Annuities and Annuities Due are tested.}

interface

uses
  TpCrt,
  TpDos,
  TpString,
  shFinanc,
  shErrMsg;

procedure TestFinance;

implementation

type
{$IFNDEF Gen87}
  extended = real;
  Float           = real;
{$ELSE}
  Float           = extended;
{$ENDIF}

const
  TestDesc  : array[1..6] of string[65] =
      ('In the following, for each set of I(nterest rate), N(umber of',
       'payments), and T(ype of annuity, an expected result for the',
       'calculation being performed will be displayed, followed by the',
       'actual result. The expected results are taken from the appro-',
       'priate tables in Smail, L.L., "Mathematics of Finance",',
       'McGraw-Hill, 1953.');

  IntTstDsc : array[1..10] of string[65] =
       ('In the following interactive test, you will be asked for three',
        'values; Interest (if percentage suffix with a "%"), Number of Pay-',
        'ment Periods, and Type of the annuity ((O)rdinary (i.e., payments',
        'are made at the END of the conversion period), and (D)ue (the',
        'payments are made at the BEGINNING of the conversion period)).',
        'Following input of the annuity type, calculated results will be',
        'displayed.',
        '',
        'The sequence will be repeated as often as desired. Use an inter-',
        'est rate of 0 to exit the program.');

  NumI  = 4;
  NumN  = 4;
  NumT  = 4;
  NumTst= 6;
  TestTtl   : array[1..NumTst] of string[25] =
               ('Compound Amount',
                'Compound Present Value',
                'Annuity Amount',
                'Annuity Present Value',
                '''N'' from Ann. Pres. Val.',
                '''I'' from Ann. Pres. Val.');
  TestsI    : array[1..NumI] of extended =
                (0.005, 0.030, 0.050, 0.080);
  TestsN    : array[1..NumN] of integer   =
                (  1, 33, 70, 100);
  TestsT    : array[AnnType] of string[18] =
                ('Ordinary Annuity', 'Annuity Due');
  TestsE    : array[1..NumI, 1..NumN, AnnType, 1..NumT] of Float =
       (
       {I = 0.005}
         (
         {N = 1}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0050000, 0.9950249,     1.0000000,  0.9950249   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0050000, 0.9950249,     1.0050000,  1.0000000   )
                                                   {End of N =   1}),

         {N = 33}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.1789083, 0.8482424,    35.7816669, 30.3515259   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.1789083, 0.8482424,    35.9605752, 30.5032835   )
                                                   {End of N =  33}),

         {N = 70}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.4178305, 0.7053029,    83.5661055, 58.9394176   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.4178305, 0.7053029,    83.9839360, 59.2341147   )
                                                   {End of N =  70}),

         {N = 100}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.6466685, 0.6072868,   129.3336984, 78.5426448   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.6466685, 0.6072868,   129.9803669, 78.9353580   )
                                                   {End of N = 100})
                                                 {End of I = 0.005}),

       {I = 0.030}
         (
         {N = 1}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0300000, 0.9708738,     1.0000000,  0.9708738   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0300000, 0.9708738,     1.0300000,  1.0000000   )
                                                   {End of N =   1}),

         {N = 33}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   2.6523352, 0.3770262,    55.0778413, 20.7657918   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   2.6523352, 0.3770262,    56.7301765, 21.3887656   )
                                                   {End of N =  33}),

         {N = 70}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   7.9178219, 0.1262974,   230.5940637, 29.1234214   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   7.9178219, 0.1262974,   237.5118856, 29.9971240   )
                                                   {End of N =  70}),

         {N = 100}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  19.2186320, 0.0520328,   607.2877327, 31.5989053   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  19.2186320, 0.0520328,   625.5063647, 32.5468725   )
                                                   {End of N = 100})
                                                 {End of I = 0.030}),

       {I = 0.050}
         (
         {N = 1}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0500000, 0.9523810,     1.0000000,  0.9523810   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0500000, 0.9523810,     1.0500000,  1.0000000   )
                                                   {End of N =   1}),

         {N = 33}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   5.0031885, 0.1998725,    80.0637708, 16.0025492   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   5.0031885, 0.1998725,    84.0669593, 16.8026767   )
                                                   {End of N =  33}),

         {N = 70}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  30.4264255, 0.0328662,   588.5285107, 19.3426766   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  30.4264255, 0.0328662,   617.9549362, 20.3098104   )
                                                   {End of N =  70}),

         {N = 100}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             ( 131.5012578, 0.0076045,  2610.0251569, 19.8479102   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             ( 131.5012578, 0.0076045,  2740.5264147, 20.8403057   )
                                                   {End of N = 100})
                                                 {End of I = 0.050}                  ),

       {I = 0.080}
         (
         {N = 1}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0800000, 0.9259259,   1.0000000,    0.9259259   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (   1.0800000, 0.9259259,   1.0800000,    1.0000000  )
                                                  {End of N =   1}),

         {N = 33}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  12.6760496, 0.0788889,   145.9506204, 11.5138884   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (  12.6760496, 0.0788889,   157.6266700, 12.4349995   )
                                                   {End of N =  33}),

         {N = 70}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             ( 218.6064059, 0.0045744,  2720.0800738, 12.4428196   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             ( 218.6064059, 0.0045744,  2937.6864797, 13.4382452   )
                                                   {End of N =  70}),

         {N = 100}
           (
           {T = Ordinary}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (2199.7612563, 0.0004546, 27484.5157043, 12.4943176   ),
           {T = Due}
             {Comp. Amt}   {Pres. Val}  {Ann.  Amt}  {Ann Pres Val}
             (2199.7612563, 0.0004546, 29683.2769606, 13.4938630   )
                                                   {End of N = 100})
                                                 {End of I = 0.080})
                                         {End of TestsE Definition});

  RW  : byte = 14;    {Field width for real-type reference values}
  RP  : byte =  7;    {Decimal places for real-type reference values}
  ISp =  5;           {Interest lead-in spacing}
  NSp =  7;           {Num Pay  lead-in spacing}
  TSp =  9;           {Type     lead-in spacing}
  FSp = 11;           {Function lead-in spacing}
  VSp = 13;           {Value    lead-in spacing}

procedure TestFinance;
  var
    ISt : string;
    EC  : integer;
    E1,
    I,
    APV,
    IPV : Float;
    N   : integer;
    T   : AnnType;
    TT  : string;
    IxI,                            {Interest index}
    IxN,                            {Payment periods index}
    IxTT: ShortInt;                 {Tests index}
    IxT : AnnType;                  {Annuity type index}
    S1  : string;
    O   : text;

  procedure AnyKey;
    begin
      if HandleIsConsole(1) then begin
        Write('Any key to continue... ');
        if ReadKey = #0 then ;
        GoToXY(1, WhereY);
        DelLine;
        end;
      end;

  procedure WriteValue(E : Float);
    begin
      S1 := finErrMsg(finErrCode);
      if S1 = '' then
        WriteLn(O, E:FW:DP)
      else
        WriteLn(O, S1);
      end;

  procedure WriteIvalue(I : integer);
    begin {WriteIvalue}
      S1 := finErrMsg(finErrCode);
      if S1 = '' then
        WriteLn(O, I:IW)
      else
        WriteLn(O, S1);
      end; {WriteIvalue}

  begin {TestFinance}
    if OpenStdDev(O, 1) then ;
    CheckOn;
    finErrCheckOff;

    WriteLn(O);
    for N := 1 to 6 do
      WriteLn(O, '':5,TestDesc[N]);

    for IxI := 1 to NumI do begin
      I := TestsI[IxI];
      for IxN := 1 to NumN do begin
        N := TestsN[IxN];
        for IxT := Ordinary to Due do begin
          for IxTT := 1 to NumTst do begin
            case IxTT of
              1 : begin
                    WriteLn(O);
                    AnyKey;
                    WriteLn(O, '':ISp,'For I = ',(I*100.0):3:1,'%');
                    WriteLn(O, '':NSp,'For N = ', N:3);
                    WriteLn(O, '':TSp,'For Type = ',TestsT[IxT]);

                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    WriteValue(CompAmount(N, I));
                    WriteLn(O, '':VSp,'Reference  = ',
                                  TestsE[IxI, IxN, IxT, IxTT]:RW:RP);
                    end;
              2 : begin
                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    WriteValue(CompPresVal(N, I));
                    WriteLn(O, '':VSp,'Reference  = ',
                                  TestsE[IxI, IxN, IxT, IxTT]:RW:RP);
                    end;
              3 : begin
                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    WriteValue(AnnuityAmount(N, I, IxT));
                    WriteLn(O, '':VSp,'Reference  = ',
                                  TestsE[IxI, IxN, IxT, IxTT]:RW:RP);
                    end;
              4 : begin
                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    APV := AnnuityPresVal(N, I, IxT);
                    WriteValue(APV);
                    WriteLn(O, '':VSp,'Reference  = ',
                                  TestsE[IxI, IxN, IxT, IxTT]:RW:RP);
                    end;
              5 : begin
                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    WriteIvalue(NumPay(APV, I, IxT));
                    WriteLn(O, '':VSp,'Reference  = ',
                                  N:IW);
                    end;
              6 : begin
                    WriteLn(O, '':FSp,'For Function = ',TestTtl[IxTT]);
                    Write  (O, '':VSp,'Calculated = ');
                    WriteValue(IfromPresVal(APV, N, IxT, 1.0E-9));
                    WriteLn(O, '':VSp,'Reference  = ',
                                  I:RW:RP);
                    end;
              end; {case}
            end; {for IxTT}

            if (IxT = Due)                  and
              ((IxN < NumN)       or
               (IxI < NumI))                and
               (not (HandleIsConsole(1)))   then begin
              Write(O, ^L);
              end;

          end; {for IxT}
        end; {for IxN}
      end; {for IxI}

    WriteLn(O);
    AnyKey;

    if not HandleIsConsole(1) then begin
      WriteLn(O, '':TSp,
              'Interactive mode testing not available under redirection.');
      Close(O);
      exit;
      end;

    WriteLn;
    for N := 1 to 10 do
      WriteLn('':5,IntTstDsc[N]);
    WriteLn;

    repeat
      write('     ..Interest rate  '); readln(ISt);
      Val(ISt, I, EC);
      if (EC <> 0) and (ISt[EC] = '%') then begin
        ISt[0] := char(pred(EC));
        Val(ISt, I, EC);
        if EC = 0 then begin
          I := I / 100.0;
          end
        else begin
          I := 0.0;
          end;
        end;
      if I <= 0.0 then
        exit;
      write('Number of payments  '); readln(N);
      write('   Type of annuity  '); readln(TT);
      finErrCheckOff;
      case Upcase(TT[1]) of
        'O' : T := Ordinary;
        'D' : T := Due;
        end; {case}
      APV := AnnuityPresVal(N, I, T);
      writeln;
      writeln('Annuity present value = ',APV:FW:DP);
      write(finErrMsg(finErrCode)); if WhereX <> 1 then WriteLn;
      writeln('Number of payments = ',NumPay(APV, I, T):IW);
      write(finErrMsg(finErrCode)); if WhereX <> 1 then WriteLn;
      writeln;
      writeln('Ann. pres. val. as discounted ann. amt. = ',
               (CompPresVal(N, I) * AnnuityAmount(N, I, T)):FW:DP);
      write(finErrMsg(finErrCode)); if WhereX <> 1 then WriteLn;
      writeln;
{$IFDEF Gen87}
      IPV := IfromPresVal(APV, N, T, 1.0E-15);
{$ELSE}
      IPV := IfromPresVal(APV, N, T, 1.0E-09);
{$ENDIF}
      write(finErrMsg(finErrCode)); if WhereX <> 1 then WriteLn;
      writeln('Interest rate = ',IPV:FW:DP);
      writeln;
      writeln(Center('* * * * * * * * * * * * * * * * *', 72));
      writeln;
      until false;
    end; {TestFinance}
  end.
